/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.transportrings;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;

public class TransportRingsAddress
implements INBTSerializable<NBTTagCompound> {
    public static final int MAX_SYMBOLS = 4;
    protected List<SymbolInterface> address = new ArrayList<SymbolInterface>(4);
    protected SymbolTypeTransportRingsEnum symbolType;

    public TransportRingsAddress(SymbolTypeTransportRingsEnum symbolType) {
        this.symbolType = symbolType;
    }

    public TransportRingsAddress(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    public TransportRingsAddress(List<SymbolInterface> addressList) {
        this.address = addressList;
    }

    public TransportRingsAddress generate(Random random) {
        if (!this.address.isEmpty()) {
            JSG.error("Tried to regenerate address already containing symbols");
            return this;
        }
        while (this.address.size() < 4) {
            SymbolInterface symbol = this.symbolType.getRandomSymbol(random);
            if (this.address.contains(symbol)) continue;
            this.address.add(symbol);
        }
        return this;
    }

    public void clear() {
        this.address.clear();
    }

    public SymbolTypeTransportRingsEnum getSymbolType() {
        return this.symbolType;
    }

    public void setSymbolType(SymbolTypeTransportRingsEnum symbolType) {
        this.symbolType = symbolType;
    }

    public void add(SymbolInterface symbol) {
        this.address.add(symbol);
    }

    public void addAll(TransportRingsAddress ringsAddress) {
        if (this.address.size() + ringsAddress.address.size() > 4) {
            JSG.error("Tried to add symbols to already populated address");
            return;
        }
        this.address.addAll(ringsAddress.address);
    }

    public boolean contains(SymbolInterface symbol) {
        return this.address.contains(symbol);
    }

    public SymbolInterface getLast() {
        if (this.address.size() < 1) {
            return this.symbolType.getOrigin();
        }
        return this.address.get(this.address.size() - 1);
    }

    public TransportRingsAddress stripOrigin() {
        return new TransportRingsAddress(this.address.subList(0, this.address.size() - 1));
    }

    public boolean equalsV2(TransportRingsAddress address, int checkLength) {
        if (address.size() < checkLength || this.address.size() < checkLength) {
            return false;
        }
        for (int i = 0; i < address.size() && i + 1 <= checkLength; ++i) {
            if (this.address.size() >= i + 1) {
                if (this.address.get(i) == address.get(i)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int size() {
        return this.address.size();
    }

    public SymbolInterface get(int i) {
        if (i >= this.address.size()) {
            return this.symbolType.getOrigin();
        }
        return this.address.get(i);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("symbolType", this.symbolType.id);
        try {
            compound.func_74768_a("addressLength", this.address.size());
            for (int i = 0; i < this.address.size(); ++i) {
                compound.func_74768_a("addressSymbol" + i, this.address.get(i).getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (!this.address.isEmpty()) {
            JSG.error("Tried to deserialize address already containing symbols");
            return;
        }
        this.symbolType = SymbolTypeTransportRingsEnum.valueOf(compound.func_74762_e("symbolType"));
        int length = compound.func_74762_e("addressLength");
        for (int i = 0; i < length; ++i) {
            this.address.add(this.symbolType.getSymbol(compound.func_74762_e("addressSymbol" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.symbolType.id);
        buf.writeInt(this.address.size());
        for (SymbolInterface symbol : this.address) {
            if (symbol == null) continue;
            buf.writeInt(symbol.getId());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.symbolType = SymbolTypeTransportRingsEnum.valueOf(buf.readInt());
        try {
            if (!this.address.isEmpty()) {
                JSG.error("Tried to deserialize address already containing symbols");
                return;
            }
            int length = buf.readInt();
            for (int i = 0; i < length; ++i) {
                this.address.add(this.symbolType.getSymbol(buf.readInt()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder stringAddress = new StringBuilder();
        if (this.address == null || this.address.size() < 1) {
            return "";
        }
        for (SymbolInterface symbol : this.address) {
            if (symbol == null) {
                stringAddress.append("--null--, ");
                continue;
            }
            stringAddress.append(symbol.getEnglishName()).append(", ");
        }
        return stringAddress.toString();
    }
}

