/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.worldgen.structures;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.worldgen.structures.EnumStructures;
import tauri.dev.jsg.worldgen.structures.stargate.nether.JSGNetherStructure;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;
import tauri.dev.jsg.worldgen.util.JSGStructurePos;
import tauri.dev.jsg.worldgen.util.JSGWorldTopBlock;

public class JSGStructuresGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (EnumStructures structure : EnumStructures.values()) {
            if (world.func_175624_G() == WorldType.field_77138_c) {
                return;
            }
            if (structure.getActualStructure((int)world.field_73011_w.getDimension()).dimensionToSpawn != world.field_73011_w.getDimension() || !structure.randomGeneratorEnabled() || !(structure.getChance() > 0.0f) || !(random.nextFloat() < structure.getChance())) continue;
            JSGStructuresGenerator.generateStructure(structure, world, random, chunkX, chunkZ, false);
            return;
        }
    }

    public static GeneratedStargate generateStructure(EnumStructures structure, World world, Random random, int chunkX, int chunkZ, boolean notRandomGen) {
        return JSGStructuresGenerator.generateStructure(structure, world, random, chunkX, chunkZ, notRandomGen, true, structure.getActualStructure((int)0).dimensionToSpawn);
    }

    public static GeneratedStargate generateStructure(EnumStructures structure, World world, Random random, int chunkX, int chunkZ, boolean notRandomGen, boolean notCommandGen, int dimId) {
        WorldServer worldToSpawn = Objects.requireNonNull(world.func_73046_m()).func_71218_a(dimId);
        if (structure.getActualStructure(dimId) instanceof JSGNetherStructure) {
            return structure.getActualStructure(dimId).generateStructure(world, new BlockPos(chunkX * 16, 32, chunkZ * 16), random, worldToSpawn);
        }
        int x = chunkX * 16 + (notCommandGen ? random.nextInt(15) : 0);
        int z = chunkZ * 16 + (notCommandGen ? random.nextInt(15) : 0);
        JSGStructurePos structurePos = JSGStructuresGenerator.checkForPlace((World)worldToSpawn, chunkX, chunkZ, structure, dimId);
        if (notRandomGen && notCommandGen) {
            for (int tries = 0; (structurePos == null || structurePos.foundPos == null) && tries < 50; ++tries) {
                if (structurePos != null && structurePos.bestAttemptPos != null) {
                    x = structurePos.bestAttemptPos.func_177958_n();
                    z = structurePos.bestAttemptPos.func_177952_p();
                    if (x / 16 == chunkX && tries % 2 == 0) {
                        x += 16 * (x < 0 ? 1 : -1);
                    }
                    if (z / 16 == chunkZ) {
                        z = tries % 2 == 0 ? (z += -16 * (z < 0 ? 1 : -1)) : (z += 16 * (z < 0 ? 1 : -1));
                    }
                } else if (tries > 0) {
                    x += random.nextInt(15) * 16 * (random.nextBoolean() ? -1 : 1);
                    z += random.nextInt(15) * 16 * (random.nextBoolean() ? -1 : 1);
                }
                chunkX = x / 16;
                chunkZ = z / 16;
                structurePos = JSGStructuresGenerator.checkForPlace((World)worldToSpawn, chunkX, chunkZ, structure, dimId);
            }
        }
        if (structurePos != null && structurePos.foundPos != null && structurePos.foundPos.func_177956_o() > 0) {
            String biome = Objects.requireNonNull(worldToSpawn.func_180494_b(structurePos.foundPos).getRegistryName()).func_110623_a();
            if (worldToSpawn.func_175624_G() != WorldType.field_77138_c || !notRandomGen) {
                boolean contains;
                boolean bl = contains = structure.allowedInBiomes == null;
                if (!contains) {
                    for (String s : structure.allowedInBiomes) {
                        if (!biome.contains(s)) continue;
                        contains = true;
                        break;
                    }
                }
                if (contains && (notRandomGen || structure.getActualStructure((int)dimId).isStargateStructure && JSGConfig.WorldGen.structures.stargateRandomGeneratorEnabled || !structure.getActualStructure((int)dimId).isStargateStructure && JSGConfig.WorldGen.structures.structuresRandomGeneratorEnabled)) {
                    return structure.getActualStructure(dimId).generateStructure(world, structurePos.foundPos, random, worldToSpawn);
                }
            }
        } else if (notRandomGen) {
            JSG.error("Can not generate structure " + structure.getActualStructure((int)dimId).structureName + "; StPos: " + structurePos);
        }
        return null;
    }

    public static JSGStructurePos checkForPlace(World world, int chunkX, int chunkZ, EnumStructures structure, int dimensionId) {
        if (!world.func_72863_F().func_191062_e(chunkX, chunkZ)) {
            world.func_72863_F().func_186025_d(chunkX, chunkZ);
        }
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int structureSizeX = structure.getActualStructure((int)dimensionId).structureSizeX;
        int structureSizeZ = structure.getActualStructure((int)dimensionId).structureSizeZ;
        int lowestY = 100;
        int highestY = 0;
        BlockPos pos = new BlockPos(x, 50, z);
        ArrayList<BlockPos> bestPositions = new ArrayList<BlockPos>();
        int topBlocksOk = 0;
        Rotation rotation = FacingHelper.getRotation(JSGStructuresGenerator.findOptimalRotation(world, pos));
        for (int xx = -1; xx <= structureSizeX + 1; ++xx) {
            for (int zz = -1; zz <= structureSizeZ + 1; ++zz) {
                BlockPos newPos = pos.func_177971_a((Vec3i)new BlockPos(xx, 0, zz).func_190942_a(rotation));
                if (world.func_72863_F().func_191062_e(newPos.func_177958_n() / 16, newPos.func_177952_p() / 16)) {
                    JSGWorldTopBlock topBlock = JSGWorldTopBlock.getTopBlock(world, newPos.func_177958_n(), newPos.func_177952_p(), structure.getActualStructure((int)dimensionId).airUp, dimensionId);
                    if (topBlock == null) continue;
                    if (topBlock.y < lowestY) {
                        lowestY = topBlock.y;
                    }
                    if (topBlock.y > highestY) {
                        highestY = topBlock.y;
                    }
                    int step = Math.abs(topBlock.y - lowestY);
                    if (structure.allowedOnBlocks != null && !structure.allowedOnBlocks.contains(topBlock.topBlock)) continue;
                    ++topBlocksOk;
                    if (step <= 4) {
                        bestPositions.add(newPos);
                        continue;
                    }
                    if (step < 15) continue;
                    return null;
                }
                world.func_72863_F().func_186025_d(newPos.func_177958_n() / 16, newPos.func_177952_p() / 16);
            }
        }
        int bestXSuma = 0;
        int bestYSuma = 0;
        int bestZSuma = 0;
        for (BlockPos bestPos : bestPositions) {
            bestXSuma += bestPos.func_177958_n();
            bestYSuma += bestPos.func_177956_o();
            bestZSuma += bestPos.func_177952_p();
        }
        BlockPos bestAttemptPos = null;
        if (bestPositions.size() > 0) {
            int bestX = bestXSuma / bestPositions.size();
            int bestY = bestYSuma / bestPositions.size();
            int bestZ = bestZSuma / bestPositions.size();
            bestAttemptPos = new BlockPos(bestX, bestY, bestZ);
        }
        double successPercent = (double)bestPositions.size() / (double)(structureSizeX * structureSizeZ);
        if (bestAttemptPos != null && successPercent < structure.getActualStructure((int)dimensionId).terrainFlatPercents) {
            return new JSGStructurePos(null, bestAttemptPos);
        }
        if (successPercent >= structure.getActualStructure((int)dimensionId).terrainFlatPercents && (double)topBlocksOk / (double)(structureSizeX * structureSizeZ) >= structure.getActualStructure((int)dimensionId).topBlockMatchPercent) {
            return new JSGStructurePos(new BlockPos(x, structure.getActualStructure((int)dimensionId).genHeight.getHeight(lowestY, highestY), z), null);
        }
        return null;
    }

    public static EnumFacing findOptimalRotation(World world, BlockPos pos) {
        int MAX_CHECK = 100;
        BlockPos start = pos.func_177982_a(0, 5, 5);
        int max = -1;
        EnumFacing maxFacing = EnumFacing.EAST;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            RayTraceResult rayTraceResult = world.func_72933_a(new Vec3d((Vec3i)start), new Vec3d((Vec3i)start.func_177967_a(facing, 100)));
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                int distance = (int)rayTraceResult.func_178782_a().func_177951_i((Vec3i)start);
                if (distance <= max) continue;
                max = distance;
                maxFacing = facing;
                continue;
            }
            max = 100000;
            maxFacing = facing;
        }
        return maxFacing;
    }
}

