/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.worldgen.structures.stargate;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.worldgen.structures.EnumStructures;
import tauri.dev.jsg.worldgen.structures.JSGStructuresGenerator;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;
import tauri.dev.jsg.worldgen.util.JSGStructurePos;

public class StargateGenerator {
    public static GeneratedStargate mystPageGeneration(World pWorld, SymbolTypeEnum symbolType, int dimensionToSpawn, @Nonnull EntityPlayer playerIn) {
        Random rand = new Random();
        int tries = 0;
        WorldServer worldToSpawn = Objects.requireNonNull(pWorld.func_73046_m()).func_71218_a(dimensionToSpawn);
        EnumStructures structure = null;
        int min = JSGConfig.WorldGen.mystPage.minOverworldCoords;
        int max = JSGConfig.WorldGen.mystPage.maxOverworldCoords;
        BlockPos pPos = playerIn.func_180425_c();
        int x = Math.abs(pPos.func_177958_n()) + (min + (int)(rand.nextFloat() * (float)max));
        int z = Math.abs(pPos.func_177952_p()) + (min + (int)(rand.nextFloat() * (float)max));
        if (pPos.func_177958_n() < 0) {
            x *= -1;
        }
        if (pPos.func_177952_p() < 0) {
            z *= -1;
        }
        JSGStructurePos structurePos = null;
        int chunkX = x / 16;
        int chunkZ = z / 16;
        int bestCount = 0;
        do {
            Chunk chunk;
            int y;
            if (structurePos != null && structurePos.bestAttemptPos != null) {
                x = structurePos.bestAttemptPos.func_177958_n();
                z = structurePos.bestAttemptPos.func_177952_p();
                if (x / 16 == chunkX && tries % 2 == 0) {
                    x += 16 * (x < 0 ? 1 : -1);
                }
                if (z / 16 == chunkZ) {
                    z = tries % 2 == 0 ? (z += -16 * (z < 0 ? 1 : -1)) : (z += 16 * (z < 0 ? 1 : -1));
                }
            } else if (tries > 0) {
                x = Math.abs(pPos.func_177958_n()) + (min + (int)(rand.nextFloat() * (float)max));
                z = Math.abs(pPos.func_177952_p()) + (min + (int)(rand.nextFloat() * (float)max));
            }
            if ((y = (chunk = worldToSpawn.func_72964_e(chunkX = x / 16, chunkZ = z / 16)).func_76611_b(8, 8)) > 240) continue;
            String biomeName = Objects.requireNonNull(worldToSpawn.func_180494_b(new BlockPos(x, y, z)).getRegistryName()).func_110623_a();
            structure = EnumStructures.getStargateStructureByBiome(biomeName, symbolType, dimensionToSpawn);
            if (structure != null) {
                structurePos = JSGStructuresGenerator.checkForPlace((World)worldToSpawn, chunkX, chunkZ, structure, dimensionToSpawn);
            }
            if (structurePos != null && structurePos.bestAttemptPos != null) {
                ++bestCount;
            }
            ++tries;
        } while ((structurePos == null || structurePos.foundPos == null) && tries < 50);
        if (structure == null || structurePos == null || structurePos.foundPos == null) {
            JSG.error("(" + playerIn.getDisplayNameString() + ") StargateGenerator: Failed to find place - myst page: Tries:" + tries + "; Structure:" + (structure != null));
            JSG.error("Best places count: " + bestCount);
            return null;
        }
        return structure.getActualStructure(dimensionToSpawn).generateStructure(pWorld, structurePos.foundPos, rand, worldToSpawn);
    }
}

