/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.network;

import ic2.core.util.misc.StackUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import trinsdar.gravisuit.items.tools.ItemRelocator;
import trinsdar.gravisuit.network.MessageHandlerWrapper;

public class PacketRelocator
implements IMessage {
    public static final int ADDDESTINATION = 0;
    public static final int REMOVEDESTINATION = 1;
    public static final int ADDDEFAULT = 2;
    public static final int TELEPORT = 3;
    private boolean dataB;
    private byte function = (byte)-1;
    private ItemRelocator.TeleportData location;
    private boolean hand;

    public PacketRelocator() {
    }

    public PacketRelocator(ItemRelocator.TeleportData location, int function, boolean hand) {
        this.location = location;
        this.function = (byte)function;
        this.hand = hand;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.function);
        if (this.function == 0) {
            bytes.writeInt(this.location.getX());
            bytes.writeInt(this.location.getY());
            bytes.writeInt(this.location.getZ());
            bytes.writeInt(this.location.getDimId());
            ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.location.getName());
        }
        if (this.function == 1 || this.function == 3 || this.function == 2) {
            ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.location.getName());
        }
        bytes.writeBoolean(this.hand);
    }

    public void fromBytes(ByteBuf bytes) {
        this.function = bytes.readByte();
        if (this.function == 0) {
            this.location = new ItemRelocator.TeleportData(bytes.readInt(), bytes.readInt(), bytes.readInt(), bytes.readInt(), ByteBufUtils.readUTF8String((ByteBuf)bytes));
        }
        if (this.function == 1 || this.function == 3 || this.function == 2) {
            this.location = new ItemRelocator.TeleportData(ByteBufUtils.readUTF8String((ByteBuf)bytes));
        }
        this.hand = bytes.readBoolean();
    }

    public static EnumHand boolToHand(boolean hand) {
        return hand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public static boolean handToBool(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND;
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketRelocator, IMessage> {
        @Override
        public IMessage handleMessage(PacketRelocator message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            ItemStack teleporter = serverPlayer.func_184586_b(PacketRelocator.boolToHand(message.hand));
            if (teleporter.func_190926_b()) {
                return null;
            }
            serverPlayer.func_71121_q().func_152344_a(() -> {
                ItemStack teleport = serverPlayer.func_184586_b(PacketRelocator.boolToHand(message.hand));
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)teleport);
                NBTTagCompound map = nbt.func_74775_l("Locations");
                if (message.function == 0) {
                    NBTTagCompound tag = new NBTTagCompound();
                    message.location.writeToNBT(tag);
                    map.func_74782_a(message.location.getName(), (NBTBase)tag);
                    nbt.func_74782_a("Locations", (NBTBase)map);
                    teleport.func_77982_d(nbt);
                    serverPlayer.field_71070_bA.func_75142_b();
                }
                if (message.function == 1) {
                    map.func_82580_o(message.location.getName());
                    nbt.func_74782_a("Locations", (NBTBase)map);
                    teleport.func_77982_d(nbt);
                    serverPlayer.field_71070_bA.func_75142_b();
                }
                if (message.function == 3 && map.func_74764_b(message.location.getName())) {
                    NBTTagCompound teleportData = map.func_74775_l(message.location.getName());
                    ItemRelocator.teleportEntity((EntityPlayer)ctx.getServerHandler().field_147369_b, (int)teleportData.func_74769_h("X"), (int)teleportData.func_74769_h("Y"), (int)teleportData.func_74769_h("Z"), teleportData.func_74762_e("Dimension"), teleport);
                }
                if (message.function == 2) {
                    nbt.func_74778_a("DefaultLocation", message.location.getName());
                    serverPlayer.field_71070_bA.func_75142_b();
                }
            });
            return null;
        }
    }
}

