/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.IAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeam;
import lach_01298.qmd.accelerator.tile.TileAcceleratorCooler;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.accelerator.tile.TileAcceleratorYoke;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.BlockTypes;
import nc.multiblock.PlacementRule;
import nc.util.I18nHelper;
import nc.util.Lang;
import nc.util.StringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CoolerPlacement {
    public static final List<PlacementRule.RuleParser<Accelerator, IAcceleratorPart>> RULE_PARSER_LIST = new LinkedList<PlacementRule.RuleParser<Accelerator, IAcceleratorPart>>();
    public static final Object2ObjectMap<String, String> RULE_MAP_RAW = new Object2ObjectArrayMap();
    public static final Object2ObjectMap<String, PlacementRule<Accelerator, IAcceleratorPart>> RULE_MAP = new PlacementRule.PlacementMap();
    public static final List<PlacementRule.TooltipBuilder<Accelerator, IAcceleratorPart>> TOOLTIP_BUILDER_LIST = new LinkedList<PlacementRule.TooltipBuilder<Accelerator, IAcceleratorPart>>();
    public static PlacementRule.RecipeHandler recipe_handler;
    public static final Object2ObjectMap<String, String> TOOLTIP_MAP;

    public static void preInit() {
        RULE_PARSER_LIST.add((PlacementRule.RuleParser<Accelerator, IAcceleratorPart>)new DefaultRuleParser());
        TOOLTIP_BUILDER_LIST.add((PlacementRule.TooltipBuilder<Accelerator, IAcceleratorPart>)new DefaultTooltipBuilder());
        recipe_handler = new RecipeHandler();
    }

    public static void init() {
        RULE_MAP.put((Object)"", (Object)new PlacementRule.Or(new ArrayList()));
        CoolerPlacement.addRule("water_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.WATER.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.WATER.getID()));
        CoolerPlacement.addRule("iron_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.IRON.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.IRON.getID()));
        CoolerPlacement.addRule("redstone_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.REDSTONE.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.REDSTONE.getID()));
        CoolerPlacement.addRule("quartz_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.QUARTZ.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.QUARTZ.getID()));
        CoolerPlacement.addRule("obsidian_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.OBSIDIAN.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.OBSIDIAN.getID()));
        CoolerPlacement.addRule("nether_brick_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.NETHER_BRICK.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.NETHER_BRICK.getID()));
        CoolerPlacement.addRule("glowstone_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.GLOWSTONE.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.GLOWSTONE.getID()));
        CoolerPlacement.addRule("lapis_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.LAPIS.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.LAPIS.getID()));
        CoolerPlacement.addRule("gold_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.GOLD.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.GOLD.getID()));
        CoolerPlacement.addRule("prismarine_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.PRISMARINE.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.PRISMARINE.getID()));
        CoolerPlacement.addRule("slime_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.SLIME.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.SLIME.getID()));
        CoolerPlacement.addRule("end_stone_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.END_STONE.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.END_STONE.getID()));
        CoolerPlacement.addRule("purpur_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.PURPUR.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.PURPUR.getID()));
        CoolerPlacement.addRule("diamond_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.DIAMOND.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.DIAMOND.getID()));
        CoolerPlacement.addRule("emerald_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.EMERALD.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.EMERALD.getID()));
        CoolerPlacement.addRule("copper_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType1.COPPER.getID()], new ItemStack(QMDBlocks.acceleratorCooler1, 1, BlockTypes.CoolerType1.COPPER.getID()));
        CoolerPlacement.addRule("tin_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.TIN.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.TIN.getID()));
        CoolerPlacement.addRule("lead_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.LEAD.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LEAD.getID()));
        CoolerPlacement.addRule("boron_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.BORON.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.BORON.getID()));
        CoolerPlacement.addRule("lithium_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.LITHIUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LITHIUM.getID()));
        CoolerPlacement.addRule("magnesium_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.MAGNESIUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.MAGNESIUM.getID()));
        CoolerPlacement.addRule("manganese_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.MANGANESE.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.MANGANESE.getID()));
        CoolerPlacement.addRule("aluminum_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.ALUMINUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.ALUMINUM.getID()));
        CoolerPlacement.addRule("silver_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.SILVER.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.SILVER.getID()));
        CoolerPlacement.addRule("fluorite_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.FLUORITE.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.FLUORITE.getID()));
        CoolerPlacement.addRule("villiaumite_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.VILLIAUMITE.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.VILLIAUMITE.getID()));
        CoolerPlacement.addRule("carobbiite_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.CAROBBIITE.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.CAROBBIITE.getID()));
        CoolerPlacement.addRule("arsenic_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.ARSENIC.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.ARSENIC.getID()));
        CoolerPlacement.addRule("liquid_nitrogen_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.LIQUID_NITROGEN.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LIQUID_NITROGEN.getID()));
        CoolerPlacement.addRule("liquid_helium_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.LIQUID_HELIUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.LIQUID_HELIUM.getID()));
        CoolerPlacement.addRule("enderium_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.ENDERIUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.ENDERIUM.getID()));
        CoolerPlacement.addRule("cryotheum_cooler", QMDConfig.cooler_rule[BlockTypes.CoolerType2.CRYOTHEUM.getID() + 16], new ItemStack(QMDBlocks.acceleratorCooler2, 1, BlockTypes.CoolerType2.CRYOTHEUM.getID()));
    }

    public static void addRule(String id, String rule, Object ... blocks) {
        RULE_MAP_RAW.put((Object)id, (Object)rule);
        RULE_MAP.put((Object)id, CoolerPlacement.parse(rule));
        for (Object block : blocks) {
            recipe_handler.addRecipe(new Object[]{block, id});
        }
    }

    public static void postInit() {
        for (Object2ObjectMap.Entry entry : RULE_MAP.object2ObjectEntrySet()) {
            for (PlacementRule.TooltipBuilder<Accelerator, IAcceleratorPart> builder : TOOLTIP_BUILDER_LIST) {
                String tooltip = builder.buildTooltip((PlacementRule)entry.getValue());
                if (tooltip == null) continue;
                TOOLTIP_MAP.put(entry.getKey(), (Object)tooltip);
            }
        }
    }

    public static PlacementRule<Accelerator, IAcceleratorPart> parse(String string) {
        return PlacementRule.parse((String)string, RULE_PARSER_LIST);
    }

    public static boolean isBeam(Accelerator accelerator, BlockPos pos) {
        TileAcceleratorBeam beam = (TileAcceleratorBeam)accelerator.getPartMap(TileAcceleratorBeam.class).get(pos.func_177986_g());
        return beam == null ? false : beam.isFunctional();
    }

    public static boolean isActiveMagnet(Accelerator accelerator, BlockPos pos, String magnetName) {
        TileAcceleratorMagnet magnet = (TileAcceleratorMagnet)accelerator.getPartMap(TileAcceleratorMagnet.class).get(pos.func_177986_g());
        return magnet == null ? false : magnet.isFunctional() && magnet.name.equals(magnetName) || magnet.isFunctional() && magnetName == null;
    }

    public static boolean isActiveYoke(Accelerator accelerator, BlockPos pos) {
        TileAcceleratorYoke yoke = (TileAcceleratorYoke)accelerator.getPartMap(TileAcceleratorYoke.class).get(pos.func_177986_g());
        return yoke == null ? false : yoke.isFunctional();
    }

    public static boolean isActiveRFCavity(Accelerator accelerator, BlockPos pos, String cavityName) {
        TileAcceleratorRFCavity cavity = (TileAcceleratorRFCavity)accelerator.getPartMap(TileAcceleratorRFCavity.class).get(pos.func_177986_g());
        return cavity == null ? false : cavity.isFunctional() && cavity.name.equals(cavityName) || cavity.isFunctional() && cavityName == null;
    }

    public static boolean isActiveCooler(Accelerator accelerator, BlockPos pos, String coolerName) {
        TileAcceleratorCooler cooler = (TileAcceleratorCooler)accelerator.getPartMap(TileAcceleratorCooler.class).get(pos.func_177986_g());
        return cooler == null ? false : cooler.isFunctional() && (coolerName.equals("any") || cooler.name.equals(coolerName));
    }

    static {
        TOOLTIP_MAP = new Object2ObjectOpenHashMap();
    }

    public static class RecipeHandler
    extends PlacementRule.RecipeHandler {
        public RecipeHandler() {
            super("accelerator");
        }
    }

    public static class DefaultTooltipBuilder
    extends PlacementRule.DefaultTooltipBuilder<Accelerator, IAcceleratorPart> {
    }

    public static class AdjacentDifferentCavity
    extends Adjacent {
        List<String> storedTypes = new ArrayList<String>();

        public AdjacentDifferentCavity(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("cavity", amount, countType, adjType);
        }

        public void checkIsRuleAllowed(String ruleID) {
            if (this.adjType != PlacementRule.AdjacencyType.STANDARD) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can only be AdjacencyType standard  ");
            }
            if (this.amount > 6) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can not require more than six adjacencies!");
            }
            if (this.amount < 1) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can only require more than one difrent adjacencies");
            }
        }

        public boolean satisfied(IAcceleratorPart tile) {
            ArrayList<String> storedTypes = new ArrayList<String>();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                String type;
                if (CoolerPlacement.isActiveRFCavity((Accelerator)tile.getMultiblock(), tile.getTilePos().func_177972_a(dir), null) && !storedTypes.contains(type = ((TileAcceleratorRFCavity)((Accelerator)tile.getMultiblock()).getPartMap(TileAcceleratorRFCavity.class).get((long)tile.getTilePos().func_177972_a((EnumFacing)dir).func_177986_g())).name)) {
                    storedTypes.add(type);
                }
                if (this.countType == PlacementRule.CountType.AT_LEAST) {
                    if (storedTypes.size() < this.amount) continue;
                    return true;
                }
                if (storedTypes.size() <= this.amount) continue;
                return false;
            }
            return this.countType == PlacementRule.CountType.AT_MOST || this.countType == PlacementRule.CountType.EXACTLY && storedTypes.size() == this.amount;
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return false;
        }

        public String buildSubTooltip() {
            return Lang.localise((String)("nc.sf.placement_rule.adjacent." + this.countType.tooltipSubstring(this.amount) + this.adjType.tooltipSubstring(this.amount)), (Object[])new Object[]{I18nHelper.getPluralForm((String)("nc.sf." + (String)this.dependencies.get(0)), (int)this.amount, (Object[])new Object[]{Lang.localise((String)("nc.sf.different." + (String)StringHelper.NUMBER_I2S_MAP.get(this.amount)))})});
        }
    }

    public static class AdjacentDifferentMagnet
    extends Adjacent {
        public AdjacentDifferentMagnet(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("magnet", amount, countType, adjType);
        }

        public void checkIsRuleAllowed(String ruleID) {
            if (this.adjType != PlacementRule.AdjacencyType.STANDARD) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can only be AdjacencyType standard  ");
            }
            if (this.amount > 6) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can not require more than six adjacencies!");
            }
            if (this.amount < 1) {
                throw new IllegalArgumentException("Diffrent Adjacency placement rule with ID \"" + ruleID + "\" can only require more than one difrent adjacencies");
            }
        }

        public boolean satisfied(IAcceleratorPart tile) {
            ArrayList<String> storedTypes = new ArrayList<String>();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                String type;
                if (CoolerPlacement.isActiveMagnet((Accelerator)tile.getMultiblock(), tile.getTilePos().func_177972_a(dir), null) && !storedTypes.contains(type = ((TileAcceleratorMagnet)((Accelerator)tile.getMultiblock()).getPartMap(TileAcceleratorMagnet.class).get((long)tile.getTilePos().func_177972_a((EnumFacing)dir).func_177986_g())).name)) {
                    storedTypes.add(type);
                }
                if (this.countType == PlacementRule.CountType.AT_LEAST) {
                    if (storedTypes.size() < this.amount) continue;
                    return true;
                }
                if (storedTypes.size() <= this.amount) continue;
                return false;
            }
            return this.countType == PlacementRule.CountType.AT_MOST || this.countType == PlacementRule.CountType.EXACTLY && storedTypes.size() == this.amount;
        }

        public String buildSubTooltip() {
            return Lang.localise((String)("nc.sf.placement_rule.adjacent." + this.countType.tooltipSubstring(this.amount) + this.adjType.tooltipSubstring(this.amount)), (Object[])new Object[]{I18nHelper.getPluralForm((String)("nc.sf." + (String)this.dependencies.get(0)), (int)this.amount, (Object[])new Object[]{Lang.localise((String)("nc.sf.different." + (String)StringHelper.NUMBER_I2S_MAP.get(this.amount)))})});
        }

        public boolean satisfied(IAcceleratorPart tile, EnumFacing dir) {
            return false;
        }
    }

    public static class AdjacentCooler
    extends Adjacent {
        protected final String coolerType;

        public AdjacentCooler(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String coolerType) {
            super(coolerType + "_cooler", amount, countType, adjType);
            this.coolerType = coolerType;
        }

        public void checkIsRuleAllowed(String ruleID) {
            super.checkIsRuleAllowed(ruleID);
            if (this.countType != PlacementRule.CountType.AT_LEAST && this.coolerType.equals("any")) {
                throw new IllegalArgumentException((this.countType == PlacementRule.CountType.EXACTLY ? "Exact 'any cooler'" : "'At most n of any cooler'") + " placement rule with ID \"" + ruleID + "\" is disallowed due to potential ambiguity during rule checks!");
            }
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return CoolerPlacement.isActiveCooler((Accelerator)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.coolerType);
        }
    }

    public static class AdjacentRFCavity
    extends Adjacent {
        protected final String cavityType;

        public AdjacentRFCavity(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String cavityType) {
            super("cavity", amount, countType, adjType);
            this.cavityType = cavityType;
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return CoolerPlacement.isActiveRFCavity((Accelerator)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.cavityType);
        }
    }

    public static class AdjacentYoke
    extends Adjacent {
        public AdjacentYoke(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("yoke", amount, countType, adjType);
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return CoolerPlacement.isActiveYoke((Accelerator)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentMagnet
    extends Adjacent {
        protected final String magnetType;

        public AdjacentMagnet(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String magnetType) {
            super("magnet", amount, countType, adjType);
            this.magnetType = magnetType;
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return CoolerPlacement.isActiveMagnet((Accelerator)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.magnetType);
        }
    }

    public static class AdjacentBeam
    extends Adjacent {
        public AdjacentBeam(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("beam", amount, countType, adjType);
        }

        public boolean satisfied(IAcceleratorPart part, EnumFacing dir) {
            return CoolerPlacement.isBeam((Accelerator)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static abstract class Adjacent
    extends PlacementRule.Adjacent<Accelerator, IAcceleratorPart> {
        public Adjacent(String dependency, int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super(dependency, amount, countType, adjType);
        }
    }

    public static class DefaultRuleParser
    extends PlacementRule.DefaultRuleParser<Accelerator, IAcceleratorPart> {
        @Nullable
        protected PlacementRule<Accelerator, IAcceleratorPart> partialParse(String s) {
            PlacementRule.AdjacencyType adjType;
            PlacementRule.CountType countType;
            s = s.toLowerCase(Locale.ROOT);
            s = s.replaceAll("at exactly one vertex", "vertex");
            boolean exact = s.contains("exact");
            boolean atMost = s.contains("at most");
            boolean axial = s.contains("axial");
            boolean vertex = s.contains("vertex");
            boolean different = s.contains("different");
            if (exact && atMost || axial && vertex) {
                return null;
            }
            s = s.replaceAll("at least", "");
            s = s.replaceAll("exactly", "");
            s = s.replaceAll("exact", "");
            s = s.replaceAll("at most", "");
            s = s.replaceAll("axially", "");
            s = s.replaceAll("axial", "");
            s = s.replaceAll("at one vertex", "");
            s = s.replaceAll("at a vertex", "");
            s = s.replaceAll("at vertex", "");
            s = s.replaceAll("vertex", "");
            int amount = -1;
            String rule = null;
            String type = null;
            String[] split = s.split(Pattern.quote(" "));
            for (int i = 0; i < split.length; ++i) {
                if (StringHelper.NUMBER_S2I_MAP.containsKey((Object)split[i])) {
                    amount = StringHelper.NUMBER_S2I_MAP.getInt((Object)split[i]);
                    continue;
                }
                if (rule != null) continue;
                if (split[i].contains("beam")) {
                    rule = "beam";
                    continue;
                }
                if (split[i].contains("magnet")) {
                    rule = "magnet";
                    continue;
                }
                if (split[i].contains("yoke")) {
                    rule = "yoke";
                    continue;
                }
                if (split[i].contains("cavity")) {
                    rule = "cavity";
                    continue;
                }
                if (!split[i].contains("cooler")) continue;
                rule = "cooler";
                if (i > 0) {
                    type = split[i - 1];
                    continue;
                }
                return null;
            }
            if (amount < 0 || rule == null) {
                return null;
            }
            PlacementRule.CountType countType2 = exact ? PlacementRule.CountType.EXACTLY : (countType = atMost ? PlacementRule.CountType.AT_MOST : PlacementRule.CountType.AT_LEAST);
            PlacementRule.AdjacencyType adjacencyType = axial ? PlacementRule.AdjacencyType.AXIAL : (adjType = vertex ? PlacementRule.AdjacencyType.VERTEX : PlacementRule.AdjacencyType.STANDARD);
            if (rule.equals("beam")) {
                return new AdjacentBeam(amount, countType, adjType);
            }
            if (rule.equals("magnet")) {
                if (different) {
                    return new AdjacentDifferentMagnet(amount, countType, adjType);
                }
                return new AdjacentMagnet(amount, countType, adjType, type);
            }
            if (rule.equals("yoke")) {
                return new AdjacentYoke(amount, countType, adjType);
            }
            if (rule.equals("cavity")) {
                if (different) {
                    return new AdjacentDifferentCavity(amount, countType, adjType);
                }
                return new AdjacentRFCavity(amount, countType, adjType, type);
            }
            if (rule.equals("cooler")) {
                return new AdjacentCooler(amount, countType, adjType, type);
            }
            return null;
        }
    }
}

