/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.mc1120.util.CraftTweakerPlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.accelerator.CoolerPlacement;
import lach_01298.qmd.accelerator.block.BlockAcceleratorPart;
import lach_01298.qmd.accelerator.tile.TileAcceleratorCooler;
import lach_01298.qmd.accelerator.tile.TileAcceleratorMagnet;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.item.ItemCustomParticleSource;
import lach_01298.qmd.item.QMDItems;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberDetector;
import lach_01298.qmd.tab.QMDTabs;
import lach_01298.qmd.util.Util;
import lach_01298.qmd.vacuumChamber.HeaterPlacement;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberHeater;
import nc.integration.crafttweaker.CTRegistration;
import nc.item.NCItemMetaArray;
import nc.util.IOHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.qmd.Registration")
@ZenRegister
public class QMDCTRegistration {
    @ZenMethod
    public static void registerAcceleratorCooler(final String coolerID, final int cooling, String rule) {
        Block cooler = QMDBlocks.withName((Block)new BlockAcceleratorPart(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileAcceleratorCooler(coolerID, cooling, coolerID + "_cooler");
            }
        }, "accelerator_cooler_" + coolerID);
        CTRegistration.INFO_LIST.add(new AcceleratorCoolerRegistrationInfo(cooler, coolerID, cooling, rule));
        CraftTweakerAPI.logInfo((String)("Registered accelerator cooler with ID \"" + coolerID + "\", cooling rate " + cooling + " H/t and placement rule \"" + rule + "\""));
    }

    @ZenMethod
    public static void registerAcceleratorRFCavity(final String name, final int voltage, final double efficiency, final int heat, final int basePower, final int maxTemp) {
        Block rfCavity = QMDBlocks.withName((Block)new BlockAcceleratorPart(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileAcceleratorRFCavity(voltage, efficiency, heat, basePower, maxTemp, name);
            }
        }, "accelerator_rf_cavity_" + name);
        CTRegistration.INFO_LIST.add(new AcceleratorRFCavityRegistrationInfo(rfCavity, name, voltage, efficiency, heat, basePower, maxTemp));
        CraftTweakerAPI.logInfo((String)("Registered accelerator RF Cavity with name \"" + name + "\" and voltage " + voltage));
    }

    @ZenMethod
    public static void registerAcceleratorMagnet(final String name, final double strength, final double efficiency, final int heat, final int basePower, final int maxTemp) {
        Block magnet = QMDBlocks.withName((Block)new BlockAcceleratorPart(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileAcceleratorMagnet(strength, efficiency, heat, basePower, maxTemp, name);
            }
        }, "accelerator_magnet_" + name);
        CTRegistration.INFO_LIST.add(new AcceleratorMagnetRegistrationInfo(magnet, name, strength, efficiency, heat, basePower, maxTemp));
        CraftTweakerAPI.logInfo((String)("Registered accelerator magnet with name \"" + name + "\" and strength " + strength));
    }

    @ZenMethod
    public static void registerParticleChamberDetector(final String name, final double efficiency, final int basePower, final int distance, final boolean within) {
        Block detector = QMDBlocks.withName((Block)new BlockAcceleratorPart(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileParticleChamberDetector(efficiency, basePower, name, distance, within);
            }
        }, "particle_chamber_detector_" + name);
        CTRegistration.INFO_LIST.add(new ParticleChamberDetectorRegistrationInfo(detector, name, efficiency, basePower, distance, within));
        CraftTweakerAPI.logInfo((String)("Registered particle chamber detector with name \"" + name + "\" and efficiency " + efficiency));
    }

    @ZenMethod
    public static void registerVaccuumChamberHeater(final String coolerID, final int cooling, String rule) {
        Block cooler = QMDBlocks.withName((Block)new BlockAcceleratorPart(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileVacuumChamberHeater(coolerID, cooling, coolerID + "_cooler");
            }
        }, "vacuum_chamber_heater_" + coolerID);
        CTRegistration.INFO_LIST.add(new VacuumChamberHeaterRegistrationInfo(cooler, coolerID, cooling, rule));
        CraftTweakerAPI.logInfo((String)("Registered vacuum chamber heater with ID \"" + coolerID + "\", cooling rate " + cooling + " H/t and placement rule \"" + rule + "\""));
    }

    @ZenMethod
    public static void registerItemSource(String name, int capacity, int stackSize) {
        int n = capacity = capacity < 0 ? 0 : capacity;
        stackSize = stackSize > 64 ? 64 : (stackSize < 1 ? 1 : stackSize);
        Item item = QMDItems.withName(new ItemCustomParticleSource(capacity, stackSize), name);
        CTRegistration.INFO_LIST.add(new ItemRegistrationInfo(item, QMDTabs.ITEMS));
        CraftTweakerAPI.logInfo((String)("Registered item particle source with name \"" + name + "\""));
    }

    @ZenMethod
    public static void registerItemSource(String name, int capacity, int stackSize, double explosionSize, double radiation) {
        int n = capacity = capacity < 0 ? 0 : capacity;
        stackSize = stackSize > 64 ? 64 : (stackSize < 1 ? 1 : stackSize);
        Item item = QMDItems.withName(new ItemCustomParticleSource(capacity, stackSize, explosionSize, radiation), name);
        CTRegistration.INFO_LIST.add(new ItemRegistrationInfo(item, QMDTabs.ITEMS));
        CraftTweakerAPI.logInfo((String)("Registered item particle source with name \"" + name + "\""));
    }

    public static class MetaItemRegistrationInfo
    extends CTRegistration.RegistrationInfo {
        protected final String name;
        protected Item item = null;
        protected CreativeTabs tab;
        public final List<String> types = new ArrayList<String>();
        public final List<String> models = new ArrayList<String>();
        public final List<String> textures = new ArrayList<String>();

        public MetaItemRegistrationInfo(String name, CreativeTabs tab) {
            this.name = name;
            this.tab = tab;
        }

        public void createModelJson() {
            StringBuilder builder = new StringBuilder();
            String s = IOHelper.NEW_LINE;
            builder.append("{" + s + "\t\"forge_marker\": 1," + s + "\t\"defaults\": {" + s + "\t\t\"model\": \"builtin/generated\"," + s + "\t\t\"transform\": \"forge:default-item\"" + s + "\t}," + s + "\t\"variants\": {" + s + "\t\t\"type\": {" + s);
            for (int i = 0; i < this.types.size(); ++i) {
                builder.append("\t\t\t\"" + this.types.get(i) + "\": {" + s);
                String model = this.models.get(i);
                if (model != null) {
                    builder.append("\t\t\t\t\"model\": \"" + model + "\"," + s);
                }
                builder.append("\t\t\t\t\"textures\": {" + s + "\t\t\t\t\t\"layer0\": \"qmd:items/" + this.name + "/" + this.textures.get(i) + "\"" + s + "\t\t\t\t}" + s + "\t\t\t" + (i < this.types.size() - 1 ? "}," : "}") + s);
            }
            builder.append("\t\t}" + s + "\t}" + s + "}" + s);
            try {
                FileUtils.writeStringToFile((File)new File("resources/qmd/blockstates/items/" + this.name + ".json"), (String)builder.toString());
            }
            catch (IOException e) {
                Util.getLogger().catching((Throwable)e);
            }
        }

        public void preInit() {
            if (this.types.isEmpty()) {
                return;
            }
            this.createModelJson();
            this.item = QMDItems.withName(new NCItemMetaArray(this.types, (String[][])new String[0][]), this.name);
            this.registerItem();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerItem() {
            QMDItems.registerItem(this.item, this.tab);
        }

        public void registerRender() {
            for (int i = 0; i < this.types.size(); ++i) {
                QMDItems.registerRender(this.item, i, this.types.get(i));
            }
        }

        public void recipeInit() {
        }

        public void init() {
        }

        public void postInit() {
        }
    }

    public static class ItemRegistrationInfo
    extends CTRegistration.RegistrationInfo {
        protected final Item item;
        protected final CreativeTabs tab;

        public ItemRegistrationInfo(Item item, CreativeTabs tab) {
            this.item = item;
            this.tab = tab;
        }

        public void preInit() {
            this.registerItem();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerItem() {
            QMDItems.registerItem(this.item, this.tab);
        }

        public void registerRender() {
            QMDItems.registerRender(this.item);
        }

        public void recipeInit() {
        }

        public void init() {
        }

        public void postInit() {
        }
    }

    public static class VacuumChamberHeaterRegistrationInfo
    extends QMDTileBlockRegistrationInfo {
        protected final String coolerID;
        protected final String rule;
        protected final int cooling;

        VacuumChamberHeaterRegistrationInfo(Block block, String coolerID, int cooling, String rule) {
            super(block);
            this.coolerID = coolerID;
            this.cooling = cooling;
            this.rule = rule;
        }

        @Override
        public void registerBlock() {
            QMDBlocks.registerBlock(this.block, TextFormatting.BLUE, new String[]{Lang.localise((String)"tile.qmd.accelerator.cooler.cooling_rate") + " " + this.cooling + " H/t"}, TextFormatting.AQUA, InfoHelper.NULL_ARRAY);
        }

        @Override
        public void init() {
            super.init();
            HeaterPlacement.addRule(this.coolerID + "_cooler", this.rule, this.block);
        }
    }

    public static class ParticleChamberDetectorRegistrationInfo
    extends QMDTileBlockRegistrationInfo {
        protected final String name;
        protected final int basePower;
        protected final int distance;
        protected final double efficiency;
        protected final boolean within;

        ParticleChamberDetectorRegistrationInfo(Block block, String name, double efficiency, int basePower, int distance, boolean within) {
            super(block);
            this.name = name;
            this.efficiency = efficiency;
            this.basePower = basePower;
            this.distance = distance;
            this.within = within;
        }

        @Override
        public void registerBlock() {
            String[] info = new String[]{Lang.localise((String)"info.qmd.particle_chamber.detector.efficiency", (Object[])new Object[]{(double)Math.round(1000.0 * this.efficiency) / 10.0 + "%"}), Lang.localise((String)"info.qmd.particle_chamber.detector.power", (Object[])new Object[]{this.basePower})};
            if (this.within) {
                QMDBlocks.registerBlock(this.block, TextFormatting.GREEN, info, TextFormatting.AQUA, InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.particle_chamber.detector.in.desc", (Object[])new Object[]{this.distance}), (Object[])new Object[0]));
            } else {
                QMDBlocks.registerBlock(this.block, TextFormatting.GREEN, info, TextFormatting.AQUA, InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.particle_chamber.detector.out.desc", (Object[])new Object[]{this.distance}), (Object[])new Object[0]));
            }
        }
    }

    public static class AcceleratorMagnetRegistrationInfo
    extends QMDTileBlockRegistrationInfo {
        protected final String name;
        protected final int heat;
        protected final int basePower;
        protected final int maxTemp;
        protected final double strength;
        protected final double efficiency;

        AcceleratorMagnetRegistrationInfo(Block block, String name, double strength, double efficiency, int heat, int basePower, int maxTemp) {
            super(block);
            this.name = name;
            this.strength = strength;
            this.efficiency = efficiency;
            this.heat = heat;
            this.basePower = basePower;
            this.maxTemp = maxTemp;
        }

        @Override
        public void registerBlock() {
            String[] info = new String[]{Lang.localise((String)"info.qmd.accelerator_magnet.strength", (Object[])new Object[]{this.strength}), Lang.localise((String)"info.qmd.item.efficiency", (Object[])new Object[]{Math.round(100.0 * this.efficiency) + "%"}), Lang.localise((String)"info.qmd.item.heat", (Object[])new Object[]{this.heat}), Lang.localise((String)"info.qmd.item.power", (Object[])new Object[]{this.basePower}), Lang.localise((String)"info.qmd.item.max_temp", (Object[])new Object[]{this.maxTemp})};
            QMDBlocks.registerBlock(this.block, TextFormatting.GREEN, info, TextFormatting.AQUA, InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.accelerator_magnet.desc"), (Object[])new Object[0]));
        }
    }

    public static class AcceleratorRFCavityRegistrationInfo
    extends QMDTileBlockRegistrationInfo {
        protected final String name;
        protected final int voltage;
        protected final int heat;
        protected final int basePower;
        protected final int maxTemp;
        protected final double efficiency;

        AcceleratorRFCavityRegistrationInfo(Block block, String name, int voltage, double efficiency, int heat, int basePower, int maxTemp) {
            super(block);
            this.name = name;
            this.voltage = voltage;
            this.efficiency = efficiency;
            this.heat = heat;
            this.basePower = basePower;
            this.maxTemp = maxTemp;
        }

        @Override
        public void registerBlock() {
            String[] info = new String[]{Lang.localise((String)"info.qmd.rf_cavity.voltage", (Object[])new Object[]{this.voltage}), Lang.localise((String)"info.qmd.item.efficiency", (Object[])new Object[]{Math.round(100.0 * this.efficiency) + "%"}), Lang.localise((String)"info.qmd.item.heat", (Object[])new Object[]{this.heat}), Lang.localise((String)"info.qmd.item.power", (Object[])new Object[]{this.basePower}), Lang.localise((String)"info.qmd.item.max_temp", (Object[])new Object[]{this.maxTemp})};
            QMDBlocks.registerBlock(this.block, TextFormatting.GREEN, info, TextFormatting.AQUA, InfoHelper.formattedInfo((String)Lang.localise((String)"tile.qmd.rf_cavity.desc"), (Object[])new Object[0]));
        }
    }

    public static class AcceleratorCoolerRegistrationInfo
    extends QMDTileBlockRegistrationInfo {
        protected final String coolerID;
        protected final String rule;
        protected final int cooling;

        AcceleratorCoolerRegistrationInfo(Block block, String coolerID, int cooling, String rule) {
            super(block);
            this.coolerID = coolerID;
            this.cooling = cooling;
            this.rule = rule;
        }

        @Override
        public void registerBlock() {
            QMDBlocks.registerBlock(this.block, TextFormatting.BLUE, new String[]{Lang.localise((String)"tile.qmd.accelerator.cooler.cooling_rate") + " " + this.cooling + " H/t"}, TextFormatting.AQUA, InfoHelper.NULL_ARRAY);
        }

        @Override
        public void init() {
            super.init();
            CoolerPlacement.addRule(this.coolerID + "_cooler", this.rule, this.block);
        }
    }

    public static class QMDTileBlockRegistrationInfo
    extends QMDBlockRegistrationInfo {
        public QMDTileBlockRegistrationInfo(Block block) {
            super(block);
        }
    }

    public static class QMDBlockRegistrationInfo
    extends CTRegistration.RegistrationInfo {
        protected final Block block;

        public QMDBlockRegistrationInfo(Block block) {
            this.block = block;
        }

        public void preInit() {
            this.registerBlock();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerBlock() {
            QMDBlocks.registerBlock(this.block, new String[0]);
        }

        public void registerRender() {
            QMDBlocks.registerRender(this.block);
        }

        public void recipeInit() {
        }

        public void init() {
        }

        public void postInit() {
        }
    }
}

