/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import com.google.common.collect.Multimap;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import lach_01298.qmd.config.QMDConfig;
import nc.item.NCItem;
import nc.item.energy.ElectricItemManager;
import nc.item.energy.IChargableItem;
import nc.item.energy.ItemEnergyCapabilityProvider;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.InfoHelper;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemDrill
extends NCItem
implements IChargableItem,
ISpecialElectricItem {
    private float attackSpeed;
    private float attackDamage;
    private final long capacity;
    private final int maxTransfer;
    private final EnergyConnection energyConnection;
    private final int energyTier;
    private int energyUsage;
    private int radius;
    private float miningSpeed;
    private int miningLevel;

    public ItemDrill(int radius, int capacity, int miningLevel, float miningSpeed, String ... tooltip) {
        super(tooltip);
        this.field_77777_bU = 1;
        this.attackSpeed = -2.8f;
        this.attackDamage = 1.0f;
        this.capacity = capacity;
        this.radius = radius;
        this.miningSpeed = miningSpeed;
        this.miningLevel = miningLevel;
        this.energyUsage = QMDConfig.drill_energy_usage;
        this.maxTransfer = NCMath.toInt((long)this.capacity);
        this.energyConnection = EnergyConnection.BOTH;
        this.energyTier = 3;
        this.setHarvestLevel("pickaxe", miningLevel);
        this.setHarvestLevel("shovel", miningLevel);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        Material material = state.func_185904_a();
        if (energy.extractEnergy(this.energyUsage, true) == this.energyUsage) {
            if (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e) {
                return this.miningSpeed;
            }
            for (String type : this.getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return this.miningSpeed;
            }
        }
        return 1.0f;
    }

    public boolean func_150897_b(IBlockState state) {
        ItemStack stack = new ItemStack((Item)this);
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state) || state.func_177230_c().getHarvestLevel(state) > this.getHarvestLevel(stack, type, null, state)) continue;
            return true;
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && (double)state.func_185887_b(worldIn, pos) != 0.0) {
            EntityPlayer player;
            if (entityLiving instanceof EntityPlayer && (player = (EntityPlayer)entityLiving).func_184812_l_()) {
                return true;
            }
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            energy.extractEnergy(this.energyUsage, false);
        }
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (toolClass.equals("pickaxe") || toolClass.equals("shovel")) {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energy.extractEnergy(this.energyUsage, true) == this.energyUsage && this.radius >= 1) {
                return this.miningLevel;
            }
            return 1;
        }
        return -1;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos blockPos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            RayTraceResult ray = this.func_77621_a(world, player, false);
            EnumFacing side = ray.field_178784_b;
            float hardness = world.func_180495_p(blockPos).func_185887_b(world, blockPos);
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energy.extractEnergy(this.energyUsage, true) == this.energyUsage && this.radius >= 1) {
                for (BlockPos pos : this.getDiggedBlocks(blockPos, side, this.radius)) {
                    if (!this.func_150897_b(world.func_180495_p(pos)) || !(world.func_180495_p(pos).func_185887_b(world, pos) <= hardness * 2.0f)) continue;
                    world.func_175655_b(pos, !player.func_184812_l_());
                    if (player.func_184812_l_()) continue;
                    energy.extractEnergy(this.energyUsage, false);
                }
            }
        }
        return false;
    }

    public Set<BlockPos> getDiggedBlocks(BlockPos pos, EnumFacing facing, int radius) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        switch (facing) {
            case UP: 
            case DOWN: {
                for (BlockPos p : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius))) {
                    postions.add(p.func_185334_h());
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (BlockPos p : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, -radius, 0), (BlockPos)pos.func_177982_a(radius, radius, 0))) {
                    postions.add(p.func_185334_h());
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (BlockPos p : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(0, -radius, -radius), (BlockPos)pos.func_177982_a(0, radius, radius))) {
                    postions.add(p.func_185334_h());
                }
                break;
            }
        }
        postions.remove(pos.func_185334_h());
        return postions;
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack stack) {
        return ElectricItemManager.getElectricItemManager((IChargableItem)this);
    }

    public long getMaxEnergyStored(ItemStack stack) {
        return this.capacity;
    }

    public int getMaxTransfer(ItemStack stack) {
        return this.maxTransfer;
    }

    public boolean canReceive(ItemStack stack) {
        return this.energyConnection.canReceive();
    }

    public boolean canExtract(ItemStack stack) {
        return this.energyConnection.canExtract();
    }

    public EnergyConnection getEnergyConnection(ItemStack stack) {
        return this.energyConnection;
    }

    public int getEnergyTier(ItemStack stack) {
        return this.energyTier;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemEnergyCapabilityProvider(stack, this.capacity, this.maxTransfer, this.getEnergyStored(stack), this.energyConnection, this.energyTier);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.LIGHT_PURPLE, (String)("Energy Stored: " + UnitHelper.prefix((long)this.getEnergyStored(stack), (long)this.getMaxEnergyStored(stack), (int)5, (String)"RF")));
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.WHITE, (String)("EU Power Tier: " + this.getEnergyTier(stack)));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT((ItemStack)stack);
        if (nbt == null || !nbt.func_74764_b("energy")) {
            return false;
        }
        return nbt.func_74763_f("energy") > 0L;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getEnergyStored(stack) / (double)this.capacity), (double)0.0, (double)1.0);
    }
}

