/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.recipe;

import java.util.List;
import lach_01298.qmd.jei.ingredient.ParticleType;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class JEIRecipeWrapper
implements IRecipeWrapper {
    public final QMDRecipe recipe;
    protected final List<List<ItemStack>> inputItems;
    protected final List<List<ItemStack>> outputItems;
    protected final List<List<FluidStack>> inputFluids;
    protected final List<List<FluidStack>> outputFluids;
    protected final List<List<ParticleStack>> inputParticles;
    protected final List<List<ParticleStack>> outputParticles;
    public final boolean drawArrow;
    public final IDrawable arrow;
    public final int arrowDrawPosX;
    public final int arrowDrawPosY;

    public JEIRecipeWrapper(IGuiHelper guiHelper, QMDRecipe recipe, ResourceLocation arrowLocation, int backX, int backY, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        this.recipe = recipe;
        this.inputItems = QMDRecipeHelper.getItemInputLists(recipe.getItemIngredients());
        this.inputFluids = QMDRecipeHelper.getFluidInputLists(recipe.getFluidIngredients());
        this.outputItems = QMDRecipeHelper.getItemOutputLists(recipe.getItemProducts());
        this.outputFluids = QMDRecipeHelper.getFluidOutputLists(recipe.getFluidProducts());
        this.inputParticles = QMDRecipeHelper.getParticleInputLists(recipe.getParticleIngredients());
        this.outputParticles = QMDRecipeHelper.getParticleOutputLists(recipe.getParticleProducts());
        boolean bl = this.drawArrow = arrowLocation != null;
        if (this.drawArrow) {
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(arrowLocation, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
        } else {
            this.arrow = null;
        }
        this.arrowDrawPosX = arrowPosX - backX;
        this.arrowDrawPosY = arrowPosY - backY;
    }

    protected abstract int getProgressArrowTime();

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.drawArrow) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputItems);
        ingredients.setInputLists(VanillaTypes.FLUID, this.inputFluids);
        ingredients.setInputLists(ParticleType.Particle, this.inputParticles);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputItems);
        ingredients.setOutputLists(VanillaTypes.FLUID, this.outputFluids);
        ingredients.setOutputLists(ParticleType.Particle, this.outputParticles);
    }
}

