/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.block;

import java.util.Random;
import lach_01298.qmd.QMD;
import lach_01298.qmd.enums.BlockTypes;
import nc.block.property.BlockProperties;
import nc.block.tile.BlockSidedTile;
import nc.block.tile.IActivatable;
import nc.block.tile.ITileType;
import nc.init.NCItems;
import nc.tile.ITileGui;
import nc.tile.fluid.ITileFluid;
import nc.tile.processor.IProcessor;
import nc.tile.processor.IUpgradable;
import nc.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQMDProcessor
extends BlockSidedTile
implements IActivatable,
ITileType {
    protected final BlockTypes.ProcessorType type;

    public BlockQMDProcessor(BlockTypes.ProcessorType type) {
        super(Material.field_151573_f);
        if (type.getCreativeTab() != null) {
            this.func_149647_a(type.getCreativeTab());
        }
        this.type = type;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public String getTileName() {
        return this.type.func_176610_l();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type.getTile();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)enumfacing).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING_HORIZONTAL, BlockProperties.ACTIVE});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || hand != EnumHand.MAIN_HAND) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IUpgradable) {
            if (this.installUpgrade(tile, ((IUpgradable)tile).getSpeedUpgradeSlot(), player, hand, facing, new ItemStack(NCItems.upgrade, 1, 0))) {
                return true;
            }
            if (this.installUpgrade(tile, ((IUpgradable)tile).getEnergyUpgradeSlot(), player, hand, facing, new ItemStack(NCItems.upgrade, 1, 1))) {
                return true;
            }
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!(tile instanceof ITileFluid) && !(tile instanceof ITileGui)) {
            return false;
        }
        if (tile instanceof ITileFluid && !(tile instanceof ITileGui) && FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) == null) {
            return false;
        }
        if (tile instanceof ITileFluid) {
            if (world.field_72995_K) {
                return true;
            }
            ITileFluid tileFluid = (ITileFluid)tile;
            boolean accessedTanks = BlockHelper.accessTanks((EntityPlayer)player, (EnumHand)hand, (EnumFacing)facing, (ITileFluid)tileFluid);
            if (accessedTanks) {
                if (tile instanceof IProcessor) {
                    ((IProcessor)tile).refreshRecipe();
                    ((IProcessor)tile).refreshActivity();
                }
                return true;
            }
        }
        if (tile instanceof ITileGui) {
            if (world.field_72995_K) {
                this.onGuiOpened(world, pos);
                return true;
            }
            this.onGuiOpened(world, pos);
            if (tile instanceof IProcessor) {
                ((IProcessor)tile).refreshRecipe();
                ((IProcessor)tile).refreshActivity();
            }
        } else {
            return false;
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)QMD.instance, (int)((ITileGui)tile).getGuiID(), (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            return;
        }
        BlockHelper.spawnParticleOnProcessor((IBlockState)state, (World)world, (BlockPos)pos, (Random)rand, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)), (String)this.type.getParticle1());
        BlockHelper.spawnParticleOnProcessor((IBlockState)state, (World)world, (BlockPos)pos, (Random)rand, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL)), (String)this.type.getParticle2());
    }

    public void setActivity(boolean isActive, TileEntity tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        if (!world.field_72995_K && ((Object)((Object)this)).getClass().isInstance(state.func_177230_c()) && isActive != (Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(isActive)), 2);
        }
    }
}

