/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lach_01298.qmd.multiblock.IMultiBlockTank;
import lach_01298.qmd.util.Util;
import nc.multiblock.Multiblock;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.tile.internal.fluid.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ClearTankPacket
implements IMessage {
    private BlockPos pos;
    private int tankID;

    public ClearTankPacket() {
    }

    public ClearTankPacket(BlockPos pos, int tankID) {
        this.pos = pos;
        this.tankID = tankID;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.tankID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tankID);
    }

    public static class Handler
    implements IMessageHandler<ClearTankPacket, IMessage> {
        public IMessage onMessage(ClearTankPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            }
            return null;
        }

        void processMessage(ClearTankPacket message, MessageContext ctx) {
            Multiblock multiblock;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            if (!world.func_175667_e(message.pos) || !world.func_175660_a((EntityPlayer)player, message.pos)) {
                return;
            }
            TileEntity tile = world.func_175625_s(message.pos);
            if (tile instanceof ITileMultiblockPart && (multiblock = ((ITileMultiblockPart)tile).getMultiblock()) instanceof IMultiBlockTank) {
                IMultiBlockTank mbTanks = (IMultiBlockTank)multiblock;
                List<Tank> tanks = mbTanks.getTanks();
                if (tanks.size() > message.tankID) {
                    tanks.get(message.tankID).setFluid(null);
                } else {
                    Util.getLogger().error("cannot clear multiblock tank " + message.tankID + " as multiblock only has " + tanks.size() + " tanks");
                }
            }
        }
    }
}

