/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.entity.EntityGammaFlash;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.multiblock.network.ContainmentRenderPacket;
import lach_01298.qmd.multiblock.network.NeutralContainmentUpdatePacket;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.network.QMDPacketHandler;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.NucleosynthesisChamberLogic;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.VacuumChamberLogic;
import lach_01298.qmd.vacuumChamber.tile.TileExoticContainmentController;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeamPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberCoil;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberLaser;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberRedstonePort;
import nc.block.property.BlockProperties;
import nc.capability.radiation.entity.IEntityRads;
import nc.multiblock.tile.TileBeefAbstract;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.IRecipe;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.DamageSources;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExoticContainmentLogic
extends VacuumChamberLogic {
    public long particle1WorkDone;
    public long particle2WorkDone;
    public long recipeParticle1Work = 600L;
    public long recipeParticle2Work = 600L;
    public boolean shouldSpecialRenderLasers = false;
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public QMDRecipeInfo<QMDRecipe> rememberedRecipeInfo;
    public RecipeInfo<BasicRecipe> cellRecipeInfo;

    public ExoticContainmentLogic(VacuumChamberLogic oldLogic) {
        super(oldLogic);
        if (oldLogic instanceof NucleosynthesisChamberLogic) {
            this.getMultiblock().tanks.get(2).setFluidStored(null);
        }
    }

    @Override
    public String getID() {
        return "neutral_containment";
    }

    @Override
    public int getMinimumInteriorLength() {
        return 5;
    }

    @Override
    public int getMaximumInteriorLength() {
        return 9;
    }

    @Override
    public void onVacuumChamberFormed() {
        this.getMultiblock().tanks.get(2).setCapacity((int)(Math.pow(this.getMultiblock().getInteriorLengthX() - 4, 3.0) * 8000.0));
        if (!this.getWorld().field_72995_K) {
            int io = 0;
            for (TileVacuumChamberBeamPort port : this.getMultiblock().getPartMap(TileVacuumChamberBeamPort.class).values()) {
                port.setIONumber(io);
                ++io;
            }
            if (this.getMultiblock().controller != null) {
                if (this.getMultiblock().controller instanceof TileExoticContainmentController) {
                    TileExoticContainmentController cont = (TileExoticContainmentController)this.getMultiblock().controller;
                    cont.setIsRenderer(true);
                }
                this.getMultiblock().sendMultiblockUpdatePacketToAll();
                this.getMultiblock().markReferenceCoordForUpdate();
            }
        }
        if (this.getMultiblock().controller != null && this.getMultiblock().controller instanceof TileExoticContainmentController) {
            TileExoticContainmentController cont = (TileExoticContainmentController)this.getMultiblock().controller;
            cont.setIsRenderer(true);
        }
        for (TileVacuumChamberLaser laser : this.getParts(TileVacuumChamberLaser.class)) {
            laser.setIsRenderer(true);
        }
        super.onVacuumChamberFormed();
    }

    @Override
    public void onMachineDisassembled() {
        for (TileVacuumChamberBeamPort tile : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            tile.setIONumber(0);
        }
        if (this.getMultiblock().controller != null && this.getMultiblock().controller instanceof TileExoticContainmentController) {
            TileExoticContainmentController cont = (TileExoticContainmentController)this.getMultiblock().controller;
            cont.setIsRenderer(true);
        }
        for (TileVacuumChamberLaser laser : this.getParts(TileVacuumChamberLaser.class)) {
            laser.setIsRenderer(false);
        }
        if (QMDConfig.exotic_containment_explosion || QMDConfig.exotic_containment_gamma_flash) {
            this.containmentFailure();
        }
        super.onMachineDisassembled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMachineWhole() {
        TileVacuumChamberBeamPort beam;
        void var3_8;
        VacuumChamber con = this.getMultiblock();
        if (con.getExteriorLengthX() != this.getMultiblock().getExteriorLengthZ()) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_square", null, new Object[0]);
            return false;
        }
        if (con.getExteriorLengthX() % 2 != 1) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_odd", null, new Object[0]);
            return false;
        }
        for (BlockPos blockPos : this.getCoilPositions()) {
            if (con.WORLD.func_175625_s(blockPos) instanceof TileVacuumChamberCoil) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_coil", blockPos, new Object[0]);
            return false;
        }
        HashSet<BlockPos> interior = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)con.getExtremeInteriorCoord(false, false, false), (BlockPos)con.getExtremeInteriorCoord(true, true, true))) {
            interior.add(pos.func_185334_h());
        }
        interior.removeAll(this.getCoilPositions());
        for (BlockPos pos : interior) {
            if (con.WORLD.func_180495_p(pos).func_185904_a() == Material.field_151579_a) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_empty", pos, new Object[0]);
            return false;
        }
        BlockPos westMiddle = new BlockPos(con.getMinX(), con.getMiddleY(), con.getMiddleZ());
        BlockPos northMiddle = new BlockPos(con.getMiddleX(), con.getMiddleY(), con.getMinZ());
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(westMiddle) instanceof TileVacuumChamberLaser) {
            EnumFacing.Axis axis = EnumFacing.Axis.X;
        } else if (con.WORLD.func_175625_s(westMiddle) instanceof TileVacuumChamberBeamPort) {
            EnumFacing.Axis axis = EnumFacing.Axis.Z;
        } else {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.beam_port_or_laser", westMiddle, new Object[0]);
            return false;
        }
        if (var3_8 == EnumFacing.Axis.X) {
            if (!(con.WORLD.func_175625_s(westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0)) instanceof TileVacuumChamberLaser)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_laser", westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0), new Object[0]);
                return false;
            }
            if (!(con.WORLD.func_175625_s(northMiddle) instanceof TileVacuumChamberBeamPort)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", northMiddle, new Object[0]);
                return false;
            }
            beam = (TileVacuumChamberBeamPort)con.WORLD.func_175625_s(northMiddle);
            if (beam.getIOType() != EnumTypes.IOType.INPUT) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", northMiddle, new Object[0]);
                return false;
            }
            if (!(con.WORLD.func_175625_s(northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1)) instanceof TileVacuumChamberBeamPort)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1), new Object[0]);
                return false;
            }
            beam = (TileVacuumChamberBeamPort)con.WORLD.func_175625_s(northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1));
            if (beam.getIOType() != EnumTypes.IOType.INPUT) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1), new Object[0]);
                return false;
            }
        } else {
            if (!(con.WORLD.func_175625_s(westMiddle) instanceof TileVacuumChamberBeamPort)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", westMiddle, new Object[0]);
                return false;
            }
            beam = (TileVacuumChamberBeamPort)con.WORLD.func_175625_s(westMiddle);
            if (beam.getIOType() != EnumTypes.IOType.INPUT) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", westMiddle, new Object[0]);
                return false;
            }
            if (!(con.WORLD.func_175625_s(westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0)) instanceof TileVacuumChamberBeamPort)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0), new Object[0]);
                return false;
            }
            beam = (TileVacuumChamberBeamPort)con.WORLD.func_175625_s(westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0));
            if (beam.getIOType() != EnumTypes.IOType.INPUT) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_input_beam", westMiddle.func_177982_a(con.getInteriorLengthX() + 1, 0, 0), new Object[0]);
                return false;
            }
            if (!(con.WORLD.func_175625_s(northMiddle) instanceof TileVacuumChamberLaser)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_laser", northMiddle, new Object[0]);
                return false;
            }
            if (!(con.WORLD.func_175625_s(northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1)) instanceof TileVacuumChamberLaser)) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_be_laser", northMiddle.func_177982_a(0, 0, con.getInteriorLengthZ() + 1), new Object[0]);
                return false;
            }
        }
        int lasers = 0;
        for (TileVacuumChamberLaser laser : this.getPartMap(TileVacuumChamberLaser.class).values()) {
            ++lasers;
        }
        if (lasers != 2) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_have_2_lasers", null, new Object[0]);
            return false;
        }
        int beamPorts = 0;
        for (TileVacuumChamberBeamPort port : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            ++beamPorts;
        }
        if (beamPorts != 2) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.exotic_containment.must_have_2_beam_ports", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole();
    }

    public Set<BlockPos> getCoilPositions() {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        VacuumChamber con = this.getMultiblock();
        boolean top = false;
        for (int i = 0; i < 2; ++i) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)con.getExtremeInteriorCoord(false, top, false).func_177982_a(1, 0, 1), (BlockPos)con.getExtremeInteriorCoord(true, top, false).func_177982_a(-1, 0, 1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)con.getExtremeInteriorCoord(false, top, true).func_177982_a(1, 0, -1), (BlockPos)con.getExtremeInteriorCoord(true, top, true).func_177982_a(-1, 0, -1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)con.getExtremeInteriorCoord(false, top, false).func_177982_a(1, 0, 2), (BlockPos)con.getExtremeInteriorCoord(false, top, true).func_177982_a(1, 0, -2))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)con.getExtremeInteriorCoord(true, top, false).func_177982_a(-1, 0, 2), (BlockPos)con.getExtremeInteriorCoord(true, top, true).func_177982_a(-1, 0, -2))) {
                postions.add(pos.func_185334_h());
            }
            top = true;
        }
        return postions;
    }

    @Override
    public boolean onUpdateServer() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.getMultiblock().beams.get(1).setParticleStack(null);
        this.pull();
        this.getMultiblock().currentHeating = 0L;
        if (this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
            this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
            this.internalHeating();
            if (this.getMultiblock().getTemperature() <= this.getMultiblock().maxOperatingTemp) {
                this.operational = true;
                this.refreshCellRecipe();
                if (this.cellRecipeInfo != null) {
                    this.produceCellProduct();
                }
                this.refreshRecipe();
                if (this.recipeInfo != null) {
                    if (this.rememberedRecipeInfo != null && this.rememberedRecipeInfo.getRecipe() != this.recipeInfo.getRecipe()) {
                        this.particle1WorkDone = 0L;
                        this.particle2WorkDone = 0L;
                    }
                    this.rememberedRecipeInfo = this.recipeInfo;
                    if (this.canProduceProduct()) {
                        boolean switchInputs = false;
                        if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
                            if (this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack() != null) {
                                if (((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getParticle() != this.getMultiblock().beams.get(0).getParticleStack().getParticle()) {
                                    switchInputs = true;
                                }
                            } else {
                                switchInputs = true;
                            }
                        }
                        if (!switchInputs && this.getMultiblock().beams.get(1).getParticleStack() != null) {
                            if (this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack() != null) {
                                if (((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack()).getParticle() != this.getMultiblock().beams.get(1).getParticleStack().getParticle()) {
                                    switchInputs = true;
                                }
                            } else {
                                switchInputs = true;
                            }
                        }
                        if (this.getMultiblock().beams.get(0).getParticleStack() != null) {
                            this.particle1WorkDone += (long)this.getMultiblock().beams.get(0).getParticleStack().getAmount();
                        }
                        if (this.getMultiblock().beams.get(1).getParticleStack() != null) {
                            this.particle2WorkDone += (long)this.getMultiblock().beams.get(1).getParticleStack().getAmount();
                        }
                        this.produceProduct(switchInputs);
                    }
                }
            } else {
                if (this.operational) {
                    this.containmentFailure();
                }
                this.operational = false;
            }
        } else {
            this.containmentFailure();
            this.operational = false;
        }
        this.updateRedstone();
        if (this.getMultiblock().controller != null) {
            QMDPacketHandler.instance.sendToAll((IMessage)this.getMultiblock().getRenderPacket());
            this.getMultiblock().sendMultiblockUpdatePacketToListeners();
            this.getMultiblock().sendRenderToAllPlayers();
        }
        return super.onUpdateServer();
    }

    private void containmentFailure() {
        if (!this.getMultiblock().tanks.get(2).isEmpty() && this.getMultiblock().tanks.get(2).getFluid() != null) {
            FluidStack fluid = this.getMultiblock().tanks.get(2).getFluid();
            double size = 1.0;
            switch (fluid.getFluid().getName()) {
                case "antihydrogen": {
                    size = 1.0;
                    break;
                }
                case "antideuterium": {
                    size = 2.0;
                    break;
                }
                case "antitritium": 
                case "antihelium3": {
                    size = 3.0;
                    break;
                }
                case "antiHelium": {
                    size = 4.0;
                    break;
                }
                case "positronium": {
                    size = 5.4E-4;
                }
                case "muonium": {
                    size = 0.11;
                    break;
                }
                case "tauonium": {
                    size = 1.9;
                    break;
                }
                case "glueballs": {
                    size = 1.8;
                }
            }
            size *= (double)fluid.amount / 1000.0;
            BlockPos middle = new BlockPos(this.getMultiblock().getMiddleX(), this.getMultiblock().getMiddleY(), this.getMultiblock().getMiddleZ());
            if (QMDConfig.exotic_containment_explosion) {
                this.getMultiblock().WORLD.func_72876_a(null, (double)middle.func_177958_n(), (double)middle.func_177956_o(), (double)middle.func_177952_p(), (float)(size * QMDConfig.exotic_containment_explosion_size), true);
            } else {
                ((VacuumChamber)this.multiblock).WORLD.func_175655_b(((VacuumChamber)this.multiblock).controller.getTilePos(), false);
            }
            if (QMDConfig.exotic_containment_gamma_flash) {
                this.getMultiblock().WORLD.func_72838_d((Entity)new EntityGammaFlash(this.getMultiblock().WORLD, middle.func_177958_n(), middle.func_177956_o(), middle.func_177952_p(), size));
                HashSet entitylist = new HashSet();
                double radius = 128.0 * Math.sqrt(size);
                entitylist.addAll(this.getMultiblock().WORLD.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)middle.func_177958_n() - radius, (double)middle.func_177956_o() - radius, (double)middle.func_177952_p() - radius, (double)middle.func_177958_n() + radius, (double)middle.func_177956_o() + radius, (double)middle.func_177952_p() + radius)));
                for (EntityLivingBase entity : entitylist) {
                    IEntityRads entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)entity);
                    if (entityRads == null) continue;
                    double rads = Math.min(QMDConfig.exotic_containment_radiation * size, QMDConfig.exotic_containment_radiation * size / middle.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                    entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity((IEntityRads)entityRads, (EntityLivingBase)entity, (double)rads, (boolean)false, (boolean)false, (int)1));
                    if (!(rads >= entityRads.getMaxRads())) continue;
                    entity.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                }
            }
            this.getMultiblock().tanks.get(2).setFluidStored(null);
        }
    }

    @Nonnull
    public List<Tank> getHeaterVentTanks(List<Tank> backupTanks) {
        return this.getMultiblock().isAssembled() ? this.getMultiblock().tanks.subList(0, 2) : backupTanks;
    }

    protected void refreshRecipe() {
        ArrayList<ParticleStack> particles = new ArrayList<ParticleStack>();
        particles.add(this.getMultiblock().beams.get(0).getParticleStack());
        particles.add(this.getMultiblock().beams.get(1).getParticleStack());
        this.recipeInfo = QMDRecipes.neutral_containment.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), new ArrayList<Tank>(), particles);
    }

    protected void refreshCellRecipe() {
        ArrayList<ItemIngredient> itemIngredients = new ArrayList<ItemIngredient>();
        ArrayList<Object> fluidIngredients = new ArrayList<Object>();
        TileExoticContainmentController cont = (TileExoticContainmentController)this.getMultiblock().controller;
        if (((ItemStack)cont.getInventoryStacks().get(0)).func_77973_b() instanceof IItemParticleAmount) {
            ItemStack itemStack = (ItemStack)cont.getInventoryStacks().get(0);
            IItemParticleAmount item = (IItemParticleAmount)itemStack.func_77973_b();
            if (item.getAmountStored(itemStack) == IItemParticleAmount.getCapacity(itemStack) && IItemParticleAmount.getCapacity(itemStack) > 0) {
                ItemIngredient itemIngredient = new ItemIngredient((ItemStack)cont.getInventoryStacks().get(0));
                itemIngredients.add(itemIngredient);
                EmptyFluidIngredient fluidIngredient = new EmptyFluidIngredient();
                fluidIngredients = new ArrayList();
                fluidIngredients.add(fluidIngredient);
                BasicRecipe recipe = (BasicRecipe)QMDRecipes.cell_filling.getRecipeFromIngredients(itemIngredients, fluidIngredients);
                if (recipe != null) {
                    RecipeMatchResult matchResult = recipe.matchIngredients(itemIngredients, fluidIngredients);
                    this.cellRecipeInfo = new RecipeInfo((IRecipe)recipe, matchResult);
                }
            } else {
                ItemIngredient itemIngredient;
                if (item.getAmountStored(itemStack) == 0) {
                    itemIngredient = new ItemIngredient(IItemParticleAmount.cleanNBT((ItemStack)cont.getInventoryStacks().get(0)));
                    itemIngredients.add(itemIngredient);
                } else {
                    itemIngredient = new ItemIngredient(item.getEmptyItem());
                    itemIngredients.add(itemIngredient);
                }
                ArrayList fluids = new ArrayList();
                Tank tank = this.getMultiblock().tanks.get(2);
                if (tank.getFluid() != null) {
                    FluidStack copy = tank.getFluid().copy();
                    FluidIngredient fluidIngredient = new FluidIngredient(copy);
                    fluidIngredients.add(fluidIngredient);
                    BasicRecipe recipe = (BasicRecipe)QMDRecipes.cell_filling.getRecipeFromIngredients(itemIngredients, fluidIngredients);
                    if (recipe != null) {
                        RecipeMatchResult matchResult = recipe.matchIngredients(itemIngredients, fluidIngredients);
                        this.cellRecipeInfo = new RecipeInfo((IRecipe)recipe, matchResult);
                    }
                }
            }
        }
    }

    private boolean canProduceProduct() {
        FluidStack product = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
        return product != null && this.getMultiblock().tanks.get(2).fill(product, false) == product.amount;
    }

    private void produceProduct(boolean switchInputs) {
        if (switchInputs) {
            this.recipeParticle1Work = this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack() == null ? 0L : (long)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack()).getAmount();
            this.recipeParticle2Work = this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack() == null ? 0L : (long)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount();
        } else {
            this.recipeParticle1Work = this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack() == null ? 0L : (long)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount();
            this.recipeParticle2Work = this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack() == null ? 0L : (long)((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(1).getStack()).getAmount();
        }
        while (this.particle1WorkDone >= this.recipeParticle1Work && this.particle2WorkDone >= this.recipeParticle2Work && this.canProduceProduct()) {
            FluidStack product = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
            this.getMultiblock().tanks.get(2).fill(product, true);
            this.particle1WorkDone = Math.max(0L, this.particle1WorkDone - this.recipeParticle1Work);
            this.particle2WorkDone = Math.max(0L, this.particle2WorkDone - this.recipeParticle2Work);
        }
    }

    private void produceCellProduct() {
        TileExoticContainmentController cont = (TileExoticContainmentController)this.getMultiblock().controller;
        ItemStack itemInput = (ItemStack)cont.getInventoryStacks().get(0);
        ItemStack itemOutput = (ItemStack)cont.getInventoryStacks().get(1);
        if (itemOutput.func_190916_E() <= 0) {
            cont.getInventoryStacks().set(1, (Object)ItemStack.field_190927_a);
        }
        if (itemOutput != ItemStack.field_190927_a) {
            return;
        }
        if (!(itemInput.func_77973_b() instanceof IItemParticleAmount)) {
            return;
        }
        IItemParticleAmount item = (IItemParticleAmount)itemInput.func_77973_b();
        ItemStack itemProduct = (ItemStack)((IItemIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getItemProducts().get(0)).getStack();
        int amount = item.getAmountStored(itemInput);
        if (amount == 0) {
            if (((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidProducts().get(0)).getStack() == null) {
                ItemStack outputItem = (ItemStack)((IItemIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getItemProducts().get(0)).getStack();
                if (!(outputItem.func_77973_b() instanceof IItemParticleAmount)) {
                    return;
                }
                IItemParticleAmount output = (IItemParticleAmount)outputItem.func_77973_b();
                int amountPerMillibuckets = IItemParticleAmount.getCapacity(outputItem) / ((FluidStack)((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidIngredients().get((int)0)).getStack()).amount;
                if (!this.getMultiblock().tanks.get(2).isEmpty()) {
                    int cellAmount = amountPerMillibuckets * this.getMultiblock().tanks.get((int)2).drain((FluidStack)((FluidStack)((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidIngredients().get((int)0)).getStack()), (boolean)true).amount;
                    output.setAmountStored(outputItem, cellAmount);
                    cont.getInventoryStacks().set(0, (Object)outputItem);
                    if (output.getAmountStored(outputItem) == IItemParticleAmount.getCapacity(outputItem)) {
                        cont.getInventoryStacks().set(1, (Object)outputItem);
                        cont.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        } else if (amount < IItemParticleAmount.getCapacity(itemInput)) {
            ItemStack output;
            if (((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidProducts().get(0)).getStack() == null && (output = (ItemStack)((IItemIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getItemProducts().get(0)).getStack()).func_77973_b() == ((ItemStack)cont.getInventoryStacks().get(0)).func_77973_b() && output.func_77960_j() == ((ItemStack)cont.getInventoryStacks().get(0)).func_77960_j()) {
                int amountPerMillibuckets = IItemParticleAmount.getCapacity(output) / ((FluidStack)((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidIngredients().get((int)0)).getStack()).amount;
                if (!this.getMultiblock().tanks.get(2).isEmpty()) {
                    int recipemb = ((FluidStack)((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidIngredients().get((int)0)).getStack()).amount;
                    int cellAmount = 0;
                    cellAmount = recipemb - amount / amountPerMillibuckets <= 0 ? amount + amountPerMillibuckets : amount + amountPerMillibuckets * this.getMultiblock().tanks.get((int)2).drain((int)(recipemb - amount / amountPerMillibuckets), (boolean)true).amount;
                    item.setAmountStored(output, cellAmount);
                    cont.getInventoryStacks().set(0, (Object)output);
                    if (item.getAmountStored(output) == IItemParticleAmount.getCapacity(output)) {
                        cont.getInventoryStacks().set(1, (Object)output);
                        cont.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        } else if (((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidProducts().get(0)).getStack() != null) {
            FluidStack fluidProduct = (FluidStack)((IFluidIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getFluidProducts().get(0)).getStack();
            if (this.getMultiblock().tanks.get(2).fill(fluidProduct, false) == fluidProduct.amount) {
                this.getMultiblock().tanks.get(2).fill(fluidProduct, true);
                cont.getInventoryStacks().set(0, (Object)ItemStack.field_190927_a);
                ItemStack output = (ItemStack)((IItemIngredient)((BasicRecipe)this.cellRecipeInfo.getRecipe()).getItemProducts().get(0)).getStack();
                item.setAmountStored(output, IItemParticleAmount.getCapacity(output));
                cont.getInventoryStacks().set(1, (Object)output);
            }
        }
    }

    @Override
    protected void updateRedstone() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getMultiblock().WORLD.func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                if (this.getMultiblock().tanks.get(2).getFluidAmount() > 0 && (int)(15.0 * ((double)this.getMultiblock().tanks.get(2).getFluidAmount() / (double)this.getMultiblock().tanks.get(2).getCapacity())) == 0) {
                    port.setRedstoneLevel(1);
                    continue;
                }
                port.setRedstoneLevel((int)(15.0 * ((double)this.getMultiblock().tanks.get(2).getFluidAmount() / (double)this.getMultiblock().tanks.get(2).getCapacity())));
                continue;
            }
            port.setRedstoneLevel((int)(15.0 * ((double)this.getMultiblock().getTemperature() / (double)this.getMultiblock().maxOperatingTemp)));
        }
    }

    @Override
    public void onUpdateClient() {
    }

    private void refreshStats() {
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74772_a("particle1WorkDone", this.particle1WorkDone);
        logicTag.func_74772_a("particle2WorkDone", this.particle2WorkDone);
        logicTag.func_74772_a("recipeParticle1Work", this.recipeParticle1Work);
        logicTag.func_74772_a("recipeParticle2Work", this.recipeParticle2Work);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.particle1WorkDone = logicTag.func_74763_f("particle1WorkDone");
        this.particle2WorkDone = logicTag.func_74763_f("particle2WorkDone");
        this.recipeParticle1Work = logicTag.func_74763_f("recipeParticle1Work");
        this.recipeParticle2Work = logicTag.func_74763_f("recipeParticle2Work");
    }

    @Override
    public VacuumChamberUpdatePacket getMultiblockUpdatePacket() {
        return new NeutralContainmentUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().heating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams, this.particle1WorkDone, this.particle2WorkDone, this.recipeParticle1Work, this.recipeParticle2Work);
    }

    @Override
    public void onMultiblockUpdatePacket(VacuumChamberUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof NeutralContainmentUpdatePacket) {
            NeutralContainmentUpdatePacket packet = (NeutralContainmentUpdatePacket)message;
            this.getMultiblock().beams = packet.beams;
            for (int i = 0; i < this.getMultiblock().tanks.size(); ++i) {
                this.getMultiblock().tanks.get(i).readInfo(message.tanksInfo.get(i));
            }
            this.particle1WorkDone = packet.particle1WorkDone;
            this.particle2WorkDone = packet.particle2WorkDone;
            this.recipeParticle1Work = packet.recipeParticle1Work;
            this.recipeParticle2Work = packet.recipeParticle2Work;
        }
    }

    @Override
    public ContainmentRenderPacket getRenderPacket() {
        return new ContainmentRenderPacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().tanks);
    }

    @Override
    public void onRenderPacket(ContainmentRenderPacket message) {
        this.getMultiblock().tanks.get(2).setFluidAmount(message.tanksInfo.get(2).amount());
    }
}

