/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.ContainmentRenderPacket;
import lach_01298.qmd.multiblock.network.NucleosynthesisChamberUpdatePacket;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.ExoticContainmentLogic;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.VacuumChamberLogic;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberComponent;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeam;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeamPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberFluidPort;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberHeater;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberHeaterVent;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPlasmaGlass;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPlasmaNozzle;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberRedstonePort;
import nc.block.property.BlockProperties;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NucleosynthesisChamberLogic
extends VacuumChamberLogic {
    public boolean searchFlag = false;
    public final ObjectSet<TileVacuumChamberHeater> heaterCache = new ObjectOpenHashSet();
    public final Long2ObjectMap<TileVacuumChamberHeater> componentFailCache = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<TileVacuumChamberHeater> assumedValidCache = new Long2ObjectOpenHashMap();
    public static final int chamberLength = 11;
    public static final int chamberWidth = 5;
    public static final int chamberHeight = 7;
    public long particleWorkDone;
    public long recipeParticleWork = 600L;
    public boolean plasmaOn = false;
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public QMDRecipeInfo<QMDRecipe> rememberedRecipeInfo;
    public static final int CASING_MAX_TEMP = 2400;
    public static final int cooling_efficiency_leniency = 20;
    public double casingHeating = 0.0;
    public long casingCooling = 0L;
    public int maxCasingCoolantIn = 0;
    public int maxCasingCoolantOut = 0;
    private int excessCasingCoolant = 0;
    private double excessCasingHeat = 0.0;
    public RecipeInfo<BasicRecipe> casingCoolingRecipeInfo;
    public final HeatBuffer casingHeatBuffer = new HeatBuffer((long)QMDConfig.accelerator_base_heat_capacity);

    public NucleosynthesisChamberLogic(VacuumChamberLogic oldLogic) {
        super(oldLogic);
        if (oldLogic instanceof ExoticContainmentLogic) {
            this.getMultiblock().tanks.get(2).setFluidStored(null);
        }
    }

    @Override
    public String getID() {
        return "nucleosynthesis_chamber";
    }

    @Override
    public int getMinimumInteriorLength() {
        return 3;
    }

    @Override
    public int getMaximumInteriorLength() {
        return 9;
    }

    @Override
    public void onVacuumChamberFormed() {
        TileVacuumChamberFluidPort fluidPort;
        BlockPos fluidPortOutPos2;
        BlockPos fluidPortOutPos1;
        TileVacuumChamberFluidPort fluidPort2;
        this.getMultiblock().tanks.get(2).setCapacity(QMDConfig.vacuum_chamber_input_tank_capacity * 100);
        this.getMultiblock().tanks.get(2).setAllowedFluids(QMDRecipes.vacuum_chamber_heater_valid_fluids.get(0));
        this.getMultiblock().tanks.get(3).setCapacity(QMDConfig.vacuum_chamber_output_tank_capacity * 100);
        this.getMultiblock().tanks.get(4).setCapacity(QMDConfig.vacuum_chamber_input_tank_capacity * 10);
        this.getMultiblock().tanks.get(4).setAllowedFluids(QMDRecipes.nucleosynthesis_valid_fluids.get(0));
        this.getMultiblock().tanks.get(5).setCapacity(QMDConfig.vacuum_chamber_input_tank_capacity * 10);
        this.getMultiblock().tanks.get(5).setAllowedFluids(QMDRecipes.nucleosynthesis_valid_fluids.get(0));
        this.getMultiblock().tanks.get(6).setCapacity(QMDConfig.vacuum_chamber_output_tank_capacity * 10);
        this.getMultiblock().tanks.get(7).setCapacity(QMDConfig.vacuum_chamber_output_tank_capacity * 10);
        this.casingHeatBuffer.setHeatCapacity((long)(QMDConfig.accelerator_base_heat_capacity * this.getCapacityMultiplier()));
        if (!this.getWorld().field_72995_K) {
            int io = 0;
            for (TileVacuumChamberBeamPort port : this.getMultiblock().getPartMap(TileVacuumChamberBeamPort.class).values()) {
                port.setIONumber(io);
                ++io;
            }
            if (this.getMultiblock().controller != null) {
                this.getMultiblock().sendMultiblockUpdatePacketToAll();
                this.getMultiblock().markReferenceCoordForUpdate();
            }
            for (TileVacuumChamberBeam beam : this.getMultiblock().getPartMap(TileVacuumChamberBeam.class).values()) {
                beam.setFunctional(true);
            }
            this.casingCooling = 0L;
            this.casingHeating = 0.0;
            this.componentFailCache.clear();
            do {
                this.assumedValidCache.clear();
                this.refreshHeaters();
            } while (this.searchFlag);
            for (IVacuumChamberComponent part : this.getMultiblock().getPartMap(IVacuumChamberComponent.class).values()) {
                if (!(part instanceof TileVacuumChamberHeater)) continue;
                TileVacuumChamberHeater heater = (TileVacuumChamberHeater)part;
                if (!part.isFunctional()) continue;
                this.casingCooling += (long)heater.coolingRate;
            }
        }
        BlockPos beamPortPos = null;
        for (TileVacuumChamberBeamPort port : this.getParts(TileVacuumChamberBeamPort.class)) {
            beamPortPos = port.func_174877_v();
        }
        BlockPos fluidPortInPos1 = beamPortPos.func_177982_a(0, 3, 0);
        BlockPos fluidPortInPos2 = beamPortPos.func_177982_a(0, 1, 0);
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos1) instanceof TileVacuumChamberFluidPort) {
            fluidPort2 = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos1);
            fluidPort2.setIONumber(4);
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos2) instanceof TileVacuumChamberFluidPort) {
            fluidPort2 = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos2);
            fluidPort2.setIONumber(5);
        }
        if (((VacuumChamber)this.multiblock).getExteriorLengthX() > ((VacuumChamber)this.multiblock).getExteriorLengthZ()) {
            if (beamPortPos.func_177958_n() <= ((VacuumChamber)this.multiblock).getMinX()) {
                fluidPortOutPos1 = beamPortPos.func_177982_a(10, 3, 0);
                fluidPortOutPos2 = beamPortPos.func_177982_a(10, 1, 0);
            } else {
                fluidPortOutPos1 = beamPortPos.func_177982_a(-10, 3, 0);
                fluidPortOutPos2 = beamPortPos.func_177982_a(-10, 1, 0);
            }
        } else if (beamPortPos.func_177952_p() <= ((VacuumChamber)this.multiblock).getMinZ()) {
            fluidPortOutPos1 = beamPortPos.func_177982_a(0, 3, 10);
            fluidPortOutPos2 = beamPortPos.func_177982_a(0, 1, 10);
        } else {
            fluidPortOutPos1 = beamPortPos.func_177982_a(0, 3, -10);
            fluidPortOutPos2 = beamPortPos.func_177982_a(0, 1, -10);
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos1) instanceof TileVacuumChamberFluidPort) {
            fluidPort = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos1);
            fluidPort.setIONumber(6);
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos2) instanceof TileVacuumChamberFluidPort) {
            fluidPort = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos2);
            fluidPort.setIONumber(7);
        }
        super.onVacuumChamberFormed();
    }

    private void refreshHeaters() {
        this.searchFlag = false;
        if (this.getPartMap(TileVacuumChamberHeater.class).isEmpty()) {
            return;
        }
        for (TileVacuumChamberHeater heater : this.getParts(TileVacuumChamberHeater.class)) {
            heater.isInValidPosition = false;
            heater.isSearched = false;
        }
        this.heaterCache.clear();
        for (TileVacuumChamberHeater heater : this.getParts(TileVacuumChamberHeater.class)) {
            if (!heater.isSearchRoot()) continue;
            this.iterateHeaterSearch(heater, this.heaterCache);
        }
        for (TileVacuumChamberHeater heater : this.assumedValidCache.values()) {
            if (heater.isInValidPosition) continue;
            this.componentFailCache.put(heater.func_174877_v().func_177986_g(), (Object)heater);
            this.searchFlag = true;
        }
    }

    private void iterateHeaterSearch(TileVacuumChamberHeater rootHeater, ObjectSet<TileVacuumChamberHeater> heaterCache) {
        ObjectOpenHashSet searchCache = new ObjectOpenHashSet();
        rootHeater.coolerSearch(heaterCache, (ObjectSet<TileVacuumChamberHeater>)searchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator searchIterator = searchCache.iterator();
            ObjectOpenHashSet searchSubCache = new ObjectOpenHashSet();
            while (searchIterator.hasNext()) {
                TileVacuumChamberHeater component = (TileVacuumChamberHeater)searchIterator.next();
                searchIterator.remove();
                component.coolerSearch(heaterCache, (ObjectSet<TileVacuumChamberHeater>)searchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            searchCache.addAll((Collection)searchSubCache);
        } while (!searchCache.isEmpty());
    }

    @Override
    public void onMachineDisassembled() {
        for (TileVacuumChamberPart tile : this.getPartMap(TileVacuumChamberBeamPort.class).values()) {
            ((TileVacuumChamberBeamPort)tile).setIONumber(0);
        }
        for (TileVacuumChamberPart tile : this.getPartMap(TileVacuumChamberFluidPort.class).values()) {
            ((TileVacuumChamberFluidPort)tile).setIONumber(0);
        }
        for (TileVacuumChamberBeam beam : this.getMultiblock().getPartMap(TileVacuumChamberBeam.class).values()) {
            beam.setFunctional(false);
        }
        if (this.plasmaOn) {
            if (this.getMultiblock().WORLD.field_72995_K) {
                this.plasmaOn = false;
            } else if (QMDConfig.nucleosynthesis_chamber_explosion) {
                this.containmentFailure();
            }
        }
        super.onMachineDisassembled();
    }

    @Override
    public boolean isMachineWhole() {
        TileVacuumChamberFluidPort fluidPort;
        BlockPos fluidPortOutPos2;
        BlockPos fluidPortOutPos1;
        TileVacuumChamberFluidPort fluidPort2;
        BlockPos beamPortPos;
        BlockPos nozzle2;
        BlockPos nozzle1;
        EnumFacing.Axis axis;
        VacuumChamber chamber = this.getMultiblock();
        if (chamber.getExteriorLengthX() > chamber.getExteriorLengthZ()) {
            axis = EnumFacing.Axis.X;
            if (chamber.getExteriorLengthX() != 11) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.size", null, new Object[0]);
                return false;
            }
            if (chamber.getExteriorLengthZ() != 5) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.size", null, new Object[0]);
                return false;
            }
        } else {
            axis = EnumFacing.Axis.Z;
            if (chamber.getExteriorLengthZ() != 11) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.size", null, new Object[0]);
                return false;
            }
            if (chamber.getExteriorLengthX() != 5) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.size", null, new Object[0]);
                return false;
            }
        }
        if (chamber.getExteriorLengthY() != 7) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.size", null, new Object[0]);
            return false;
        }
        for (BlockPos pos : this.getBeamPositions(axis)) {
            if (chamber.WORLD.func_175625_s(pos) instanceof TileVacuumChamberBeam) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_beam", pos, new Object[0]);
            return false;
        }
        for (BlockPos pos : this.getGlassPositions(axis)) {
            if (chamber.WORLD.func_175625_s(pos) instanceof TileVacuumChamberPlasmaGlass) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_plasma_glass", pos, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            nozzle1 = chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 1, 1);
            nozzle2 = chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(-1, 1, 1);
            if (!(chamber.WORLD.func_175625_s(nozzle1) instanceof TileVacuumChamberPlasmaNozzle) || chamber.WORLD.func_180495_p(nozzle1).func_177229_b((IProperty)BlockProperties.AXIS_ALL) != axis) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_plasma_nozzle", nozzle1, new Object[0]);
                return false;
            }
            if (!(chamber.WORLD.func_175625_s(nozzle2) instanceof TileVacuumChamberPlasmaNozzle) || chamber.WORLD.func_180495_p(nozzle2).func_177229_b((IProperty)BlockProperties.AXIS_ALL) != axis) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_plasma_nozzle", nozzle2, new Object[0]);
                return false;
            }
        } else {
            nozzle1 = chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 1, 1);
            nozzle2 = chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(1, 1, -1);
            if (!(chamber.WORLD.func_175625_s(nozzle1) instanceof TileVacuumChamberPlasmaNozzle) || chamber.WORLD.func_180495_p(nozzle1).func_177229_b((IProperty)BlockProperties.AXIS_ALL) != axis) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_plasma_nozzle", nozzle1, new Object[0]);
                return false;
            }
            if (!(chamber.WORLD.func_175625_s(nozzle2) instanceof TileVacuumChamberPlasmaNozzle) || chamber.WORLD.func_180495_p(nozzle2).func_177229_b((IProperty)BlockProperties.AXIS_ALL) != axis) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_plasma_nozzle", nozzle2, new Object[0]);
                return false;
            }
        }
        HashSet<BlockPos> interior = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false), (BlockPos)chamber.getExtremeInteriorCoord(true, true, true))) {
            interior.add(pos.func_185334_h());
        }
        interior.removeAll(this.getBeamPositions(axis));
        interior.removeAll(this.getGlassPositions(axis));
        interior.removeAll(this.getPlasmaPositions(axis));
        interior.remove(nozzle1);
        interior.remove(nozzle2);
        Fluid plasma = FluidRegistry.getFluid((String)"plasma");
        Block block = plasma == null ? null : plasma.getBlock();
        IBlockState plasmaState = block == null ? Blocks.field_150350_a.func_176223_P() : block.func_176223_P();
        for (BlockPos pos : this.getPlasmaPositions(axis)) {
            if (chamber.WORLD.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P() || chamber.WORLD.func_180495_p(pos) == plasmaState) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_empty", pos, new Object[0]);
            return false;
        }
        for (BlockPos pos : interior) {
            if (chamber.WORLD.func_180495_p(pos).func_185904_a() == Material.field_151579_a || chamber.WORLD.func_175625_s(pos) instanceof TileVacuumChamberHeater) continue;
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_heater_or_empty", pos, new Object[0]);
            return false;
        }
        int beamPorts = 0;
        if (axis == EnumFacing.Axis.X) {
            beamPortPos = new BlockPos(chamber.getMinX(), chamber.getMiddleY() - 1, chamber.getMiddleZ());
            if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(beamPortPos) instanceof TileVacuumChamberBeamPort) {
                ++beamPorts;
            } else if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(new BlockPos(chamber.getMaxX(), chamber.getMiddleY() - 1, chamber.getMiddleZ())) instanceof TileVacuumChamberBeamPort) {
                beamPortPos = new BlockPos(chamber.getMaxX(), chamber.getMiddleY() - 1, chamber.getMiddleZ());
                ++beamPorts;
            }
        } else {
            beamPortPos = new BlockPos(chamber.getMiddleX(), chamber.getMiddleY() - 1, chamber.getMinZ());
            if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(beamPortPos) instanceof TileVacuumChamberBeamPort) {
                ++beamPorts;
            } else if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(new BlockPos(chamber.getMiddleX(), chamber.getMiddleY() - 1, chamber.getMaxZ())) instanceof TileVacuumChamberBeamPort) {
                beamPortPos = new BlockPos(chamber.getMiddleX(), chamber.getMiddleY() - 1, chamber.getMaxZ());
                ++beamPorts;
            }
        }
        if (beamPorts != 1) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_beam", beamPortPos, new Object[0]);
            return false;
        }
        TileVacuumChamberBeamPort beamPort = (TileVacuumChamberBeamPort)chamber.WORLD.func_175625_s(beamPortPos);
        if (beamPort.getIOType() != EnumTypes.IOType.INPUT) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_beam", beamPortPos, new Object[0]);
            return false;
        }
        BlockPos fluidPortInPos1 = beamPortPos.func_177982_a(0, 3, 0);
        BlockPos fluidPortInPos2 = beamPortPos.func_177982_a(0, 1, 0);
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos1) instanceof TileVacuumChamberFluidPort) {
            fluidPort2 = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos1);
            if (((Boolean)fluidPort2.getBlockState(fluidPort2.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_fluid_port", fluidPortInPos1, new Object[0]);
                return false;
            }
        } else {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_fluid_port", fluidPortInPos1, new Object[0]);
            return false;
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos2) instanceof TileVacuumChamberFluidPort) {
            fluidPort2 = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortInPos2);
            if (((Boolean)fluidPort2.getBlockState(fluidPort2.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_fluid_port", fluidPortInPos2, new Object[0]);
                return false;
            }
        } else {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_input_fluid_port", fluidPortInPos2, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            if (beamPortPos.func_177958_n() <= chamber.getMinX()) {
                fluidPortOutPos1 = beamPortPos.func_177982_a(10, 3, 0);
                fluidPortOutPos2 = beamPortPos.func_177982_a(10, 1, 0);
            } else {
                fluidPortOutPos1 = beamPortPos.func_177982_a(-10, 3, 0);
                fluidPortOutPos2 = beamPortPos.func_177982_a(-10, 1, 0);
            }
        } else if (beamPortPos.func_177952_p() <= chamber.getMinZ()) {
            fluidPortOutPos1 = beamPortPos.func_177982_a(0, 3, 10);
            fluidPortOutPos2 = beamPortPos.func_177982_a(0, 1, 10);
        } else {
            fluidPortOutPos1 = beamPortPos.func_177982_a(0, 3, -10);
            fluidPortOutPos2 = beamPortPos.func_177982_a(0, 1, -10);
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos1) instanceof TileVacuumChamberFluidPort) {
            fluidPort = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos1);
            if (!((Boolean)fluidPort.getBlockState(fluidPort.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_output_fluid_port", fluidPortOutPos1, new Object[0]);
                return false;
            }
        } else {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_output_fluid_port", fluidPortOutPos1, new Object[0]);
            return false;
        }
        if (((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos2) instanceof TileVacuumChamberFluidPort) {
            fluidPort = (TileVacuumChamberFluidPort)((VacuumChamber)this.multiblock).WORLD.func_175625_s(fluidPortOutPos2);
            if (!((Boolean)fluidPort.getBlockState(fluidPort.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_output_fluid_port", fluidPortOutPos2, new Object[0]);
                return false;
            }
        } else {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_be_output_fluid_port", fluidPortOutPos2, new Object[0]);
            return false;
        }
        int fluidPorts = 0;
        for (TileVacuumChamberFluidPort fluidPort3 : this.getPartMap(TileVacuumChamberFluidPort.class).values()) {
            ++fluidPorts;
        }
        if (fluidPorts != 4) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.must_have_4_fluid_ports", null, new Object[0]);
            return false;
        }
        boolean inlet = false;
        boolean outlet = false;
        for (TileVacuumChamberHeaterVent vent : this.getPartMap(TileVacuumChamberHeaterVent.class).values()) {
            if (!((Boolean)vent.getBlockState(vent.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                inlet = true;
                continue;
            }
            outlet = true;
        }
        if (!inlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.no_heater_inlet", null, new Object[0]);
            return false;
        }
        if (!outlet) {
            ((VacuumChamber)this.multiblock).setLastError("qmd.multiblock_validation.nucleosynthesis_chamber.no_heater_outlet", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole();
    }

    public Set<BlockPos> getBeamPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        VacuumChamber chamber = this.getMultiblock();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, true, false).func_177982_a(0, 0, 1), (BlockPos)chamber.getExtremeInteriorCoord(true, true, false).func_177982_a(0, 0, 1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, true, false).func_177982_a(0, -1, 1), (BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(0, 1, 1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(true, true, false).func_177982_a(0, -1, 1), (BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(0, 1, 1))) {
                postions.add(pos.func_185334_h());
            }
        } else {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, true, false).func_177982_a(1, 0, 0), (BlockPos)chamber.getExtremeInteriorCoord(false, true, true).func_177982_a(1, 0, 0))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, true, false).func_177982_a(1, -1, 0), (BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 1, 0))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, true, true).func_177982_a(1, -1, 0), (BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(1, 1, 0))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    public Set<BlockPos> getGlassPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        VacuumChamber chamber = this.getMultiblock();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(2, 0, 1), (BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(-2, 0, 1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(2, 1, 0), (BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(-2, 1, 0))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(2, 2, 1), (BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(-2, 2, 1))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(2, 1, 0), (BlockPos)chamber.getExtremeInteriorCoord(true, false, true).func_177982_a(-2, 1, 0))) {
                postions.add(pos.func_185334_h());
            }
        } else {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 0, 2), (BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(1, 0, -2))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(0, 1, 2), (BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(0, 1, -2))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 2, 2), (BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(1, 2, -2))) {
                postions.add(pos.func_185334_h());
            }
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(0, 1, 2), (BlockPos)chamber.getExtremeInteriorCoord(true, false, true).func_177982_a(0, 1, -2))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    public Set<BlockPos> getPlasmaPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        VacuumChamber chamber = this.getMultiblock();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(2, 1, 1), (BlockPos)chamber.getExtremeInteriorCoord(true, false, false).func_177982_a(-2, 1, 1))) {
                postions.add(pos.func_185334_h());
            }
        } else {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)chamber.getExtremeInteriorCoord(false, false, false).func_177982_a(1, 1, 2), (BlockPos)chamber.getExtremeInteriorCoord(false, false, true).func_177982_a(1, 1, -2))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    @Override
    public boolean onUpdateServer() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.pull();
        this.getMultiblock().currentHeating = 0L;
        if (!this.getMultiblock().tanks.get(4).isEmpty() || !this.getMultiblock().tanks.get(5).isEmpty()) {
            if (this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
                this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                this.internalHeating();
                if (this.getMultiblock().getTemperature() <= this.getMultiblock().maxOperatingTemp) {
                    this.operational = true;
                    this.refreshRecipe();
                    if (!this.plasmaOn) {
                        this.setPlasma(true);
                    }
                    if (this.recipeInfo != null) {
                        if (this.rememberedRecipeInfo != null && this.rememberedRecipeInfo.getRecipe() != this.recipeInfo.getRecipe()) {
                            this.particleWorkDone = 0L;
                            this.startRecipe();
                        }
                        this.rememberedRecipeInfo = this.recipeInfo;
                        if (this.canProduceProduct()) {
                            this.processRecipe();
                            while (this.particleWorkDone >= this.recipeParticleWork && this.canProduceProduct()) {
                                this.startRecipe();
                                this.finishRecipe();
                            }
                        }
                    } else {
                        this.casingExternalCooling();
                    }
                } else {
                    if (this.operational && this.plasmaOn) {
                        this.containmentFailure();
                    }
                    this.operational = false;
                }
            } else if (this.plasmaOn) {
                this.containmentFailure();
            }
        } else if (this.plasmaOn) {
            this.setPlasma(false);
            this.operational = false;
        }
        this.refreshCasingFluidRecipe();
        if (this.canProcessCasingFluidInputs()) {
            this.produceCasingFluidProducts();
        }
        this.updateRedstone();
        this.getMultiblock().sendMultiblockUpdatePacketToListeners();
        return super.onUpdateServer();
    }

    private void setPlasma(boolean on) {
        IBlockState plasmaState;
        Fluid plasma;
        this.plasmaOn = on;
        EnumFacing.Axis axis = EnumFacing.Axis.Z;
        if (((VacuumChamber)this.multiblock).getExteriorLengthX() > ((VacuumChamber)this.multiblock).getExteriorLengthZ()) {
            axis = EnumFacing.Axis.X;
        }
        Block block = (plasma = FluidRegistry.getFluid((String)"plasma")) == null ? null : plasma.getBlock();
        IBlockState iBlockState = plasmaState = block == null ? Blocks.field_150350_a.func_176223_P() : block.func_176223_P();
        if (on) {
            for (BlockPos pos : this.getPlasmaPositions(axis)) {
                if (((VacuumChamber)this.multiblock).WORLD.func_180495_p(pos) == plasmaState) continue;
                ((VacuumChamber)this.multiblock).WORLD.func_175656_a(pos, plasmaState);
            }
        } else {
            for (BlockPos pos : this.getPlasmaPositions(axis)) {
                if (((VacuumChamber)this.multiblock).WORLD.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P()) continue;
                ((VacuumChamber)this.multiblock).WORLD.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    private void startRecipe() {
        if (this.getMultiblock().tanks.get(4).getFluid() != null) {
            if (this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack() != null && this.getMultiblock().tanks.get(4).getFluid().getFluid() == ((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack()).getFluid()) {
                this.getMultiblock().tanks.get(4).drain((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack(), true);
            } else if (this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack() != null && this.getMultiblock().tanks.get(4).getFluid().getFluid() == ((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack()).getFluid()) {
                this.getMultiblock().tanks.get(4).drain((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack(), true);
            }
        }
        if (this.getMultiblock().tanks.get(5).getFluid() != null) {
            if (this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack() != null && this.getMultiblock().tanks.get(5).getFluid().getFluid() == ((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack()).getFluid()) {
                this.getMultiblock().tanks.get(5).drain((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(0).getStack(), true);
            } else if (this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack() != null && this.getMultiblock().tanks.get(5).getFluid().getFluid() == ((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack()).getFluid()) {
                this.getMultiblock().tanks.get(5).drain((FluidStack)this.rememberedRecipeInfo.getRecipe().getFluidIngredients().get(1).getStack(), true);
            }
        }
    }

    private void processRecipe() {
        this.recipeParticleWork = ((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount();
        this.particleWorkDone += (long)this.getMultiblock().beams.get(0).getParticleStack().getAmount();
        Long totalHeat = this.recipeInfo.getRecipe().getHeatReleased();
        this.casingHeating = (double)totalHeat.longValue() / (double)this.recipeParticleWork * (double)this.getMultiblock().beams.get(0).getParticleStack().getAmount();
        this.casingHeatBuffer.addHeat((long)this.casingHeating, false);
        this.excessCasingHeat += this.casingHeating - (double)((long)this.casingHeating);
        if (this.excessCasingHeat > 1.0) {
            this.casingHeatBuffer.addHeat((long)this.excessCasingHeat, false);
            this.excessCasingHeat -= (double)((long)this.excessCasingHeat);
        }
        if (this.casingHeatBuffer.isFull()) {
            this.overheat();
        }
    }

    private void finishRecipe() {
        IFluidIngredient fluidOutput1 = this.recipeInfo.getRecipe().getFluidProducts().get(0);
        IFluidIngredient fluidOutput2 = this.recipeInfo.getRecipe().getFluidProducts().get(1);
        if (fluidOutput1.getStack() != null) {
            this.getMultiblock().tanks.get(6).fill((FluidStack)fluidOutput1.getStack(), true);
        }
        if (fluidOutput2.getStack() != null) {
            this.getMultiblock().tanks.get(7).fill((FluidStack)fluidOutput2.getStack(), true);
        }
        this.particleWorkDone = Math.max(0L, this.particleWorkDone - this.recipeParticleWork);
    }

    protected void refreshRecipe() {
        ArrayList<ParticleStack> particles = new ArrayList<ParticleStack>();
        ArrayList<Tank> tanks = new ArrayList<Tank>();
        particles.add(this.getMultiblock().beams.get(0).getParticleStack());
        tanks.add(this.getMultiblock().tanks.get(4));
        tanks.add(this.getMultiblock().tanks.get(5));
        this.recipeInfo = QMDRecipes.nucleosynthesis_chamber.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), tanks, particles);
    }

    private boolean canProduceProduct() {
        IFluidIngredient fluidOutput1 = this.recipeInfo.getRecipe().getFluidProducts().get(0);
        IFluidIngredient fluidOutput2 = this.recipeInfo.getRecipe().getFluidProducts().get(1);
        return (fluidOutput1.getStack() != null && this.getMultiblock().tanks.get(6).fill((FluidStack)fluidOutput1.getStack(), false) == ((FluidStack)fluidOutput1.getStack()).amount || fluidOutput1 instanceof EmptyFluidIngredient) && (fluidOutput2.getStack() != null && this.getMultiblock().tanks.get(7).fill((FluidStack)fluidOutput2.getStack(), false) == ((FluidStack)fluidOutput2.getStack()).amount || fluidOutput2 instanceof EmptyFluidIngredient);
    }

    protected void refreshCasingFluidRecipe() {
        this.casingCoolingRecipeInfo = QMDRecipes.vacuum_chamber_heating.getRecipeInfoFromInputs(new ArrayList(), this.getMultiblock().tanks.subList(2, 3));
        if (this.casingCoolingRecipeInfo != null) {
            this.maxCasingCoolantIn = 1000 / ((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(this.casingCooling * (long)((IFluidIngredient)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getMaxStackSize(0));
            this.maxCasingCoolantOut = 1000 / ((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (int)(this.casingCooling * (long)((IFluidIngredient)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFluidProducts().get(0)).getMaxStackSize(0));
        }
    }

    protected boolean canProcessCasingFluidInputs() {
        if (this.casingCoolingRecipeInfo == null) {
            return false;
        }
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        if (fluidProduct.getMaxStackSize(0) <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        if (!this.getMultiblock().tanks.get(3).isEmpty()) {
            if (!this.getMultiblock().tanks.get(3).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getMultiblock().tanks.get(3).getFluidAmount() + (this.maxCasingCoolantIn / 1000 + 1) * fluidProduct.getNextStack((int)0).amount > this.getMultiblock().tanks.get(3).getCapacity()) {
                return false;
            }
            if (this.casingHeatBuffer.getHeatStored() < 1L) {
                return false;
            }
        }
        return true;
    }

    private void produceCasingFluidProducts() {
        int uBConsumed = this.maxCasingCoolantIn;
        if (uBConsumed > this.getMultiblock().tanks.get(2).getFluidAmount() * 1000) {
            uBConsumed = this.getMultiblock().tanks.get(2).getFluidAmount() * 1000;
        }
        if ((double)uBConsumed / 1000.0 * (double)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() > (double)this.casingHeatBuffer.getHeatStored()) {
            uBConsumed = (int)(1000.0 / (double)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB() * (double)this.casingHeatBuffer.getHeatStored());
        }
        int mBConsumed = 0;
        if (uBConsumed % 1000 != 0) {
            mBConsumed = (uBConsumed + (1000 - uBConsumed % 1000)) / 1000;
            this.excessCasingCoolant += 1000 - uBConsumed % 1000;
        } else {
            mBConsumed = uBConsumed / 1000;
        }
        if (this.excessCasingCoolant > 1000) {
            mBConsumed -= this.excessCasingCoolant / 1000;
            this.excessCasingCoolant %= 1000;
        }
        this.getMultiblock().tanks.get(2).changeFluidAmount((int)((double)(-mBConsumed) * this.getCoolingEfficiency()));
        if (this.getMultiblock().tanks.get(2).getFluidAmount() <= 0) {
            this.getMultiblock().tanks.get(2).setFluidStored(null);
        }
        this.casingHeatBuffer.changeHeatStored((long)(-mBConsumed * ((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFissionHeatingHeatPerInputMB()));
        IFluidIngredient fluidProduct = (IFluidIngredient)((BasicRecipe)this.casingCoolingRecipeInfo.getRecipe()).getFluidProducts().get(0);
        int producedCoolant = (int)((double)mBConsumed * this.getCoolingEfficiency()) * fluidProduct.getNextStack((int)0).amount;
        if (this.getMultiblock().tanks.get(3).isEmpty()) {
            this.getMultiblock().tanks.get(3).changeFluidStored(fluidProduct.getNextStack(0).getFluid(), producedCoolant);
        } else {
            this.getMultiblock().tanks.get(3).changeFluidAmount(producedCoolant);
        }
    }

    public double getCoolingEfficiency() {
        return Math.min(1.0, (this.casingHeating + 20.0) / (this.casingHeating + Math.abs(this.casingHeating - (double)this.casingCooling)));
    }

    private void containmentFailure() {
        if (QMDConfig.nucleosynthesis_chamber_explosion) {
            IBlockState plasmaState;
            this.plasmaOn = false;
            ArrayList<BlockPos> components = new ArrayList<BlockPos>();
            for (TileVacuumChamberBeam beam : this.getPartMap(TileVacuumChamberBeam.class).values()) {
                components.add(beam.func_174877_v());
            }
            for (TileVacuumChamberPlasmaGlass glass : this.getPartMap(TileVacuumChamberPlasmaGlass.class).values()) {
                components.add(glass.func_174877_v());
            }
            for (TileVacuumChamberPlasmaNozzle nozzle : this.getPartMap(TileVacuumChamberPlasmaNozzle.class).values()) {
                components.add(nozzle.func_174877_v());
            }
            Fluid plasma = FluidRegistry.getFluid((String)"plasma");
            Block block = plasma == null ? null : plasma.getBlock();
            IBlockState iBlockState = plasmaState = block == null ? Blocks.field_150350_a.func_176223_P() : block.func_176223_P();
            if (!components.isEmpty()) {
                int breaches = 1 + this.rand.nextInt(1 + components.size() / 8);
                for (int i = 0; i < breaches; ++i) {
                    int j = this.rand.nextInt(components.size());
                    BlockPos component = (BlockPos)components.get(j);
                    ((VacuumChamber)this.multiblock).WORLD.func_72876_a(null, (double)component.func_177958_n(), (double)component.func_177956_o(), (double)component.func_177952_p(), 4.0f, true);
                    ((VacuumChamber)this.multiblock).WORLD.func_175656_a(component, plasmaState);
                    components.remove(j);
                }
            }
        } else {
            this.setPlasma(false);
            ((VacuumChamber)this.multiblock).WORLD.func_175655_b(((VacuumChamber)this.multiblock).controller.getTilePos(), false);
        }
    }

    private void overheat() {
        this.casingHeatBuffer.setHeatStored(0L);
        this.containmentFailure();
    }

    public double getCasingTemperature() {
        return ((VacuumChamber)this.multiblock).ambientTemp + Math.round(2400.0f * (float)this.casingHeatBuffer.getHeatStored() / (float)this.casingHeatBuffer.getHeatCapacity());
    }

    protected void casingExternalCooling() {
        this.casingHeatBuffer.addHeat((long)(((double)((VacuumChamber)this.multiblock).ambientTemp - this.getCasingTemperature()) * QMDConfig.accelerator_thermal_conductivity * (double)((VacuumChamber)this.multiblock).getExteriorSurfaceArea()), false);
    }

    @Override
    public void onUpdateClient() {
    }

    private void refreshStats() {
    }

    @Override
    protected void updateRedstone() {
        for (TileVacuumChamberRedstonePort port : this.getPartMap(TileVacuumChamberRedstonePort.class).values()) {
            if (((Boolean)this.getMultiblock().WORLD.func_180495_p(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
                port.setRedstoneLevel((int)(15.0 * ((double)this.casingHeatBuffer.getHeatStored() / (double)this.casingHeatBuffer.getHeatCapacity())));
                continue;
            }
            port.setRedstoneLevel((int)(15.0 * ((double)this.getMultiblock().getTemperature() / (double)this.getMultiblock().maxOperatingTemp)));
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74772_a("particleWorkDone", this.particleWorkDone);
        logicTag.func_74772_a("recipeParticleWork", this.recipeParticleWork);
        logicTag.func_74780_a("casingHeating", this.casingHeating);
        logicTag.func_74772_a("casingCooling", this.casingCooling);
        logicTag.func_74780_a("excessCasingHeat", this.excessCasingHeat);
        logicTag.func_74768_a("maxCasingCoolantIn", this.maxCasingCoolantIn);
        logicTag.func_74768_a("maxCasingCoolantOut", this.maxCasingCoolantOut);
        logicTag.func_74768_a("excessCasingCoolant", this.excessCasingCoolant);
        this.casingHeatBuffer.writeToNBT(logicTag, "casingHeatBuffer");
        logicTag.func_74757_a("plasmaOn", this.plasmaOn);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.particleWorkDone = logicTag.func_74763_f("particleWorkDone");
        this.recipeParticleWork = logicTag.func_74763_f("recipeParticleWork");
        this.casingHeating = logicTag.func_74769_h("casingHeating");
        this.casingCooling = logicTag.func_74763_f("casingCooling");
        this.excessCasingHeat = logicTag.func_74769_h("excessCasingHeat");
        this.maxCasingCoolantIn = logicTag.func_74762_e("maxCasingCoolantIn");
        this.maxCasingCoolantOut = logicTag.func_74762_e("maxCasingCoolantOut");
        this.excessCasingCoolant = logicTag.func_74762_e("excessCasingCoolant");
        this.casingHeatBuffer.readFromNBT(logicTag, "casingHeatBuffer");
        this.plasmaOn = logicTag.func_74767_n("plasmaOn");
    }

    @Override
    public VacuumChamberUpdatePacket getMultiblockUpdatePacket() {
        return new NucleosynthesisChamberUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().heating, this.getMultiblock().currentHeating, this.getMultiblock().maxCoolantIn, this.getMultiblock().maxCoolantOut, this.getMultiblock().maxOperatingTemp, this.getMultiblock().requiredEnergy, this.getMultiblock().heatBuffer, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams, this.particleWorkDone, this.recipeParticleWork, this.casingHeating, this.casingCooling, this.maxCasingCoolantIn, this.maxCasingCoolantOut, this.casingHeatBuffer);
    }

    @Override
    public void onMultiblockUpdatePacket(VacuumChamberUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof NucleosynthesisChamberUpdatePacket) {
            NucleosynthesisChamberUpdatePacket packet = (NucleosynthesisChamberUpdatePacket)message;
            this.getMultiblock().beams = packet.beams;
            for (int i = 0; i < this.getMultiblock().tanks.size(); ++i) {
                this.getMultiblock().tanks.get(i).readInfo(message.tanksInfo.get(i));
            }
            this.particleWorkDone = packet.particleWorkDone;
            this.recipeParticleWork = packet.recipeParticleWork;
            this.casingHeating = packet.casingHeating;
            this.casingCooling = packet.casingCooling;
            this.maxCasingCoolantIn = packet.maxCasingCoolantIn;
            this.maxCasingCoolantOut = packet.maxCasingCoolantOut;
            this.casingHeatBuffer.setHeatCapacity(packet.casingHeatBuffer.getHeatCapacity());
            this.casingHeatBuffer.setHeatStored(packet.casingHeatBuffer.getHeatStored());
        }
    }

    @Override
    public ContainmentRenderPacket getRenderPacket() {
        return null;
    }

    @Override
    public void onRenderPacket(ContainmentRenderPacket message) {
    }
}

