/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.model;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.renderer.RenderParameters;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ModelVariantContainer<T extends AdvertModel.IModelVariant> {
    private AdvertModel<T> model;
    private T variant;
    private boolean wallMounted = false;

    public ModelVariantContainer(AdvertModel<T> model, T variant, boolean wallMounted) {
        this.wallMounted = wallMounted;
        if (variant == null || variant.isWallMounted() != wallMounted) {
            variant = model.defaultVariant(wallMounted);
        }
        this.model = model;
        this.variant = variant;
        this.model = model;
        this.variant = variant;
    }

    public AdvertModel<T> getModel() {
        return this.model;
    }

    public T getVariant() {
        return this.variant;
    }

    public AxisAlignedBB[] getBoundingBox() {
        return this.model.getBoundingBox(this.variant);
    }

    public void renderBlock(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp) {
        this.model.renderBlock(renderer, tileEntity, rp, this.variant);
    }

    public void renderTileEntity(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp) {
        this.model.renderTileEntity(renderer, tileEntity, rp, this.variant);
    }

    public int getGuiComponent(MalisisGui gui, UIContainer<?> container) {
        return this.model.getGuiComponent(gui, container, this.variant, this.wallMounted);
    }

    public void toNBT(AdvertTileEntity te, NBTTagCompound nbt) {
        nbt.func_74778_a("model", this.model.getId());
        this.model.writeToNBT(te, nbt);
        if (this.variant != null) {
            this.variant.writeToNBT(nbt);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.model.getId());
        if (this.variant != null) {
            this.variant.toBytes(buf);
        }
    }

    public static <T extends AdvertModel.IModelVariant> ModelVariantContainer<T> fromNBT(AdvertTileEntity te, NBTTagCompound nbt) {
        AdvertModel<?> model = AdvertModel.getModel(nbt.func_74779_i("model"));
        model.readFromNBT(te, nbt);
        Object variant = model.defaultVariant(te.isWallMounted());
        if (variant != null) {
            variant.readFromNBT(nbt);
        }
        return new ModelVariantContainer(model, variant, te.isWallMounted());
    }

    public static <T extends AdvertModel.IModelVariant> ModelVariantContainer<T> fromGui(UISelect<AdvertModel<?>> selModel, UIContainer<?> modelCont, boolean isWallMounted) {
        AdvertModel model = (AdvertModel)selModel.getSelectedValue();
        Object variant = model.getVariantFromGui(modelCont);
        return new ModelVariantContainer(model, variant, isWallMounted);
    }

    public static <T extends AdvertModel.IModelVariant> ModelVariantContainer<T> fromBytes(ByteBuf buf) {
        AdvertModel<?> model = AdvertModel.getModel(ByteBufUtils.readUTF8String((ByteBuf)buf));
        Object variant = model.defaultVariant(false);
        if (variant != null) {
            variant.fromBytes(buf);
        }
        return new ModelVariantContainer(model, variant, variant != null ? variant.isWallMounted() : false);
    }

    public static ModelVariantContainer<?> getDefaultContainer(boolean wallMounted) {
        return new ModelVariantContainer<Object>(AdvertModel.getModel(null), null, wallMounted);
    }
}

