/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemReinforcedEnderBucket
extends ItemBase {
    public ItemReinforcedEnderBucket() {
        super("reinforcedEnderBucket");
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 10000);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack contained = item.drain(10000, false);
        if (contained != null) {
            Fluid f = contained.getFluid();
            if (f == FluidRegistry.WATER) {
                return Color.BLUE.getRGB();
            }
            if (f == FluidRegistry.LAVA) {
                return Color.ORANGE.getRGB();
            }
            if (f != null && f.getName() != null && f.getName().equals("astralsorcery.liquidstarlight")) {
                return Color.WHITE.getRGB();
            }
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack contained = item.drain(10000, false);
        float filledPercent = contained == null ? 0.0f : (float)contained.amount / 10000.0f;
        return 1.0f - filledPercent;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack fluidStack = item.drain(1, false);
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        IFluidHandlerItem item = (IFluidHandlerItem)itemstack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        RayTraceResult mop = WorldUtil.rayTraceAll(world, player, true);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState hitState = world.func_180495_p(mop.func_178782_a());
            Block hitBlock = hitState.func_177230_c();
            boolean collectAll = player.func_70093_af();
            if (hitBlock instanceof IFluidBlock || hitBlock instanceof BlockLiquid) {
                ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
                HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
                stack.add(mop.func_178782_a());
                while (!stack.isEmpty()) {
                    BlockPos next = (BlockPos)stack.remove(0);
                    alreadyChecked.add(next);
                    if (alreadyChecked.size() <= 2000) {
                        IBlockState nextState;
                        Block nextBlock;
                        if (!world.func_175667_e(next) || !((nextBlock = (nextState = world.func_180495_p(next)).func_177230_c()) instanceof IFluidBlock) && !(nextBlock instanceof BlockLiquid)) continue;
                        FluidActionResult pickupResult = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (EntityPlayer)player, (World)world, (BlockPos)next, (EnumFacing)EnumFacing.UP);
                        if (pickupResult.success) {
                            if (!collectAll) {
                                return new ActionResult(EnumActionResult.SUCCESS, (Object)pickupResult.result);
                            }
                            itemstack = pickupResult.result;
                        }
                        for (EnumFacing facing : EnumFacing.field_82609_l) {
                            BlockPos addingPos = next.func_177972_a(facing);
                            if (alreadyChecked.contains(addingPos)) continue;
                            stack.add(addingPos);
                            alreadyChecked.add(addingPos);
                        }
                        continue;
                    }
                    break;
                }
            } else {
                FluidActionResult result;
                BlockPos targetPos;
                BlockPos clickPos;
                FluidStack fluidStack = item.drain(1000, false);
                if (fluidStack != null && fluidStack.amount >= 1000 && world.func_175660_a(player, clickPos = mop.func_178782_a()) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack)).isSuccess()) {
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    ItemStack drained = result.getResult();
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)drained);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }
}

