/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.IStackSrc;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class DamagedItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final Optional<IStackSrc> source;

    public DamagedItemDefinition(@Nonnull String identifier, @Nonnull IStackSrc source) {
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)source);
        this.source = source.isEnabled() ? Optional.of(source) : Optional.empty();
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Optional<Item> maybeItem() {
        return this.source.map(IStackSrc::getItem);
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.source.map(input -> input.stack(stackSize));
    }

    @Override
    public boolean isEnabled() {
        return this.source.isPresent();
    }

    @Override
    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack.func_190926_b()) {
            return false;
        }
        return this.isEnabled() && comparableStack.func_77973_b() == this.source.get().getItem() && comparableStack.func_77952_i() == this.source.get().getDamage();
    }
}

