/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.api.IRecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeRegistry;
import com.mrcrayfish.furniture.api.RecipeRegistryComm;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.blocks.tv.Channels;
import com.mrcrayfish.furniture.entity.EntityMirror;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.gui.GuiHandler;
import com.mrcrayfish.furniture.handler.ConfigurationHandler;
import com.mrcrayfish.furniture.handler.PlayerEvents;
import com.mrcrayfish.furniture.init.FurnitureTab;
import com.mrcrayfish.furniture.init.FurnitureTileEntities;
import com.mrcrayfish.furniture.init.RegistrationHandler;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.proxy.CommonProxy;
import com.mrcrayfish.furniture.render.tileentity.MirrorRenderer;
import java.lang.reflect.Method;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="cfm", name="MrCrayfish's Furniture Mod", version="5.3.1", guiFactory="com.mrcrayfish.furniture.gui.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class MrCrayfishFurnitureMod {
    @Mod.Instance(value="cfm")
    public static MrCrayfishFurnitureMod instance;
    @SidedProxy(clientSide="com.mrcrayfish.furniture.proxy.ClientProxy", serverSide="com.mrcrayfish.furniture.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabFurniture;
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        RegistrationHandler.init();
        PacketHandler.init();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        Triggers.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new MirrorRenderer());
        }
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FurnitureTileEntities.register();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cfm:mountable_block"), EntitySittableBlock.class, (String)"MountableBlock", (int)0, (Object)this, (int)80, (int)1, (boolean)false);
        if (event.getSide() == Side.CLIENT) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cfm:mirror"), EntityMirror.class, (String)"Mirror", (int)1, (Object)this, (int)80, (int)1, (boolean)false);
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeRegistry.registerDefaultRecipes();
        RecipeRegistry.registerConfigRecipes();
        Recipes.addCommRecipesToLocal();
        Recipes.updateDataList();
        Channels.registerChannels();
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        if (event.getMessages().size() > 0 && ConfigurationHandler.api_debug) {
            logger.info("RecipeAPI (InterModComm): Registering recipes from " + event.getMessages().size() + " mod(s).");
        }
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (!imcMessage.isStringMessage() || !imcMessage.key.equalsIgnoreCase("register")) continue;
            this.register(imcMessage.getStringValue(), imcMessage.getSender());
        }
    }

    public void register(String method, String modid) {
        String[] data = method.split("\\.");
        String methodName = data[data.length - 1];
        String className = method.substring(0, method.length() - methodName.length() - 1);
        String modName = ((ModContainer)Loader.instance().getIndexedModList().get(modid)).getName();
        try {
            Class<?> clazz = Class.forName(className);
            Method registerMethod = clazz.getDeclaredMethod(methodName, IRecipeRegistry.class);
            registerMethod.invoke(null, RecipeRegistryComm.getInstance(modName));
        }
        catch (Exception e) {
            logger.info("RecipeAPI: Unable to register comm recipes for " + modid);
            e.printStackTrace();
        }
    }

    public static Logger logger() {
        return logger;
    }

    static {
        tabFurniture = new FurnitureTab("tabFurniture");
    }
}

