/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.blocks.IDesk;
import com.mrcrayfish.furniture.util.StateHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDesk
extends BlockFurniture
implements IDesk {
    public static final PropertyEnum<DeskType> TYPE = PropertyEnum.func_177709_a((String)"type", DeskType.class);

    public BlockDesk(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)DeskType.NONE)));
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)"tile.desk.info", (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + "Hold SHIFT for Info");
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof IDesk) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.CORNER_RIGHT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.CORNER_LEFT));
            }
        }
        boolean left = false;
        boolean right = false;
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) instanceof IDesk) {
            left = true;
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) instanceof IDesk) {
            right = true;
        }
        if (left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.LEFT));
        }
        if (!left && right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.RIGHT));
        }
        if (!left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.NONE));
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)DeskType.BOTH));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public static enum DeskType implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        CORNER_LEFT,
        CORNER_RIGHT;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

