/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityGrill;
import com.mrcrayfish.furniture.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrill
extends BlockFurnitureTile {
    public static final AxisAlignedBB NORTH_SOUTH_BOUDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375);
    public static final AxisAlignedBB EAST_WEST_BOUDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 1.0, 1.0);
    public static final AxisAlignedBB[] TOP = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.75, 0.125, 0.9375, 1.0, 0.875), new AxisAlignedBB(0.125, 0.75, 0.0625, 0.875, 1.0, 0.9375), new AxisAlignedBB(0.0625, 0.75, 0.125, 0.9375, 1.0, 0.875), new AxisAlignedBB(0.125, 0.75, 0.0625, 0.875, 1.0, 0.9375)};
    public static final AxisAlignedBB[] GRILL = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.3125, 0.1875, 0.875, 0.3125, 0.8125), new AxisAlignedBB(0.1875, 0.3125, 0.125, 0.8125, 0.3125, 0.875), new AxisAlignedBB(0.125, 0.3125, 0.1875, 0.875, 0.3125, 0.8125), new AxisAlignedBB(0.1875, 0.3125, 0.125, 0.8125, 0.3125, 0.875)};
    public static final AxisAlignedBB[] LEGS = new AxisAlignedBB[]{new AxisAlignedBB(0.8125, 0.0, 0.15625, 0.90625, 0.75, 0.25), new AxisAlignedBB(0.09375, 0.0, 0.15625, 0.1875, 0.75, 0.25), new AxisAlignedBB(0.90625, 0.0, 0.75, 0.8125, 0.75, 0.84375), new AxisAlignedBB(0.09375, 0.0, 0.75, 0.1875, 0.75, 0.84375), new AxisAlignedBB(0.75, 0.0, 0.09375, 0.84375, 0.75, 0.1875), new AxisAlignedBB(0.15625, 0.0, 0.09375, 0.25, 0.75, 0.1875), new AxisAlignedBB(0.75, 0.0, 0.8125, 0.84375, 0.75, 0.90625), new AxisAlignedBB(0.15625, 0.0, 0.8125, 0.25, 0.75, 0.90625), new AxisAlignedBB(0.8125, 0.0, 0.15625, 0.90625, 0.75, 0.25), new AxisAlignedBB(0.09375, 0.0, 0.15625, 0.1875, 0.75, 0.25), new AxisAlignedBB(0.90625, 0.0, 0.75, 0.8125, 0.75, 0.84375), new AxisAlignedBB(0.09375, 0.0, 0.75, 0.1875, 0.75, 0.84375), new AxisAlignedBB(0.75, 0.0, 0.09375, 0.84375, 0.75, 0.1875), new AxisAlignedBB(0.15625, 0.0, 0.09375, 0.25, 0.75, 0.1875), new AxisAlignedBB(0.75, 0.0, 0.8125, 0.84375, 0.75, 0.90625), new AxisAlignedBB(0.15625, 0.0, 0.8125, 0.25, 0.75, 0.90625)};

    public BlockGrill(Material material) {
        super(material);
        this.func_149711_c(1.5f);
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176736_b() % 2 == 0 ? NORTH_SOUTH_BOUDING_BOX : EAST_WEST_BOUDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        TileEntityGrill tileEntityGrill;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityGrill && (tileEntityGrill = (TileEntityGrill)tileEntity).isFireStarted()) {
            if (RANDOM.nextInt(2) == 0) {
                double posX = 0.2 + 0.6 * RANDOM.nextDouble();
                double posZ = 0.2 + 0.6 * RANDOM.nextDouble();
                worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + posX, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + posZ, 0.0, 0.0, 0.0, new int[0]);
            }
            if (tileEntityGrill.leftCooked && tileEntityGrill.getItem(0) != null && RecipeAPI.getGrillRecipeFromInput(tileEntityGrill.getItem(0)) != null) {
                int meta = this.func_176201_c(state);
                float[] leftFixed = ParticleHelper.fixRotation(meta, 0.5f, 0.25f);
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + leftFixed[0]), (double)pos.func_177956_o() + 1.0, (double)((float)pos.func_177952_p() + leftFixed[1]), 0.0, 0.0, 0.0, new int[0]);
            }
            if (tileEntityGrill.rightCooked && tileEntityGrill.getItem(1) != null && RecipeAPI.getGrillRecipeFromInput(tileEntityGrill.getItem(1)) != null) {
                int meta = this.func_176201_c(state);
                float[] rightFixed = ParticleHelper.fixRotation(meta, 0.5f, 0.75f);
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rightFixed[0]), (double)pos.func_177956_o() + 1.0, (double)((float)pos.func_177952_p() + rightFixed[1]), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityGrill) {
                TileEntityGrill tileEntityGrill = (TileEntityGrill)tileEntity;
                if (!heldItem.func_190926_b()) {
                    if (heldItem.func_77973_b() == Items.field_151044_h && heldItem.func_77952_i() == 1) {
                        if (tileEntityGrill.addCoal()) {
                            heldItem.func_190918_g(1);
                        }
                    } else if (heldItem.func_77973_b() == Items.field_151033_d) {
                        tileEntityGrill.startFire();
                    } else if (heldItem.func_77973_b() == FurnitureItems.SPATULA && facing == EnumFacing.UP) {
                        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        tileEntityGrill.flipFood(this.getClickedSide(side, hitX, hitZ));
                    } else if (RecipeAPI.getGrillRecipeFromInput(heldItem) != null && facing == EnumFacing.UP) {
                        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        if (tileEntityGrill.addFood(this.getClickedSide(side, hitX, hitZ), heldItem)) {
                            heldItem.func_190918_g(1);
                        }
                    } else {
                        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        tileEntityGrill.removeFood(this.getClickedSide(side, hitX, hitZ));
                    }
                } else {
                    EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    tileEntityGrill.removeFood(this.getClickedSide(side, hitX, hitZ));
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGrill();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ClickedSide getClickedSide(EnumFacing facing, float hitX, float hitZ) {
        switch (facing) {
            case NORTH: {
                if ((double)hitX <= 0.5) {
                    return ClickedSide.LEFT;
                }
                return ClickedSide.RIGHT;
            }
            case EAST: {
                if ((double)hitZ <= 0.5) {
                    return ClickedSide.LEFT;
                }
                return ClickedSide.RIGHT;
            }
            case SOUTH: {
                if ((double)hitX <= 0.5) {
                    return ClickedSide.RIGHT;
                }
                return ClickedSide.LEFT;
            }
            case WEST: {
                if ((double)hitZ <= 0.5) {
                    return ClickedSide.RIGHT;
                }
                return ClickedSide.LEFT;
            }
        }
        return ClickedSide.UNKNOWN;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        list.add(TOP[facing.func_176736_b()]);
        list.add(GRILL[facing.func_176736_b()]);
        for (int i = 0; i < 4; ++i) {
            list.add(LEGS[facing.func_176736_b() * 4 + i]);
        }
        return list;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public static enum ClickedSide {
        LEFT(0),
        RIGHT(1),
        UNKNOWN(2);

        public int id;

        private ClickedSide(int id) {
            this.id = id;
        }
    }
}

