/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.detail.Networking;

public class BlockDecorDropper
extends BlockDecorDirected {
    public static final PropertyBool OPEN = BlockDoor.field_176519_b;

    public BlockDecorDropper(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b((IProperty)OPEN) != false ? 8 : 0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
            return;
        }
        NBTTagCompound te_nbt = stack.func_77978_p().func_74775_l("tedata");
        if (te_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(te_nbt, false);
        ((BTileEntity)te).reset_rtstate();
        ((BTileEntity)te).func_70296_d();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound te_nbt = new NBTTagCompound();
        ((BTileEntity)te).writenbt(te_nbt, false);
        if (!te_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("tedata", (NBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset_rtstate();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213105, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        if (!(world instanceof World) || world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).block_updated();
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BContainer(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BGui(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    Networking.IPacketReceiver {
        public static final int TICK_INTERVAL = 32;
        public static final int NUM_OF_SLOTS = 15;
        public static final int INPUT_SLOTS_FIRST = 0;
        public static final int INPUT_SLOTS_SIZE = 12;
        public static final int CTRL_SLOTS_FIRST = 12;
        public static final int CTRL_SLOTS_SIZE = 3;
        public static final int SHUTTER_CLOSE_DELAY = 40;
        public static final int MAX_DROP_COUNT = 32;
        public static final int DROP_PERIOD_OFFSET = 10;
        public static final int DROPLOGIC_FILTER_ANDGATE = 1;
        public static final int DROPLOGIC_EXTERN_ANDGATE = 2;
        public static final int DROPLOGIC_SILENT_DROP = 4;
        public static final int DROPLOGIC_SILENT_OPEN = 8;
        public static final int DROPLOGIC_CONTINUOUS = 16;
        private int[] filter_matches_ = new int[3];
        private int open_timer_ = 0;
        private int drop_timer_ = 0;
        private boolean triggered_ = false;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int drop_speed_ = 10;
        private int drop_noise_ = 0;
        private int drop_xdev_ = 0;
        private int drop_ydev_ = 0;
        private int drop_count_ = 1;
        private int drop_logic_ = 2;
        private int drop_period_ = 0;
        private int drop_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        private final IItemHandler item_handler_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
        private static final int[] SIDED_INV_SLOTS = new int[12];

        public static void on_config(int cooldown_ticks) {
        }

        public BTileEntity() {
            this.stacks_ = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
            for (int i = 0; i < this.filter_matches_.length; ++i) {
                this.filter_matches_[i] = 0;
            }
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks_);
            while (this.stacks_.size() < 15) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.open_timer_ = nbt.func_74762_e("open_timer");
            this.drop_speed_ = nbt.func_74762_e("drop_speed");
            this.drop_noise_ = nbt.func_74762_e("drop_noise");
            this.drop_xdev_ = nbt.func_74762_e("drop_xdev");
            this.drop_ydev_ = nbt.func_74762_e("drop_ydev");
            this.drop_slot_index_ = nbt.func_74762_e("drop_slot_index");
            this.drop_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_count"), (int)1, (int)32);
            this.drop_logic_ = nbt.func_74762_e("drop_logic");
            this.drop_period_ = nbt.func_74762_e("drop_period");
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks_);
            nbt.func_74757_a("powered", this.block_power_signal_);
            nbt.func_74768_a("open_timer", this.open_timer_);
            nbt.func_74768_a("drop_speed", this.drop_speed_);
            nbt.func_74768_a("drop_noise", this.drop_noise_);
            nbt.func_74768_a("drop_xdev", this.drop_xdev_);
            nbt.func_74768_a("drop_ydev", this.drop_ydev_);
            nbt.func_74768_a("drop_slot_index", this.drop_slot_index_);
            nbt.func_74768_a("drop_count", this.drop_count_);
            nbt.func_74768_a("drop_logic", this.drop_logic_);
            nbt.func_74768_a("drop_period", this.drop_period_);
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 12;
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorDropper);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.drop_speed_;
                }
                case 1: {
                    return this.drop_xdev_;
                }
                case 2: {
                    return this.drop_ydev_;
                }
                case 3: {
                    return this.drop_noise_;
                }
                case 4: {
                    return this.drop_count_;
                }
                case 5: {
                    return this.drop_logic_;
                }
                case 6: {
                    return this.drop_period_;
                }
                case 9: {
                    return this.drop_timer_;
                }
                case 10: {
                    return this.open_timer_;
                }
                case 11: {
                    return this.block_power_signal_ ? 1 : 0;
                }
                case 12: {
                    return this.filter_matches_[0];
                }
                case 13: {
                    return this.filter_matches_[1];
                }
                case 14: {
                    return this.filter_matches_[2];
                }
                case 15: {
                    return this.drop_slot_index_;
                }
            }
            return 0;
        }

        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.drop_speed_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                    return;
                }
                case 1: {
                    this.drop_xdev_ = MathHelper.func_76125_a((int)value, (int)-100, (int)100);
                    return;
                }
                case 2: {
                    this.drop_ydev_ = MathHelper.func_76125_a((int)value, (int)-100, (int)100);
                    return;
                }
                case 3: {
                    this.drop_noise_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                    return;
                }
                case 4: {
                    this.drop_count_ = MathHelper.func_76125_a((int)value, (int)1, (int)32);
                    return;
                }
                case 5: {
                    this.drop_logic_ = value;
                    return;
                }
                case 6: {
                    this.drop_period_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                    return;
                }
                case 9: {
                    this.drop_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                    return;
                }
                case 10: {
                    this.open_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                    return;
                }
                case 11: {
                    this.block_power_signal_ = value != 0;
                    return;
                }
                case 12: {
                    this.filter_matches_[0] = value & 3;
                    return;
                }
                case 13: {
                    this.filter_matches_[1] = value & 3;
                    return;
                }
                case 14: {
                    this.filter_matches_[2] = value & 3;
                    return;
                }
                case 15: {
                    this.drop_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)11);
                    return;
                }
            }
        }

        public int func_174890_g() {
            return 16;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return false;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.item_handler_;
            }
            return (T)super.getCapability(capability, facing);
        }

        @Override
        public void onServerPacketReceived(NBTTagCompound nbt) {
        }

        @Override
        public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
            if (nbt.func_74764_b("drop_speed")) {
                this.drop_speed_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_speed"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("drop_xdev")) {
                this.drop_xdev_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_xdev"), (int)-100, (int)100);
            }
            if (nbt.func_74764_b("drop_ydev")) {
                this.drop_ydev_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_ydev"), (int)-100, (int)100);
            }
            if (nbt.func_74764_b("drop_count")) {
                this.drop_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_count"), (int)1, (int)32);
            }
            if (nbt.func_74764_b("drop_period")) {
                this.drop_period_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_period"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("drop_logic")) {
                this.drop_logic_ = nbt.func_74762_e("drop_logic");
            }
            if (nbt.func_74764_b("manual_rstrigger") && nbt.func_74762_e("manual_rstrigger") != 0) {
                this.block_power_signal_ = true;
                this.block_power_updated_ = true;
                this.tick_timer_ = 1;
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                this.tick_timer_ = 1;
                this.triggered_ = true;
            }
            this.func_70296_d();
        }

        private static void drop(World world, BlockPos pos, EnumFacing facing, ItemStack stack, int speed_percent, int xdeviation, int ydeviation, int noise_percent) {
            double ofs = facing == EnumFacing.DOWN ? 0.8 : 0.7;
            Vec3d v0 = new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5 + ofs * v0.field_72450_a, (double)pos.func_177956_o() + 0.5 + ofs * v0.field_72448_b, (double)pos.func_177952_p() + 0.5 + ofs * v0.field_72449_c, stack);
            if (xdeviation != 0 || ydeviation != 0) {
                double vdx = 0.01 * (double)MathHelper.func_76125_a((int)xdeviation, (int)-100, (int)100);
                double vdy = 0.01 * (double)MathHelper.func_76125_a((int)ydeviation, (int)-100, (int)100);
                switch (facing) {
                    case DOWN: {
                        v0 = v0.func_72441_c(vdx, 0.0, -vdy);
                        break;
                    }
                    case NORTH: {
                        v0 = v0.func_72441_c(vdx, vdy, 0.0);
                        break;
                    }
                    case SOUTH: {
                        v0 = v0.func_72441_c(-vdx, vdy, 0.0);
                        break;
                    }
                    case EAST: {
                        v0 = v0.func_72441_c(0.0, vdy, vdx);
                        break;
                    }
                    case WEST: {
                        v0 = v0.func_72441_c(0.0, vdy, -vdx);
                        break;
                    }
                    case UP: {
                        v0 = v0.func_72441_c(vdx, 0.0, vdy);
                    }
                }
            }
            if (noise_percent > 0) {
                v0 = v0.func_72441_c((world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent, (world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent, (world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent);
            }
            if (speed_percent < 5) {
                speed_percent = 5;
            }
            double speed = 0.01 * (double)speed_percent;
            if (noise_percent > 0) {
                speed += (world.field_73012_v.nextDouble() - 0.5) * 1.0E-4 * (double)noise_percent;
            }
            v0 = v0.func_72432_b().func_186678_a(speed);
            ei.field_70159_w = v0.field_72450_a;
            ei.field_70181_x = v0.field_72448_b;
            ei.field_70179_y = v0.field_72449_c;
            world.func_72838_d((Entity)ei);
        }

        @Nullable
        IBlockState update_blockstate() {
            boolean open;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorDropper)) {
                return null;
            }
            boolean bl = open = this.open_timer_ > 0;
            if ((Boolean)state.func_177229_b((IProperty)OPEN) != open) {
                state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 18);
                if ((this.drop_logic_ & 8) == 0) {
                    if (open) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 0.08f, 3.0f);
                    } else {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 0.08f, 3.0f);
                    }
                }
            }
            return state;
        }

        private static int next_slot(int i) {
            return i < 11 ? i + 1 : 0;
        }

        public void func_73660_a() {
            IBlockState state;
            boolean tr;
            boolean filter_trigger;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.open_timer_ < 0) {
                this.open_timer_ = 0;
            }
            if (this.drop_timer_ > 0 && --this.drop_timer_ == 0) {
                this.func_70296_d();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 32;
            if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockDecorDropper)) {
                return;
            }
            boolean dirty = this.block_power_updated_;
            boolean continuous_mode = (this.drop_logic_ & 0x10) != 0;
            boolean redstone_trigger = this.block_power_signal_ && (this.block_power_updated_ || continuous_mode);
            boolean filter_defined = false;
            boolean droppable_slot_found = false;
            for (int i = 0; i < 12; ++i) {
                if (((ItemStack)this.stacks_.get(i)).func_190916_E() < this.drop_count_) continue;
                droppable_slot_found = true;
                break;
            }
            int filter_nset = 0;
            int[] last_filter_matches_ = (int[])this.filter_matches_.clone();
            boolean slot_assigned = false;
            block1: for (int ci = 0; ci < 3; ++ci) {
                this.filter_matches_[ci] = 0;
                ItemStack cmp_stack = (ItemStack)this.stacks_.get(12 + ci);
                if (cmp_stack.func_190926_b()) continue;
                this.filter_matches_[ci] = 1;
                int cmp_stack_count = cmp_stack.func_190916_E();
                int inventory_item_count = 0;
                int slot = this.drop_slot_index_;
                for (int i = 0; i < 12; ++i) {
                    ItemStack inp_stack = (ItemStack)this.stacks_.get(slot);
                    if (!inp_stack.func_77969_a(cmp_stack)) {
                        slot = BTileEntity.next_slot(slot);
                        continue;
                    }
                    if ((inventory_item_count += inp_stack.func_190916_E()) < cmp_stack_count) {
                        slot = BTileEntity.next_slot(slot);
                        continue;
                    }
                    this.filter_matches_[ci] = 2;
                    continue block1;
                }
            }
            int nmatched = 0;
            for (int i = 0; i < this.filter_matches_.length; ++i) {
                if (this.filter_matches_[i] > 0) {
                    ++filter_nset;
                }
                if (this.filter_matches_[i] > 1) {
                    ++nmatched;
                }
                if (this.filter_matches_[i] == last_filter_matches_[i]) continue;
                dirty = true;
            }
            filter_defined = filter_nset > 0;
            boolean bl = filter_trigger = filter_nset > 0 && nmatched > 0;
            if ((this.drop_logic_ & 1) != 0 && nmatched != filter_nset) {
                filter_trigger = false;
            }
            boolean trigger = filter_defined ? ((this.drop_logic_ & 2) != 0 ? filter_trigger && redstone_trigger : filter_trigger || redstone_trigger) : redstone_trigger;
            if (this.triggered_) {
                this.triggered_ = false;
                trigger = true;
            }
            if (!droppable_slot_found) {
                if (this.open_timer_ > 10) {
                    this.open_timer_ = 10;
                }
            } else if (trigger || filter_trigger || redstone_trigger) {
                this.open_timer_ = 40;
            }
            this.block_power_updated_ = this.block_power_signal_ != (tr = this.field_145850_b.func_175640_z(this.field_174879_c));
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if ((state = this.update_blockstate()) == null) {
                this.block_power_signal_ = false;
                return;
            }
            if (trigger && this.drop_timer_ <= 0) {
                int i;
                ItemStack[] drop_stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                if (!filter_trigger) {
                    for (int i2 = 0; i2 < 12; ++i2) {
                        if (this.drop_slot_index_ >= 12) {
                            this.drop_slot_index_ = 0;
                        }
                        int ic = this.drop_slot_index_;
                        this.drop_slot_index_ = BTileEntity.next_slot(this.drop_slot_index_);
                        ItemStack ds = (ItemStack)this.stacks_.get(ic);
                        if (ds.func_190926_b() || ds.func_190916_E() < this.drop_count_) continue;
                        drop_stacks[0] = ds.func_77979_a(this.drop_count_);
                        this.stacks_.set(ic, (Object)ds);
                        break;
                    }
                } else {
                    for (int fi = 0; fi < this.filter_matches_.length; ++fi) {
                        if (this.filter_matches_[fi] <= 1) continue;
                        drop_stacks[fi] = ((ItemStack)this.stacks_.get(12 + fi)).func_77946_l();
                        int ntoremove = drop_stacks[fi].func_190916_E();
                        for (int i3 = 11; i3 >= 0 && ntoremove > 0; --i3) {
                            ItemStack stack = (ItemStack)this.stacks_.get(i3);
                            if (!stack.func_77969_a(drop_stacks[fi])) continue;
                            if (stack.func_190916_E() <= ntoremove) {
                                ntoremove -= stack.func_190916_E();
                                this.stacks_.set(i3, (Object)ItemStack.field_190927_a);
                                continue;
                            }
                            stack.func_190918_g(ntoremove);
                            ntoremove = 0;
                            this.stacks_.set(i3, (Object)stack);
                        }
                        if (ntoremove <= 0) continue;
                        drop_stacks[fi].func_190918_g(ntoremove);
                    }
                }
                boolean dropped = false;
                for (i = 0; i < drop_stacks.length; ++i) {
                    if (drop_stacks[i].func_190926_b()) continue;
                    dirty = true;
                    BTileEntity.drop(this.field_145850_b, this.field_174879_c, (EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING), drop_stacks[i], this.drop_speed_, this.drop_xdev_, this.drop_ydev_, this.drop_noise_);
                    dropped = true;
                }
                if (dropped) {
                    this.drop_timer_ = 10 + this.drop_period_ * 2;
                }
                if (dropped && (this.drop_logic_ & 4) == 0) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187554_ai, SoundCategory.BLOCKS, 0.1f, 4.0f);
                }
                for (i = 0; i < 12 && ((ItemStack)this.stacks_.get(this.drop_slot_index_)).func_190926_b(); ++i) {
                    this.drop_slot_index_ = BTileEntity.next_slot(this.drop_slot_index_);
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }

        static {
            for (int i = 0; i < 12; ++i) {
                BTileEntity.SIDED_INV_SLOTS[i] = i + 0;
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 15;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int[] fields_ = new int[16];

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            int x;
            int y;
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            int i = -1;
            for (y = 0; y < 2; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 10 + x * 18;
                    int ypos = 6 + y * 17;
                    this.func_75146_a(new Slot((IInventory)te, ++i, xpos, ypos));
                }
            }
            this.func_75146_a(new Slot((IInventory)te, ++i, 19, 48));
            this.func_75146_a(new Slot((IInventory)te, ++i, 55, 48));
            this.func_75146_a(new Slot((IInventory)te, ++i, 91, 48));
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int il = 0; il < this.field_75149_d.size(); ++il) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(il);
                for (int k = 0; k < 16; ++k) {
                    int f = this.te.func_174887_a_(k);
                    if (this.fields_[k] == f) continue;
                    this.fields_[k] = f;
                    lis.func_71112_a((Container)this, k, f);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_75137_b(int id, int value) {
            if (id < 0 || id >= this.fields_.length) {
                return;
            }
            this.fields_[id] = value;
            this.te.func_174885_b(id, value);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorDropper && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 15) {
                if (!this.func_75135_a(slot_stack, 15, 51, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 15 && index <= 51) {
                if (!this.func_75135_a(slot_stack, 0, 12, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 16) {
                return;
            }
            int mx = mouseX - this.getGuiLeft();
            int my = mouseY - this.getGuiTop();
            if (!this.func_146978_c(114, 1, 61, 79, mouseX, mouseY)) {
                return;
            }
            if (this.func_146978_c(130, 10, 12, 25, mouseX, mouseY)) {
                int force_percent = 100 - MathHelper.func_76125_a((int)((my - 10) * 100 / 25), (int)0, (int)100);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_speed", force_percent);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(145, 10, 25, 25, mouseX, mouseY)) {
                int xdev = MathHelper.func_76125_a((int)((int)Math.round((double)((mx - 157) * 100) / 12.0)), (int)-100, (int)100);
                int ydev = MathHelper.func_76125_a((int)(-((int)Math.round((double)((my - 22) * 100) / 12.0))), (int)-100, (int)100);
                if (Math.abs(xdev) < 9) {
                    xdev = 0;
                }
                if (Math.abs(ydev) < 9) {
                    ydev = 0;
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_xdev", xdev);
                nbt.func_74768_a("drop_ydev", ydev);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(129, 40, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 135;
                ndrop = ndrop < -1 ? container.fields_[4] - 1 : (ndrop >= 34 ? container.fields_[4] + 1 : MathHelper.func_76125_a((int)(1 + ndrop), (int)1, (int)32));
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_count", ndrop);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(129, 50, 44, 10, mouseX, mouseY)) {
                int period = mx - 135;
                period = period < -1 ? container.fields_[6] - 3 : (period >= 34 ? container.fields_[6] + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = MathHelper.func_76125_a((int)period, (int)0, (int)100);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_period", period);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(114, 51, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("manual_rstrigger", 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(162, 66, 7, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_logic", container.fields_[5] ^ 0x10);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(132, 66, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_logic", container.fields_[5] ^ 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(148, 66, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("drop_logic", container.fields_[5] ^ 2);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_dropper_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.func_73729_b(x0, y0, 0, 0, w, h);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 16) {
                return;
            }
            int drop_slot_index = container.fields_[15];
            if (drop_slot_index < 0 || drop_slot_index >= 16) {
                drop_slot_index = 0;
            }
            int x = x0 + 9 + drop_slot_index % 6 * 18;
            int y = y0 + 5 + drop_slot_index / 6 * 17;
            this.func_73729_b(x, y, 180, 45, 18, 18);
            for (int i = 0; i < 3; ++i) {
                int xt = 180 + 6 * container.fields_[12 + i];
                int yt = 38;
                int x2 = x0 + 31 + i * 36;
                int y2 = y0 + 65;
                this.func_73729_b(x2, y2, xt, yt, 6, 6);
            }
            int hy = 2 + (100 - container.fields_[0]) * 21 / 100;
            x = x0 + 135;
            y = y0 + 12;
            int xt = 181;
            int yt = 4 + (23 - hy);
            this.func_73729_b(x, y, xt, yt, 3, hy);
            int x3 = x0 + 157 - 3 + container.fields_[1] * 12 / 100;
            int y3 = y0 + 22 - 3 - container.fields_[2] * 12 / 100;
            this.func_73729_b(x3, y3, 180, 30, 7, 7);
            x3 = x0 + 134 - 2 + container.fields_[4];
            y3 = y0 + 45;
            this.func_73729_b(x3, y3, 190, 31, 5, 5);
            int px = (int)Math.round(33.0 * (double)container.fields_[6] / 100.0 + 1.0);
            x = x0 + 134 - 2 + MathHelper.func_76125_a((int)px, (int)0, (int)33);
            y = y0 + 56;
            this.func_73729_b(x, y, 190, 31, 5, 5);
            if (container.fields_[11] != 0) {
                this.func_73729_b(x0 + 114, y0 + 51, 189, 18, 9, 9);
            }
            int filter_gate_offset = (container.fields_[5] & 1) != 0 ? 11 : 0;
            int extern_gate_offset = (container.fields_[5] & 2) != 0 ? 11 : 0;
            int pulse_mode_offset = (container.fields_[5] & 0x10) != 0 ? 10 : 0;
            this.func_73729_b(x0 + 132, y0 + 66, 179 + filter_gate_offset, 66, 9, 9);
            this.func_73729_b(x0 + 148, y0 + 66, 179 + extern_gate_offset, 66, 9, 9);
            this.func_73729_b(x0 + 162, y0 + 66, 200 + pulse_mode_offset, 66, 9, 9);
            if (container.fields_[9] > 10 && System.currentTimeMillis() % 1000L < 500L) {
                this.func_73729_b(x0 + 149, y0 + 51, 201, 39, 3, 3);
            }
        }
    }
}

