/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.blocks.BlockDecorStraightPole;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorHorizontalSupport
extends BlockDecor {
    public static final PropertyBool EASTWEST = PropertyBool.func_177716_a((String)"eastwest");
    public static final PropertyBool LEFTBEAM = PropertyBool.func_177716_a((String)"leftbeam");
    public static final PropertyBool RIGHTBEAM = PropertyBool.func_177716_a((String)"rightbeam");
    public static final PropertyInteger DOWNCONNECT = PropertyInteger.func_177719_a((String)"downconnect", (int)0, (int)2);
    protected final ArrayList<AxisAlignedBB> AABBs;

    public BlockDecorHorizontalSupport(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config | 2L, material, hardness, resistance, sound);
        this.AABBs = new ArrayList<AxisAlignedBB>(Arrays.asList(ModAuxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), EnumFacing.NORTH, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), EnumFacing.WEST, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.NORTH, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.WEST, true)));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.AABBs.get((Boolean)state.func_177229_b((IProperty)EASTWEST) != false ? 3 : 2).func_186670_a(pos);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABBs.get((Boolean)state.func_177229_b((IProperty)EASTWEST) != false ? 1 : 0);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EASTWEST) != false ? 1 : 0;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean ew = (Boolean)state.func_177229_b((IProperty)EASTWEST);
        IBlockState rstate = world.func_180495_p(!ew ? pos.func_177974_f() : pos.func_177968_d());
        IBlockState lstate = world.func_180495_p(!ew ? pos.func_177976_e() : pos.func_177978_c());
        IBlockState dstate = world.func_180495_p(pos.func_177977_b());
        int down_connector = 0;
        if (dstate.func_177230_c() instanceof BlockDecorStraightPole) {
            EnumFacing dfacing = (EnumFacing)dstate.func_177229_b((IProperty)BlockDecorStraightPole.FACING);
            BlockDecorStraightPole pole = (BlockDecorStraightPole)dstate.func_177230_c();
            if (dfacing.func_176740_k() == EnumFacing.Axis.Y) {
                if (pole == ModContent.THICK_STEEL_POLE || pole == ModContent.THICK_STEEL_POLE_HEAD && dfacing == EnumFacing.UP) {
                    down_connector = 2;
                } else if (pole == ModContent.THIN_STEEL_POLE || pole == ModContent.THIN_STEEL_POLE_HEAD && dfacing == EnumFacing.UP) {
                    down_connector = 1;
                }
            }
        }
        return state.func_177226_a((IProperty)RIGHTBEAM, (Comparable)Boolean.valueOf(rstate.func_177230_c() == this && (Boolean)rstate.func_177229_b((IProperty)EASTWEST) != ew)).func_177226_a((IProperty)LEFTBEAM, (Comparable)Boolean.valueOf(lstate.func_177230_c() == this && (Boolean)lstate.func_177229_b((IProperty)EASTWEST) != ew)).func_177226_a((IProperty)DOWNCONNECT, (Comparable)Integer.valueOf(down_connector));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EASTWEST, RIGHTBEAM, LEFTBEAM, DOWNCONNECT});
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_180 ? state : state.func_177226_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)EASTWEST) == false));
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176221_a(this.func_176223_P().func_177226_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X)), (IBlockAccess)world, pos);
    }
}

