/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ItemHandling {
    public static IItemHandler itemhandler(World world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (side != null && te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, side);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static ItemStack insert(IItemHandler inventory, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack insert(TileEntity te, @Nullable EnumFacing side, ItemStack stack, boolean simulate) {
        if (te == null) {
            return stack;
        }
        IItemHandler hnd = null;
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        } else if (side != null && te instanceof ISidedInventory) {
            hnd = new SidedInvWrapper((ISidedInventory)te, side);
        } else if (te instanceof IInventory) {
            hnd = new InvWrapper((IInventory)te);
        }
        return hnd == null ? stack : ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack extract(IItemHandler inventory, @Nullable ItemStack match, int amount, boolean simulate) {
        if (inventory == null || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int max = inventory.getSlots();
        ItemStack out_stack = ItemStack.field_190927_a;
        for (int i = 0; i < max; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (out_stack.func_190926_b()) {
                if (match != null && !stack.func_77969_a(match)) continue;
                out_stack = inventory.extractItem(i, amount, simulate);
            } else if (stack.func_77969_a(out_stack)) {
                ItemStack es = inventory.extractItem(i, amount - out_stack.func_190916_E(), simulate);
                out_stack.func_190917_f(es.func_190916_E());
            }
            if (out_stack.func_190916_E() >= amount) break;
        }
        return out_stack;
    }
}

