/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class VectorTools {
    public static RayTraceResult getLookingAt(EntityPlayer player, ItemStack tool) {
        return VectorTools.getLookingAt(player, GadgetGeneric.shouldRayTraceFluid(tool));
    }

    public static RayTraceResult getLookingAt(EntityPlayer player, boolean rayTraceFluid) {
        World world = player.field_70170_p;
        Vec3d look = player.func_70040_Z();
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d end = new Vec3d(player.field_70165_t + look.field_72450_a * SyncedConfig.rayTraceRange, player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b * SyncedConfig.rayTraceRange, player.field_70161_v + look.field_72449_c * SyncedConfig.rayTraceRange);
        return world.func_147447_a(start, end, rayTraceFluid, false, false);
    }

    @Nullable
    public static BlockPos getPosLookingAt(EntityPlayer player, ItemStack tool) {
        RayTraceResult lookingAt = VectorTools.getLookingAt(player, tool);
        if (lookingAt == null) {
            return null;
        }
        return lookingAt.func_178782_a();
    }

    public static int getAxisValue(BlockPos pos, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        throw new IllegalArgumentException("Trying to find the value an imaginary axis of a BlockPos");
    }

    public static int getAxisValue(int x, int y, int z, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        throw new IllegalArgumentException("Trying to find the value an imaginary axis of a set of 3 values");
    }

    public static BlockPos perpendicularSurfaceOffset(BlockPos pos, EnumFacing intersector, int i, int j) {
        return VectorTools.perpendicularSurfaceOffset(pos, intersector.func_176740_k(), i, j);
    }

    public static BlockPos perpendicularSurfaceOffset(BlockPos pos, EnumFacing.Axis intersector, int i, int j) {
        switch (intersector) {
            case X: {
                return pos.func_177982_a(0, i, j);
            }
            case Y: {
                return pos.func_177982_a(i, 0, j);
            }
            case Z: {
                return pos.func_177982_a(i, j, 0);
            }
        }
        throw new IllegalArgumentException("Unknown facing " + intersector);
    }
}

