/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.plugins.vanilla.block.BlockMixin;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;

public class AxisAlignedBBDeserializer
implements JsonDeserializer<AxisAlignedBB> {
    @Nullable
    public AxisAlignedBB deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive primitive;
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            if (object.has("from") && object.has("to")) {
                return this.fromTo(object, context);
            }
            if (object.has("cube")) {
                return this.cube(object, context);
            }
        } else if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
            String string = primitive.getAsString();
            if (string.equals("empty") || string.equals("null")) {
                return null;
            }
            if (string.equals("default")) {
                return BlockMixin.DEFAULT_AABB_MARKER;
            }
        }
        throw new JsonParseException("Invalid bounding box: " + json);
    }

    private AxisAlignedBB cube(JsonObject object, JsonDeserializationContext context) {
        float size = object.get("cube").getAsFloat();
        float[] offset = this.getOffset(object, context);
        return new AxisAlignedBB((double)offset[0], (double)offset[1], (double)offset[2], (double)(size + offset[0]), (double)(size + offset[1]), (double)(size + offset[2]));
    }

    private AxisAlignedBB fromTo(JsonObject object, JsonDeserializationContext context) throws JsonParseException {
        float[] from = (float[])context.deserialize(object.get("from"), float[].class);
        float[] to = (float[])context.deserialize(object.get("to"), float[].class);
        if (from.length != 3) {
            throw new JsonParseException("from has " + from.length + " elements, expected 3");
        }
        if (to.length != 3) {
            throw new JsonParseException("to has " + to.length + " elements, expected 3");
        }
        float[] offset = this.getOffset(object, context);
        float minX = Math.min(from[0], to[0]) + offset[0];
        float minY = Math.min(from[1], to[1]) + offset[1];
        float minZ = Math.min(from[2], to[2]) + offset[2];
        float maxX = Math.max(from[0], to[0]) + offset[0];
        float maxY = Math.max(from[1], to[1]) + offset[1];
        float maxZ = Math.max(from[2], to[2]) + offset[2];
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Nonnull
    private float[] getOffset(JsonObject object, JsonDeserializationContext context) {
        if (object.has("offset")) {
            float[] offset = (float[])context.deserialize(object.get("offset"), float[].class);
            if (offset.length != 3) {
                throw new JsonParseException("offset has " + offset.length + " elements, expected 3");
            }
            return offset;
        }
        return new float[3];
    }
}

