/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import cubex2.cs4.api.WrappedFluidStack;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutputImpl;
import cubex2.cs4.plugins.vanilla.crafting.MachineResult;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class MachineRecipeOutputDeserializer
implements JsonDeserializer<MachineRecipeOutput> {
    public MachineRecipeOutput deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return this.fromString(json.getAsJsonPrimitive(), context);
        }
        if (json.isJsonObject()) {
            return this.fromObject(json.getAsJsonObject(), context);
        }
        throw new JsonParseException("Invalid machine recipe output: " + json.toString());
    }

    private MachineRecipeOutput fromString(JsonPrimitive s, JsonDeserializationContext context) {
        List<Object> outputItems = Collections.singletonList(context.deserialize((JsonElement)s, MachineResult.class));
        List<WrappedFluidStack> outputFluids = Collections.emptyList();
        int weight = 1;
        return new MachineRecipeOutputImpl(outputItems, outputFluids, weight);
    }

    private MachineRecipeOutput fromObject(JsonObject jsonObject, JsonDeserializationContext context) {
        List outputItems = Collections.emptyList();
        List outputFluids = Collections.emptyList();
        int weight = 1;
        if (jsonObject.has("items")) {
            outputItems = (List)context.deserialize(jsonObject.get("items"), new TypeToken<List<MachineResult>>(){}.getType());
        }
        if (jsonObject.has("fluids")) {
            outputFluids = (List)context.deserialize(jsonObject.get("fluids"), new TypeToken<List<WrappedFluidStack>>(){}.getType());
        }
        if (jsonObject.has("weight")) {
            weight = (Integer)context.deserialize(jsonObject.get("weight"), Integer.TYPE);
        }
        return new MachineRecipeOutputImpl(outputItems, outputFluids, weight);
    }
}

