/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.BOPGeneratorBase;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.futuremc.compat.biomesoplenty.BiomesOPlentyCompat;

public abstract class GeneratorTreeBaseA
extends BOPGeneratorBase {
    protected IBlockPosQuery placeOn;
    protected IBlockPosQuery replace;
    protected IBlockState log;
    protected IBlockState leaves;
    protected IBlockState vine;
    protected IBlockState hanging;
    protected IBlockState trunkFruit;
    protected IBlockState altLeaves;
    protected int minHeight;
    protected int maxHeight;
    protected IProperty logAxisProperty;
    protected GeneratorUtils.ScatterYMethod scatterYMethod;
    private boolean _fmc_has_placed_beehive;

    protected GeneratorTreeBaseA(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk);
        this.placeOn = placeOn;
        this.replace = replace;
        this.log = log;
        this.leaves = leaves;
        this.vine = vine;
        this.hanging = hanging;
        this.trunkFruit = trunkFruit;
        this.altLeaves = altLeaves;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.logAxisProperty = GeneratorUtils.getAxisProperty((IBlockState)log);
        this.scatterYMethod = scatterYMethod;
    }

    public BlockPos getScatterY(World world, Random random, int x, int z) {
        this._fmc_has_placed_beehive = false;
        return this.scatterYMethod.getBlockPos(world, random, x, z);
    }

    public boolean setLeaves(World world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.leaves, 2);
            return true;
        }
        return false;
    }

    public boolean setLog(World world, BlockPos pos) {
        return this.setLog(world, pos, null);
    }

    public boolean setLog(World world, BlockPos pos, EnumFacing.Axis axis) {
        IBlockState directedLog;
        IBlockState iBlockState = directedLog = axis != null && this.logAxisProperty != null ? this.log.func_177226_a(this.logAxisProperty, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)axis)) : this.log;
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, directedLog, 2);
            if (!this._fmc_has_placed_beehive) {
                this._fmc_has_placed_beehive = BiomesOPlentyCompat.placeBeehive(world, pos);
            }
            return true;
        }
        return false;
    }

    public boolean setVine(World world, Random rand, BlockPos pos, EnumFacing side, int length) {
        if (this.vine == null) {
            return false;
        }
        IBlockState vineState = this.vine.func_177230_c() instanceof BlockVine ? this.vine.func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(side == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(side == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(side == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(side == EnumFacing.WEST)) : this.vine;
        boolean setOne = false;
        while (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && length > 0 && rand.nextInt(12) > 0) {
            world.func_180501_a(pos, vineState, 2);
            setOne = true;
            --length;
            pos = pos.func_177977_b();
        }
        return setOne;
    }

    public boolean setHanging(World world, BlockPos pos) {
        if (this.hanging == null) {
            return false;
        }
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.hanging, 2);
        }
        return false;
    }

    public boolean setTrunkFruit(World world, BlockPos pos) {
        if (this.trunkFruit == null) {
            return false;
        }
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.trunkFruit, 2);
        }
        return false;
    }

    public boolean setAltLeaves(World world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.altLeaves, 2);
            return true;
        }
        return false;
    }

    protected static abstract class InnerBuilder<T extends GeneratorTreeBase.InnerBuilder<T, G>, G extends GeneratorTreeBase>
    extends BOPGeneratorBase.InnerBuilder<T, G> {
        protected IBlockPosQuery placeOn;
        protected IBlockPosQuery replace;
        protected IBlockState log;
        protected IBlockState leaves;
        protected IBlockState vine;
        protected IBlockState hanging;
        protected IBlockState trunkFruit;
        protected IBlockState altLeaves;
        protected int minHeight;
        protected int maxHeight;
        protected boolean updateNeighbours;
        protected GeneratorUtils.ScatterYMethod scatterYMethod;

        protected InnerBuilder() {
        }

        public T placeOn(IBlockPosQuery a) {
            this.placeOn = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T placeOn(String a) throws BlockQuery.BlockQueryParseException {
            this.placeOn = BlockQuery.parseQueryString((String)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T placeOn(Block a) {
            this.placeOn = new BlockQuery.BlockQueryBlock(new Block[]{a});
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T placeOn(IBlockState a) {
            this.placeOn = new BlockQuery.BlockQueryState(new IBlockState[]{a});
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T placeOn(Material ... a) {
            this.placeOn = new BlockQuery.BlockQueryMaterial(a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T replace(IBlockPosQuery a) {
            this.replace = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T replace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString((String)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T replace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(new Block[]{a});
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T replace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(new IBlockState[]{a});
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T replace(Material ... a) {
            this.replace = new BlockQuery.BlockQueryMaterial(a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T log(IBlockState a) {
            this.log = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T log(BOPWoods a) {
            this.log = BlockBOPLog.paging.getVariantState((Enum)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T log(BlockPlanks.EnumType a) {
            this.log = a.func_176839_a() < 4 ? Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)a) : Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T leaves(IBlockState a) {
            this.leaves = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T leaves(BOPTrees a) {
            this.leaves = BlockBOPLeaves.paging.getVariantState((Enum)a).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T leaves(BlockPlanks.EnumType a) {
            this.leaves = a.func_176839_a() < 4 ? Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)a) : Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T vine(IBlockState a) {
            this.vine = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T hanging(IBlockState a) {
            this.hanging = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T trunkFruit(IBlockState a) {
            this.trunkFruit = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T altLeaves(IBlockState a) {
            this.altLeaves = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T altLeaves(BOPTrees a) {
            this.altLeaves = BlockBOPLeaves.paging.getVariantState((Enum)a).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T altLeaves(BlockPlanks.EnumType a) {
            this.altLeaves = a.func_176839_a() < 4 ? Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)a) : Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)a);
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T updateNeighbours(boolean a) {
            this.updateNeighbours = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }

        public T scatterYMethod(GeneratorUtils.ScatterYMethod a) {
            this.scatterYMethod = a;
            return (T)((GeneratorTreeBase.InnerBuilder)this.self());
        }
    }
}

