/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import vswe.stevescarts.blocks.BlockDetector;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.OperatorObject;

public enum DetectorType implements IStringSerializable
{
    NORMAL(0, true, false, true),
    UNIT(1, false, false, false),
    STATION(2, true, true, false){

        @Override
        public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
            cart.releaseCart();
        }
    }
    ,
    JUNCTION(3, true, false, false){

        @Override
        public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
            this.update(detector, true);
        }

        @Override
        public void deactivate(TileEntityDetector detector) {
            this.update(detector, false);
        }

        private void update(TileEntityDetector detector, boolean flag) {
            BlockPos posUp = detector.func_174877_v().func_177984_a();
            IBlockState stateUp = detector.func_145831_w().func_180495_p(posUp);
            if (stateUp.func_177230_c() == ModBlocks.ADVANCED_DETECTOR.getBlock()) {
                ((BlockRailAdvDetector)ModBlocks.ADVANCED_DETECTOR.getBlock()).refreshState(detector.func_145831_w(), posUp, stateUp, flag);
            }
        }
    }
    ,
    REDSTONE(4, false, false, false){

        @Override
        public void initOperators(HashMap<Byte, OperatorObject> operators) {
            super.initOperators(operators);
            new OperatorObject.OperatorObjectRedstone(operators, 11, Localization.GUI.DETECTOR.REDSTONE, 0, 0, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 12, Localization.GUI.DETECTOR.REDSTONE_TOP, 0, 1, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 13, Localization.GUI.DETECTOR.REDSTONE_BOT, 0, -1, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 14, Localization.GUI.DETECTOR.REDSTONE_NORTH, 0, 0, -1);
            new OperatorObject.OperatorObjectRedstone(operators, 15, Localization.GUI.DETECTOR.REDSTONE_WEST, -1, 0, 0);
            new OperatorObject.OperatorObjectRedstone(operators, 16, Localization.GUI.DETECTOR.REDSTONE_SOUTH, 0, 0, 1);
            new OperatorObject.OperatorObjectRedstone(operators, 17, Localization.GUI.DETECTOR.REDSTONE_EAST, 1, 0, 0);
        }
    };

    private int meta;
    private boolean acceptCart;
    private boolean stopCart;
    private boolean emitRedstone;
    private HashMap<Byte, OperatorObject> operators;

    private DetectorType(int meta, boolean acceptCart, boolean stopCart, boolean emitRedstone) {
        this.meta = meta;
        this.acceptCart = acceptCart;
        this.stopCart = stopCart;
        this.emitRedstone = emitRedstone;
    }

    public int getMeta() {
        return this.meta;
    }

    public String getTranslatedName() {
        StringBuilder builder = new StringBuilder();
        return I18n.func_135052_a((String)builder.append("item.SC2:BlockDetector").append(this.meta).append(".name").toString(), (Object[])new Object[0]);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean canInteractWithCart() {
        return this.acceptCart;
    }

    public boolean shouldStopCart() {
        return this.stopCart;
    }

    public boolean shouldEmitRedstone() {
        return this.emitRedstone;
    }

    public void activate(TileEntityDetector detector, EntityMinecartModular cart) {
    }

    public void deactivate(TileEntityDetector detector) {
    }

    public static DetectorType getTypeFromSate(IBlockState state) {
        return (DetectorType)((Object)state.func_177229_b(BlockDetector.SATE));
    }

    public static DetectorType getTypeFromint(int meta) {
        return DetectorType.values()[meta];
    }

    public void initOperators(HashMap<Byte, OperatorObject> operators) {
        this.operators = operators;
    }

    public HashMap<Byte, OperatorObject> getOperators() {
        return this.operators;
    }
}

