/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.IFastAddonRenderer;
import buildcraft.core.marker.volume.ISingleAddon;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Addon {
    public VolumeBox volumeBox;

    @SideOnly(value=Side.CLIENT)
    public abstract IFastAddonRenderer<? extends Addon> getRenderer();

    public EnumAddonSlot getSlot() {
        return (EnumAddonSlot)((Object)this.volumeBox.addons.entrySet().stream().filter(slotAddon -> slotAddon.getValue() == this).findFirst().orElseThrow(IllegalStateException::new).getKey());
    }

    public AxisAlignedBB getBoundingBox() {
        return this.getSlot().getBoundingBox(this.volumeBox);
    }

    public boolean canBePlaceInto(VolumeBox volumeBox) {
        return !(this instanceof ISingleAddon) || !volumeBox.addons.values().stream().anyMatch(addon -> addon.getClass() == this.getClass());
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onVolumeBoxSizeChange() {
    }

    public void onPlayerRightClick(EntityPlayer player) {
    }

    public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public void postReadFromNbt() {
    }

    public abstract void toBytes(PacketBufferBC var1);

    public abstract void fromBytes(PacketBufferBC var1) throws IOException;
}

