/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public enum DetachedRenderer {
    INSTANCE;

    private final Map<RenderMatrixType, List<IDetachedRenderer>> renders = new EnumMap<RenderMatrixType, List<IDetachedRenderer>>(RenderMatrixType.class);

    private DetachedRenderer() {
        for (RenderMatrixType type : RenderMatrixType.values()) {
            this.renders.put(type, new ArrayList());
        }
    }

    public void addRenderer(RenderMatrixType type, IDetachedRenderer renderer) {
        this.renders.get(type).add(renderer);
    }

    public void renderWorldLastEvent(EntityPlayer player, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        for (RenderMatrixType type : RenderMatrixType.values()) {
            List<IDetachedRenderer> rendersForType = this.renders.get(type);
            if (rendersForType.isEmpty()) continue;
            type.glPre(player, partialTicks);
            for (IDetachedRenderer render : rendersForType) {
                render.render(player, partialTicks);
            }
            type.glPost();
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
    }

    public static void fromWorldOriginPre(EntityPlayer player, float partialTicks) {
        GL11.glPushMatrix();
        Vec3d diff = new Vec3d(0.0, 0.0, 0.0);
        diff = diff.func_178788_d(player.func_174824_e(partialTicks));
        diff = diff.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        GL11.glTranslated((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c);
    }

    public static void fromWorldOriginPost() {
        GL11.glPopMatrix();
    }

    @FunctionalInterface
    public static interface IDetachedRenderer {
        public void render(EntityPlayer var1, float var2);
    }

    @FunctionalInterface
    public static interface IGLPost {
        public void glPost();
    }

    @FunctionalInterface
    public static interface IGlPre {
        public void glPre(EntityPlayer var1, float var2);
    }

    public static enum RenderMatrixType implements IGlPre,
    IGLPost
    {
        FROM_PLAYER(null, null),
        FROM_WORLD_ORIGIN(DetachedRenderer::fromWorldOriginPre, DetachedRenderer::fromWorldOriginPost);

        public final IGlPre pre;
        public final IGLPost post;

        private RenderMatrixType(IGlPre pre, IGLPost post) {
            this.pre = pre;
            this.post = post;
        }

        @Override
        public void glPre(EntityPlayer clientPlayer, float partialTicks) {
            if (this.pre != null) {
                this.pre.glPre(clientPlayer, partialTicks);
            }
        }

        @Override
        public void glPost() {
            if (this.post != null) {
                this.post.glPost();
            }
        }
    }
}

