/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render;

import buildcraft.api.core.EnumPipePart;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.misc.ItemStackKey;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemRenderUtil {
    private static final LoadingCache<ItemStackKey, Integer> glListCache;
    private static final Random modelOffsetRandom;
    private static final EntityItem dummyEntityItem;
    private static final RenderEntityItem customItemRenderer;
    private static boolean inBatch;

    private static Integer makeItemGlList(ItemStackKey item) {
        int list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)list, (int)4864);
        ItemRenderUtil.renderItemImpl(0.0, 0.0, 0.0, item.baseStack);
        GL11.glEndList();
        return list;
    }

    private static void onStackRemove(RemovalNotification<ItemStackKey, Integer> notification) {
        Integer val = (Integer)notification.getValue();
        if (val != null) {
            GLAllocation.func_74523_b((int)val);
        }
    }

    private static void renderItemImpl(double x, double y, double z, ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.2, (double)0.0);
        GL11.glScaled((double)0.9, (double)0.9, (double)0.9);
        ItemRenderUtil.dummyEntityItem.field_70290_d = stack.func_77973_b() instanceof ItemBlock ? 0.0f : 0.7853982f;
        dummyEntityItem.func_92058_a(stack);
        customItemRenderer.func_76986_a(dummyEntityItem, x, y, z, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    public static void renderItemStack(double x, double y, double z, ItemStack stack, int lightc, EnumFacing dir, BufferBuilder bb) {
        ItemRenderUtil.renderItemStack(x, y, z, stack, stack.func_190916_E(), lightc, dir, bb);
    }

    public static void renderItemStack(double x, double y, double z, ItemStack stack, int stackCount, int lightc, EnumFacing dir, BufferBuilder bb) {
        if (stack.func_190926_b()) {
            return;
        }
        try {
            ItemRenderUtil.renderItemStackInternal(x, y, z, stack, stackCount, lightc, dir, bb);
        }
        catch (Throwable exception) {
            CrashReport report = CrashReport.func_85055_a((Throwable)exception, (String)"Rendering Item Stack");
            CrashReportCategory category = report.func_85058_a("Item being rendered");
            category.func_71507_a("Stack Count", (Object)stackCount);
            category.func_189529_a("Item Class", () -> "" + stack.func_77973_b().getClass());
            category.func_189529_a("Item ID", () -> "" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()));
            category.func_189529_a("Item Meta", () -> "" + stack.func_77960_j());
            category.func_189529_a("Item NBT", () -> "" + stack.func_77978_p());
            throw new ReportedException(report);
        }
    }

    private static void renderItemStackInternal(double x, double y, double z, ItemStack stack, int stackCount, int lightc, EnumFacing dir, BufferBuilder bb) {
        boolean requireGl;
        if (dir == null) {
            dir = EnumFacing.EAST;
        }
        dir = BCLibConfig.rotateTravelingItems.changeFacing(dir);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        model = model.func_188617_f().handleItemState(model, stack, null, null);
        boolean bl = requireGl = stack.func_77962_s() || model.func_188618_c();
        if (bb != null && !requireGl) {
            int itemModelCount = ItemRenderUtil.getStackModelCount(stackCount);
            if (itemModelCount > 1) {
                ItemRenderUtil.setupModelOffsetRandom(stack);
            }
            for (int i = 0; i < itemModelCount; ++i) {
                if (i == 0) {
                    bb.func_178969_c(x, y, z);
                } else {
                    float dx = (modelOffsetRandom.nextFloat() * 2.0f - 1.0f) * 0.08f;
                    float dy = (modelOffsetRandom.nextFloat() * 2.0f - 1.0f) * 0.08f;
                    float dz = (modelOffsetRandom.nextFloat() * 2.0f - 1.0f) * 0.08f;
                    bb.func_178969_c(x + (double)dx, y + (double)dy, z + (double)dz);
                }
                float scale = 0.3f;
                MutableQuad q = new MutableQuad(-1, null);
                for (EnumPipePart part : EnumPipePart.VALUES) {
                    for (BakedQuad quad : model.func_188616_a(null, part.face, 0L)) {
                        q.fromBakedItem(quad);
                        q.translated(-0.5, -0.5, -0.5);
                        q.scaled(scale);
                        q.rotate(EnumFacing.SOUTH, dir, 0.0f, 0.0f, 0.0f);
                        if (quad.func_178212_b()) {
                            int colour = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
                            if (EntityRenderer.field_78517_a) {
                                colour = TextureUtil.func_177054_c((int)colour);
                            }
                            q.multColouri(colour, colour >> 8, colour >> 16, 255);
                        }
                        q.lighti(lightc);
                        Vector3f normal = q.getCalculatedNormal();
                        q.normalvf(normal);
                        q.multShade();
                        q.render(bb);
                    }
                }
            }
            bb.func_178969_c(0.0, 0.0, 0.0);
            return;
        }
        if (!inBatch) {
            inBatch = true;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glScaled((double)0.3, (double)0.3, (double)0.3);
            RenderHelper.func_74518_a();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lightc % 65536.0f), (float)((float)lightc / 65536.0f));
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
    }

    private static void setupModelOffsetRandom(ItemStack stack) {
        long seed;
        if (stack.func_190926_b()) {
            seed = 137L;
        } else {
            ResourceLocation regName = stack.func_77973_b().getRegistryName();
            if (regName == null) {
                seed = 127L;
            } else {
                int regNameSeed = regName.func_110624_b().hashCode() ^ regName.func_110623_a().hashCode();
                seed = (long)(regNameSeed & Integer.MAX_VALUE) | (long)stack.func_77960_j() << 32;
            }
        }
        modelOffsetRandom.setSeed(seed);
    }

    private static int getStackModelCount(int stackCount) {
        if (stackCount > 1) {
            if (stackCount > 16) {
                if (stackCount > 32) {
                    if (stackCount > 48) {
                        return 5;
                    }
                    return 4;
                }
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static void endItemBatch() {
        if (inBatch) {
            inBatch = false;
            GL11.glPopMatrix();
        }
    }

    static {
        modelOffsetRandom = new Random(0L);
        dummyEntityItem = new EntityItem(null);
        customItemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

            public boolean shouldSpreadItems() {
                return false;
            }

            public boolean shouldBob() {
                return false;
            }
        };
        glListCache = CacheBuilder.newBuilder().expireAfterAccess(40L, TimeUnit.SECONDS).removalListener(ItemRenderUtil::onStackRemove).build(CacheLoader.from(ItemRenderUtil::makeItemGlList));
        inBatch = false;
    }
}

