/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.fluid;

import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.client.render.fluid.SpriteFluidFrozen;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.RenderUtil;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.lib.misc.VecUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidRenderer {
    private static final EnumMap<FluidSpriteType, Map<String, TextureAtlasSprite>> fluidSprites = new EnumMap(FluidSpriteType.class);
    public static final MutableVertex vertex = new MutableVertex();
    private static final boolean[] DEFAULT_FACES = new boolean[]{true, true, true, true, true, true};
    private static BufferBuilder bb;
    private static TextureAtlasSprite sprite;
    private static TexMap texmap;
    private static boolean invertU;
    private static boolean invertV;
    private static double xTexDiff;
    private static double yTexDiff;
    private static double zTexDiff;

    public static void onTextureStitchPre(TextureMap map) {
        for (FluidSpriteType type : FluidSpriteType.values()) {
            fluidSprites.get((Object)type).clear();
        }
        HashMap<ResourceLocation, SpriteFluidFrozen> spritesStitched = new HashMap<ResourceLocation, SpriteFluidFrozen>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ResourceLocation still = fluid.getStill();
            ResourceLocation flowing = fluid.getFlowing();
            if (still == null || flowing == null) {
                throw new IllegalStateException("Encountered a fluid with a null still sprite! (" + fluid.getName() + " - " + FluidRegistry.getDefaultFluidName((Fluid)fluid) + ")");
            }
            if (spritesStitched.containsKey(still)) {
                fluidSprites.get((Object)FluidSpriteType.FROZEN).put(fluid.getName(), (TextureAtlasSprite)spritesStitched.get(still));
            } else {
                SpriteFluidFrozen spriteFrozen = new SpriteFluidFrozen(still);
                spritesStitched.put(still, spriteFrozen);
                if (!map.setTextureEntry((TextureAtlasSprite)spriteFrozen)) {
                    throw new IllegalStateException("Failed to set the frozen variant of " + still + "!");
                }
                fluidSprites.get((Object)FluidSpriteType.FROZEN).put(fluid.getName(), spriteFrozen);
            }
            fluidSprites.get((Object)FluidSpriteType.STILL).put(fluid.getName(), map.func_174942_a(still));
            fluidSprites.get((Object)FluidSpriteType.FLOWING).put(fluid.getName(), map.func_174942_a(flowing));
        }
    }

    public static void renderFluid(FluidSpriteType type, IFluidTank tank, Vec3d min, Vec3d max, BufferBuilder bbIn, boolean[] sideRender) {
        FluidRenderer.renderFluid(type, tank.getFluid(), tank.getCapacity(), min, max, bbIn, sideRender);
    }

    public static void renderFluid(FluidSpriteType type, FluidStack fluid, int cap, Vec3d min, Vec3d max, BufferBuilder bbIn, boolean[] sideRender) {
        FluidRenderer.renderFluid(type, fluid, fluid == null ? 0.0 : (double)fluid.amount, cap, min, max, bbIn, sideRender);
    }

    public static void renderFluid(FluidSpriteType type, FluidStack fluid, double amount, double cap, Vec3d min, Vec3d max, BufferBuilder bbIn, boolean[] sideRender) {
        Vec3d realMax;
        Vec3d realMin;
        if (fluid == null || fluid.getFluid() == null || amount <= 0.0) {
            return;
        }
        Profiler prof = Minecraft.func_71410_x().field_71424_I;
        prof.func_76320_a("fluid");
        if (sideRender == null) {
            sideRender = DEFAULT_FACES;
        }
        double height = MathHelper.func_151237_a((double)(amount / cap), (double)0.0, (double)1.0);
        if (fluid.getFluid().isGaseous(fluid)) {
            realMin = VecUtil.replaceValue(min, EnumFacing.Axis.Y, MathUtil.interp(1.0 - height, min.field_72448_b, max.field_72448_b));
            realMax = max;
        } else {
            realMin = min;
            realMax = VecUtil.replaceValue(max, EnumFacing.Axis.Y, MathUtil.interp(height, min.field_72448_b, max.field_72448_b));
        }
        bb = bbIn;
        if (type == null) {
            type = FluidSpriteType.STILL;
        }
        sprite = FluidRenderer.getFluidSprite(type, fluid);
        double xs = realMin.field_72450_a;
        double ys = realMin.field_72448_b;
        double zs = realMin.field_72449_c;
        double xb = realMax.field_72450_a;
        double yb = realMax.field_72448_b;
        double zb = realMax.field_72449_c;
        if (type == FluidSpriteType.FROZEN) {
            xTexDiff = min.field_72450_a > 1.0 ? Math.floor(min.field_72450_a) : (min.field_72450_a < 0.0 ? Math.floor(min.field_72450_a) : 0.0);
            yTexDiff = min.field_72448_b > 1.0 ? Math.floor(min.field_72448_b) : (min.field_72448_b < 0.0 ? Math.floor(min.field_72448_b) : 0.0);
            zTexDiff = min.field_72449_c > 1.0 ? Math.floor(min.field_72449_c) : (min.field_72449_c < 0.0 ? Math.floor(min.field_72449_c) : 0.0);
        } else {
            xTexDiff = 0.0;
            yTexDiff = 0.0;
            zTexDiff = 0.0;
        }
        vertex.colouri(RenderUtil.swapARGBforABGR(fluid.getFluid().getColor(fluid)));
        texmap = TexMap.XZ;
        invertU = false;
        invertV = false;
        if (sideRender[EnumFacing.UP.ordinal()]) {
            FluidRenderer.vertex(xs, yb, zb);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xs, yb, zs);
        }
        if (sideRender[EnumFacing.DOWN.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zs);
            FluidRenderer.vertex(xb, ys, zs);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xs, ys, zb);
        }
        texmap = TexMap.ZY;
        if (sideRender[EnumFacing.WEST.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zs);
            FluidRenderer.vertex(xs, ys, zb);
            FluidRenderer.vertex(xs, yb, zb);
            FluidRenderer.vertex(xs, yb, zs);
        }
        if (sideRender[EnumFacing.EAST.ordinal()]) {
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xb, ys, zs);
        }
        texmap = TexMap.XY;
        if (sideRender[EnumFacing.NORTH.ordinal()]) {
            FluidRenderer.vertex(xs, yb, zs);
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xb, ys, zs);
            FluidRenderer.vertex(xs, ys, zs);
        }
        if (sideRender[EnumFacing.SOUTH.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zb);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xs, yb, zb);
        }
        sprite = null;
        texmap = null;
        bb = null;
        prof.func_76319_b();
    }

    public static TextureAtlasSprite getFluidSprite(FluidSpriteType type, FluidStack fluid) {
        return FluidRenderer.getFluidSprite(type, fluid.getFluid());
    }

    public static TextureAtlasSprite getFluidSprite(FluidSpriteType type, Fluid fluid) {
        if (fluid == null) {
            return SpriteUtil.missingSprite();
        }
        TextureAtlasSprite s = fluidSprites.get((Object)type).get(fluid.getName());
        return s != null ? s : SpriteUtil.missingSprite();
    }

    private static void vertex(double x, double y, double z) {
        vertex.positiond(x, y, z);
        FluidRenderer.texmap.apply(x - FluidRenderer.xTexDiff, y - FluidRenderer.yTexDiff, z - FluidRenderer.zTexDiff);
        vertex.renderAsBlock(bb);
    }

    public static void drawFluidForGui(FluidStack fluid, double startX, double startY, double endX, double endY) {
        double y;
        sprite = fluidSprites.get((Object)FluidSpriteType.STILL).get(fluid.getFluid().getName());
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        Tessellator tess = Tessellator.func_178181_a();
        bb = tess.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double diffX = endX - startX;
        double diffY = endY - startY;
        int stepX = diffX > 0.0 ? 16 : -16;
        int stepY = diffY > 0.0 ? 16 : -16;
        int loopCountX = (int)Math.abs(diffX / 16.0);
        int loopCountY = (int)Math.abs(diffY / 16.0);
        double x = startX;
        for (int xc = 0; xc < loopCountX; ++xc) {
            double y2 = startY;
            for (int yc = 0; yc < loopCountY; ++yc) {
                FluidRenderer.guiVertex(x, y2, 0.0, 0.0);
                FluidRenderer.guiVertex(x + (double)stepX, y2, 16.0, 0.0);
                FluidRenderer.guiVertex(x + (double)stepX, y2 + (double)stepY, 16.0, 16.0);
                FluidRenderer.guiVertex(x, y2 + (double)stepY, 0.0, 16.0);
                y2 += (double)stepY;
            }
            x += (double)stepX;
        }
        if (diffX % 16.0 != 0.0) {
            double additionalWidth = diffX % 16.0;
            x = endX - additionalWidth;
            double xTex = Math.abs(additionalWidth);
            y = startY;
            int yc = 0;
            while (yc < loopCountY) {
                FluidRenderer.guiVertex(x, y, 0.0, 0.0);
                FluidRenderer.guiVertex(endX, y, xTex, 0.0);
                FluidRenderer.guiVertex(endX, y + (double)stepY, xTex, 16.0);
                FluidRenderer.guiVertex(x, y + (double)stepY, 0.0, 16.0);
                y += (double)stepY;
                y += 1.0;
            }
        }
        if (diffY % 16.0 != 0.0) {
            double additionalHeight = diffY % 16.0;
            double y3 = endY - additionalHeight;
            double yTex = Math.abs(additionalHeight);
            x = startX;
            for (int xc = 0; xc < loopCountX; ++xc) {
                FluidRenderer.guiVertex(x, y3, 0.0, 0.0);
                FluidRenderer.guiVertex(x + (double)stepX, y3, 16.0, 0.0);
                FluidRenderer.guiVertex(x + (double)stepX, endY, 16.0, yTex);
                FluidRenderer.guiVertex(x, endY, 0.0, yTex);
                x += (double)stepX;
            }
        }
        if (diffX % 16.0 != 0.0 && diffY % 16.0 != 0.0) {
            double w = diffX % 16.0;
            double h = diffY % 16.0;
            x = endX - w;
            y = endY - h;
            double tx = w < 0.0 ? -w : w;
            double ty = h < 0.0 ? -h : h;
            FluidRenderer.guiVertex(x, y, 0.0, 0.0);
            FluidRenderer.guiVertex(endX, y, tx, 0.0);
            FluidRenderer.guiVertex(endX, endY, tx, ty);
            FluidRenderer.guiVertex(x, endY, 0.0, ty);
        }
        tess.func_78381_a();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        sprite = null;
        bb = null;
    }

    private static void guiVertex(double x, double y, double u, double v) {
        float ru = sprite.func_94214_a(u);
        float rv = sprite.func_94207_b(v);
        bb.func_181662_b(x, y, 0.0);
        bb.func_187315_a((double)ru, (double)rv);
        bb.func_181675_d();
    }

    static {
        vertex.lighti(15, 15);
        for (FluidSpriteType type : FluidSpriteType.values()) {
            fluidSprites.put(type, new HashMap());
        }
    }

    public static class TankSize {
        public final Vec3d min;
        public final Vec3d max;

        public TankSize(int sx, int sy, int sz, int ex, int ey, int ez) {
            this(new Vec3d((double)sx, (double)sy, (double)sz).func_186678_a(0.0625), new Vec3d((double)ex, (double)ey, (double)ez).func_186678_a(0.0625));
        }

        public TankSize(Vec3d min, Vec3d max) {
            this.min = min;
            this.max = max;
        }

        public TankSize shrink(double by) {
            return this.shrink(by, by, by);
        }

        public TankSize shrink(double x, double y, double z) {
            return new TankSize(this.min.func_72441_c(x, y, z), this.max.func_178786_a(x, y, z));
        }

        public TankSize shink(Vec3d by) {
            return this.shrink(by.field_72450_a, by.field_72448_b, by.field_72449_c);
        }

        public TankSize rotateY() {
            Vec3d _min = TankSize.rotateY(this.min);
            Vec3d _max = TankSize.rotateY(this.max);
            return new TankSize(VecUtil.min(_min, _max), VecUtil.max(_min, _max));
        }

        private static Vec3d rotateY(Vec3d vec) {
            return new Vec3d(1.0 - vec.field_72449_c, vec.field_72448_b, vec.field_72450_a);
        }
    }

    private static enum TexMap {
        XY(true, true),
        XZ(true, false),
        ZY(false, true);

        private final boolean ux;
        private final boolean vy;

        private TexMap(boolean ux, boolean vy) {
            this.ux = ux;
            this.vy = vy;
        }

        private void apply(double x, double y, double z) {
            double realv;
            double realu = this.ux ? x : z;
            double d = realv = this.vy ? y : z;
            if (invertU) {
                realu = 1.0 - realu;
            }
            if (invertV) {
                realv = 1.0 - realv;
            }
            vertex.texf(sprite.func_94214_a(realu * 16.0), sprite.func_94207_b(realv * 16.0));
        }
    }
}

