/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.ICBMClassic;
import icbm.classic.api.missiles.parts.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MissilePartRegistry<Part extends IBuildableObject>
implements IBuilderRegistry<Part> {
    private final Map<ResourceLocation, Supplier<Part>> builders = new HashMap<ResourceLocation, Supplier<Part>>();
    private boolean locked = false;
    private final String name;

    @Override
    public void register(ResourceLocation name, Supplier<Part> builder) {
        if (this.locked) {
            throw new RuntimeException(name + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        if (this.builders.containsKey(name)) {
            throw new RuntimeException(name + ": mod '" + FMLCommonHandler.instance().getModName() + "' attempted to override '" + name + "'. This method does not allow replacing existing registries. See implementing class for override call.");
        }
        this.builders.put(name, builder);
    }

    public void overrideRegistry(ResourceLocation name, Supplier<Part> builder) {
        if (this.locked) {
            throw new RuntimeException(name + ":mod '" + FMLCommonHandler.instance().getModName() + "' attempted to do a late registry");
        }
        ICBMClassic.logger().info(name + ":'" + name + "' is being overridden by " + FMLCommonHandler.instance().getModName());
        this.builders.put(name, builder);
    }

    @Override
    public Part build(ResourceLocation name) {
        return (Part)((IBuildableObject)Optional.ofNullable(this.builders.get(name)).map(Supplier::get).orElse(null));
    }

    public void lock() {
        this.locked = true;
    }

    public MissilePartRegistry(String name) {
        this.name = name;
    }
}

