/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.anti;

import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class SAMTargetData
implements IMissileTarget {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "anti.missile");
    private static final int MAX_TARGETS = 5;
    private static final int SCAN_DELAY = 10;
    private static final int MAX_RANGE = 30;
    private final Queue<Entity> targets = new LinkedList<Entity>();
    private Entity currentTarget;
    private final EntitySurfaceToAirMissile host;
    private int scanDelayTick = 0;

    public SAMTargetData(EntitySurfaceToAirMissile host) {
        this.host = host;
    }

    public void tick() {
        if (this.scanDelayTick < 10) {
            ++this.scanDelayTick;
        } else if (this.targets.isEmpty()) {
            this.scanDelayTick = 0;
            this.refreshTargets();
        }
    }

    public void refreshTargets() {
        List<EntityExplosiveMissile> missiles = this.getValidTargets();
        missiles.sort((a, b) -> {
            double distanceA = this.host.func_70068_e((Entity)a);
            double distanceB = this.host.func_70068_e((Entity)b);
            return Double.compare(distanceA, distanceB);
        });
        this.targets.addAll(missiles.subList(0, Math.min(5, missiles.size())));
    }

    private List<EntityExplosiveMissile> getValidTargets() {
        return this.host.world().func_175647_a(EntityExplosiveMissile.class, this.targetArea(), this::isValid);
    }

    private AxisAlignedBB targetArea() {
        return new AxisAlignedBB(this.host.x() - 30.0, this.host.y() - 30.0, this.host.z() - 30.0, this.host.x() + 30.0, this.host.y() + 30.0, this.host.z() + 30.0);
    }

    private boolean isValid(Entity entity) {
        return entity instanceof EntityExplosiveMissile && entity.func_70089_S();
    }

    public Entity getTarget() {
        if (!this.isValid(this.currentTarget)) {
            this.currentTarget = null;
        }
        while (this.currentTarget == null && this.targets.peek() != null) {
            this.currentTarget = this.targets.poll();
            if (this.isValid(this.currentTarget)) continue;
            this.currentTarget = null;
        }
        return this.currentTarget;
    }

    @Override
    public Vec3d getPosition() {
        return this.getTarget() != null ? this.getTarget().func_174791_d() : null;
    }

    @Override
    public boolean isValid() {
        return this.isValid(this.getTarget());
    }

    @Override
    public double getX() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70165_t).orElse(0.0);
    }

    @Override
    public double getY() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70163_u).orElse(0.0);
    }

    @Override
    public double getZ() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70161_v).orElse(0.0);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    public NBTTagCompound serializeNBT() {
        return null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }
}

