/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.packet;

import com.builtbroken.jlib.data.network.IByteBufWriter;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketBase<P extends PacketBase>
implements IPacket<P> {
    protected List<Consumer<ByteBuf>> writers = new ArrayList<Consumer<ByteBuf>>();
    protected ByteBuf dataToRead;

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.writers.forEach(func -> func.accept(buffer));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dataToRead = buffer.slice().copy();
    }

    private void writeData(Object object, ByteBuf buffer) {
        if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.writeData(Array.get(object, i), buffer);
            }
        } else if (object instanceof Collection) {
            for (Object o : (Collection)object) {
                this.writeData(o, buffer);
            }
        } else if (object instanceof Byte) {
            buffer.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Integer) {
            buffer.writeInt(((Integer)object).intValue());
        } else if (object instanceof Short) {
            buffer.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Long) {
            buffer.writeLong(((Long)object).longValue());
        } else if (object instanceof Float) {
            buffer.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            buffer.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof Boolean) {
            buffer.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof String) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)object));
        } else if (object instanceof NBTTagCompound) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)object));
        } else if (object instanceof ItemStack) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack)object));
        } else if (object instanceof Pos) {
            ((Pos)object).writeByteBuf(buffer);
        } else if (object instanceof IByteBufWriter) {
            ((IByteBufWriter)object).writeBytes(buffer);
        } else if (object instanceof Enum) {
            buffer.writeInt(((Enum)object).ordinal());
        } else if (object instanceof Vec3i) {
            buffer.writeInt(((Vec3i)object).func_177958_n());
            buffer.writeInt(((Vec3i)object).func_177956_o());
            buffer.writeInt(((Vec3i)object).func_177952_p());
        } else if (object instanceof Vec3d) {
            buffer.writeDouble(((Vec3d)object).field_72450_a);
            buffer.writeDouble(((Vec3d)object).field_72448_b);
            buffer.writeDouble(((Vec3d)object).field_72449_c);
        } else {
            throw new IllegalArgumentException("PacketBase: Unsupported write data type " + object);
        }
    }

    public ByteBuf data() {
        return this.dataToRead;
    }

    @Override
    public P addData(Object ... objects) {
        for (Object object : objects) {
            this.addData(byteBuf -> this.writeData(object, (ByteBuf)byteBuf));
        }
        return (P)this;
    }

    @Override
    public P addData(Consumer<ByteBuf> writer) {
        this.writers.add(writer);
        return (P)this;
    }

    @Deprecated
    public P write(Object object) {
        return (P)this.addData(new Object[]{object});
    }
}

