/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import com.google.common.base.CaseFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nihiltres.engineersdoors.common.CommonProxy;
import nihiltres.engineersdoors.common.item.IOre;
import nihiltres.engineersdoors.common.module.Doors;
import nihiltres.engineersdoors.common.module.Fencegates;
import nihiltres.engineersdoors.common.module.IModule;
import nihiltres.engineersdoors.common.module.Trapdoors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="engineersdoors", name="Engineer's Doors", version="0.9.1", dependencies="required-after:immersiveengineering;", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class EngineersDoors {
    @Mod.Instance(value="engineersdoors")
    public static EngineersDoors instance;
    @SidedProxy(serverSide="nihiltres.engineersdoors.common.CommonProxy", clientSide="nihiltres.engineersdoors.client.ClientProxy")
    public static CommonProxy proxy;
    public static CreativeTabs creativeTab;
    public static Set<IModule> modules;
    private static Logger log;

    public static void log(String msg) {
        log.log(Level.INFO, msg);
    }

    public static void debug(String msg) {
        log.log(Level.WARN, msg);
    }

    public static void debug(Throwable e) {
        EngineersDoors.debug(e.getClass().toString().substring(6));
        String msg = e.getMessage();
        if (msg != null) {
            EngineersDoors.debug(msg);
        }
        for (StackTraceElement ste : e.getStackTrace()) {
            EngineersDoors.debug(ste.toString());
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        EngineersDoors.log(String.format("%d modules loaded.", modules.size()));
        for (IModule module : modules) {
            EngineersDoors.log(String.format("Pre-initializing %s module", module.getName()));
            module.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (IModule module : modules) {
            EngineersDoors.log(String.format("Initializing %s module", module.getName()));
            module.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (IModule module : modules) {
            EngineersDoors.log(String.format("Post-initializing %s module", module.getName()));
            module.postInit();
        }
        IOre.wipeMap();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (IModule module : modules) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])module.getBlocks().toArray(new Block[0]));
            for (Class<? extends TileEntity> teClass : module.getTileEntities()) {
                String name = teClass.getName().substring(teClass.getName().lastIndexOf(".") + 1);
                if (name.substring(0, 10).toLowerCase().equals("tileentity")) {
                    name = name.substring(10);
                }
                name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
                name = String.format("%s:%s", "engineersdoors", name);
                GameRegistry.registerTileEntity(teClass, (ResourceLocation)new ResourceLocation(name));
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (IModule iModule : modules) {
            for (Item item : iModule.getItems()) {
                Block block;
                event.getRegistry().register((IForgeRegistryEntry)item);
                Set<String> oreNames = null;
                if (!(item instanceof IOre) && item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof IOre) {
                    oreNames = ((IOre)block).getOreNames();
                    IOre.demap((IOre)block);
                }
                oreNames = IOre.oreNameMap.get(IOre.getMapName(item));
                IOre.demap(item);
                if (item instanceof IOre) {
                    oreNames = ((IOre)item).getOreNames();
                    IOre.demap(item);
                }
                if (oreNames == null) continue;
                for (String s : oreNames) {
                    OreDictionary.registerOre((String)s, (Item)item);
                }
            }
        }
        if (IOre.oreNameMap.size() > 0) {
            EngineersDoors.debug(String.format("%d ore dictionary entries are set that weren't mapped to any item:", IOre.oreNameMap.size()));
            for (Map.Entry entry : IOre.oreNameMap.entrySet()) {
                EngineersDoors.debug(String.format("\t%s: %s", entry.getKey(), entry.getValue()));
            }
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (IModule module : modules) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])module.getRecipes().toArray(new IRecipe[0]));
        }
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        for (IModule module : modules) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])module.getSoundEvents().toArray(new SoundEvent[0]));
        }
    }

    static {
        creativeTab = ImmersiveEngineering.creativeTab;
        modules = new HashSet<IModule>();
        modules.add(new Doors());
        modules.add(new Fencegates());
        modules.add(new Trapdoors());
        log = LogManager.getLogger((String)"Engineer's Doors");
    }
}

