/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuStuff;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.internal.FuzzyMode;
import vswe.superfactory.components.internal.ItemSetting;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.util.SearchUtil;

public class ComponentMenuItem
extends ComponentMenuStuff {
    private static final int ARROW_HEIGHT = 10;
    private static final int ARROW_SRC_X = 18;
    private static final int ARROW_SRC_Y = 20;
    private static final int ARROW_TEXT_Y = 40;
    private static final int ARROW_WIDTH = 6;
    private static final int ARROW_X_LEFT = 5;
    private static final int ARROW_X_RIGHT = 109;
    private static final int ARROW_Y = 37;
    private static final int DMG_VAL_TEXT_X = 15;
    private static final int DMG_VAL_TEXT_Y = 55;
    private TextBoxNumber amountTextBox;
    private TextBoxNumber damageValueTextBox;

    public ComponentMenuItem(FlowComponent parent) {
        this(parent, ItemSetting.class);
    }

    protected ComponentMenuItem(FlowComponent parent, Class<? extends Setting> settingClass) {
        super(parent, settingClass);
        if (((Setting)this.settings.get(0)).isAmountSpecific()) {
            this.amountTextBox = new TextBoxNumber(80, 24, 3, true){

                @Override
                public boolean isVisible() {
                    return ComponentMenuItem.this.selectedSetting.isLimitedByAmount();
                }

                @Override
                public void onNumberChanged() {
                    ComponentMenuItem.this.selectedSetting.setAmount(this.getNumber());
                    ComponentMenuItem.this.writeServerData(ComponentMenuStuff.DataTypeHeader.AMOUNT);
                }
            };
            this.numberTextBoxes.addTextBox(this.amountTextBox);
        }
        this.damageValueTextBox = new TextBoxNumber(70, 52, 5, true){

            @Override
            public boolean isVisible() {
                return ComponentMenuItem.this.getSelectedSetting().canChangeMetaData() && ComponentMenuItem.this.getSelectedSetting().getFuzzyMode().requiresMetaData();
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuItem.this.getSelectedSetting().getItem().func_77964_b(this.getNumber());
                ComponentMenuItem.this.writeServerData(ComponentMenuStuff.DataTypeHeader.META);
            }
        };
        this.numberTextBoxes.addTextBox(this.damageValueTextBox);
    }

    protected ItemSetting getSelectedSetting() {
        return (ItemSetting)this.selectedSetting;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getToolTip(ItemStack itemStack) {
        try {
            return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
        catch (Exception ex) {
            if (itemStack.func_77952_i() == 0) {
                return new ArrayList<String>();
            }
            ItemStack newItem = itemStack.func_77946_l();
            newItem.func_77964_b(0);
            return ComponentMenuItem.getToolTip(newItem);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getDisplayName(ItemStack itemStack) {
        try {
            return itemStack.func_82833_r();
        }
        catch (Exception ex) {
            if (itemStack.func_77952_i() == 0) {
                return "";
            }
            ItemStack newItem = itemStack.func_77946_l();
            newItem.func_77964_b(0);
            return ComponentMenuItem.getDisplayName(newItem);
        }
    }

    @Override
    public String getName() {
        return Localization.ITEM_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawInfoMenuContent(GuiManager gui, int mX, int mY) {
        if (this.damageValueTextBox.isVisible()) {
            gui.drawString(Localization.DAMAGE_VALUE.toString(), 15, 55, 0.7f, 0x404040);
        }
        for (int i = 0; i < 2; ++i) {
            int x = i == 0 ? 5 : 109;
            int y = 37;
            int srcXArrow = i;
            int srcYArrow = CollisionHelper.inBounds(x, y, 6, 10, mX, mY) ? 1 : 0;
            gui.drawTexture(x, y, 18 + srcXArrow * 6, 20 + srcYArrow * 10, 6, 10);
        }
        gui.drawCenteredString(this.getSelectedSetting().getFuzzyMode().toString(), 5, 40, 0.7f, 110, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawResultObject(GuiManager gui, Object obj, int x, int y) {
        gui.drawItemStack((ItemStack)obj, x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawSettingObject(GuiManager gui, Setting setting, int x, int y) {
        this.drawResultObject(gui, ((ItemSetting)setting).getItem(), x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<String> getResultObjectMouseOver(Object o) {
        return ComponentMenuItem.getToolTip((ItemStack)o);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List<String> getSettingObjectMouseOver(Setting setting) {
        return this.getResultObjectMouseOver(((ItemSetting)setting).getItem());
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (this.isEditing()) {
            for (int i = -1; i <= 1; i += 2) {
                int y;
                int x = i == 1 ? 109 : 5;
                if (!CollisionHelper.inBounds(x, y = 37, 6, 10, mX, mY)) continue;
                int id = this.getSelectedSetting().getFuzzyMode().ordinal();
                if ((id += i) < 0) {
                    id = FuzzyMode.values().length - 1;
                } else if (id == FuzzyMode.values().length) {
                    id = 0;
                }
                this.getSelectedSetting().setFuzzyMode(FuzzyMode.values()[id]);
                this.writeServerData(ComponentMenuStuff.DataTypeHeader.USE_FUZZY);
                break;
            }
        }
    }

    @Override
    protected void updateTextBoxes() {
        if (this.amountTextBox != null) {
            this.amountTextBox.setNumber(this.selectedSetting.getAmount());
        }
        this.damageValueTextBox.setNumber(this.getSelectedSetting().getItem().func_77952_i());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        super.refreshData(container, newData);
        for (int i = 0; i < this.settings.size(); ++i) {
            ItemSetting setting = (ItemSetting)this.settings.get(i);
            ItemSetting newSetting = (ItemSetting)((ComponentMenuStuff)newData).settings.get(i);
            if (newSetting.getFuzzyMode() != setting.getFuzzyMode()) {
                setting.setFuzzyMode(newSetting.getFuzzyMode());
                this.writeClientData(container, ComponentMenuStuff.DataTypeHeader.USE_FUZZY, setting);
            }
            if (!newSetting.isValid() || !setting.isValid() || newSetting.getItem().func_77952_i() == setting.getItem().func_77952_i()) continue;
            setting.getItem().func_77964_b(newSetting.getItem().func_77952_i());
            this.writeClientData(container, ComponentMenuStuff.DataTypeHeader.META, setting);
        }
    }

    @Override
    protected DataBitHelper getAmountBitLength() {
        return DataBitHelper.MENU_ITEM_AMOUNT;
    }

    @Override
    protected void readSpecificHeaderData(DataReader dr, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        ItemSetting itemSetting = (ItemSetting)setting;
        switch (header) {
            case SET_ITEM: {
                int id = dr.readData(DataBitHelper.MENU_ITEM_ID);
                int dmg = dr.readData(DataBitHelper.MENU_ITEM_META);
                itemSetting.setItem(new ItemStack(Item.func_150899_d((int)id), 1, dmg));
                itemSetting.getItem().func_77982_d(dr.readNBT());
                if (!this.isEditing()) break;
                this.updateTextBoxes();
                break;
            }
            case USE_FUZZY: {
                itemSetting.setFuzzyMode(FuzzyMode.values()[dr.readData(DataBitHelper.FUZZY_MODE)]);
                break;
            }
            case META: {
                if (!setting.isValid()) break;
                itemSetting.getItem().func_77964_b(dr.readData(DataBitHelper.MENU_ITEM_META));
                if (!this.isEditing()) break;
                this.damageValueTextBox.setNumber(itemSetting.getItem().func_77952_i());
            }
        }
    }

    @Override
    protected void writeSpecificHeaderData(DataWriter dw, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        ItemSetting itemSetting = (ItemSetting)setting;
        switch (header) {
            case SET_ITEM: {
                dw.writeData(Item.func_150891_b((Item)itemSetting.getItem().func_77973_b()), DataBitHelper.MENU_ITEM_ID);
                dw.writeData(itemSetting.getItem().func_77952_i(), DataBitHelper.MENU_ITEM_META);
                dw.writeNBT(itemSetting.getItem().func_77978_p());
                break;
            }
            case USE_FUZZY: {
                dw.writeData(itemSetting.getFuzzyMode().ordinal(), DataBitHelper.FUZZY_MODE);
                break;
            }
            case META: {
                dw.writeData(itemSetting.getItem().func_77952_i(), DataBitHelper.MENU_ITEM_META);
            }
        }
    }

    @Override
    protected List updateSearch(String search, boolean showAll) {
        return SearchUtil.getSearchResults(search, showAll);
    }
}

