/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.wood.BlockAtumTorch;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.StackHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="atum")
public class BlockAtumTorchUnlit
extends BlockAtumTorch {
    private static final List<BlockAtumTorch> TORCHES = Arrays.asList(AtumBlocks.PALM_TORCH, AtumBlocks.DEADWOOD_TORCH, AtumBlocks.LIMESTONE_TORCH, AtumBlocks.BONE_TORCH, AtumBlocks.PHARAOH_TORCH);
    private static final Map<Block, Block> UNLIT = Maps.newHashMap();
    private static final Map<Block, Block> LIT = Maps.newHashMap();

    private BlockAtumTorchUnlit() {
        this.func_149715_a(0.0f);
    }

    public static void registerUnlitTorches() {
        for (BlockAtumTorch torch : TORCHES) {
            BlockAtumTorchUnlit unlitTorch = new BlockAtumTorchUnlit();
            UNLIT.put((Block)torch, (Block)unlitTorch);
            LIT.put((Block)unlitTorch, (Block)torch);
            AtumRegistry.registerBlock((Block)unlitTorch, Objects.requireNonNull(torch.getRegistryName()).func_110623_a() + "_unlit", null);
        }
    }

    public static Block getUnlitTorch(Block torch) {
        return UNLIT.get(torch);
    }

    private static Block getLitTorch(Block torch) {
        return LIT.get(torch);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        Block block = Block.func_149634_a((Item)heldStack.func_77973_b());
        if (heldStack.func_77973_b() instanceof ItemFlintAndSteel || block.getLightValue(block.func_176223_P(), (IBlockAccess)world, pos) > 0) {
            if (heldStack.func_77973_b().func_77645_m()) {
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_175656_a(pos, BlockAtumTorchUnlit.getLitTorch((Block)this).getStateForPlacement(world, pos, (EnumFacing)state.func_177229_b((IProperty)BlockAtumTorch.field_176596_a), hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand));
            world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 2.5f, 1.0f);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof BlockAtumTorchUnlit && state.func_177230_c().getLightValue(state.func_177230_c().func_176223_P(), (IBlockAccess)event.getWorld(), event.getPos()) > 0) {
            BlockPos pos = event.getPos();
            event.setCanceled(true);
            event.getItemStack().func_190918_g(1);
            StackHelper.giveItem(event.getEntityPlayer(), event.getHand(), new ItemStack(BlockAtumTorchUnlit.getLitTorch(Block.func_149634_a((Item)event.getItemStack().func_77973_b()))));
            event.getWorld().func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 10.0f, 1.0f, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }
}

