/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import java.io.IOException;
import nc.container.ContainerTile;
import nc.container.processor.ContainerAssembler;
import nc.container.processor.ContainerMachineConfig;
import nc.gui.element.NCButton;
import nc.gui.element.NCToggleButton;
import nc.gui.processor.GuiItemProcessor;
import nc.gui.processor.GuiItemSorptions;
import nc.network.PacketHandler;
import nc.network.gui.OpenSideConfigGuiPacket;
import nc.network.gui.OpenTileGuiPacket;
import nc.network.gui.ToggleRedstoneControlPacket;
import nc.tile.processor.TileItemProcessor;
import nc.util.Lang;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiAssembler
extends GuiItemProcessor {
    public GuiAssembler(EntityPlayer player, TileItemProcessor tile) {
        this(player, tile, new ContainerAssembler(player, tile));
    }

    protected GuiAssembler(EntityPlayer player, TileItemProcessor tile, ContainerTile<TileItemProcessor> container) {
        super("assembler", player, tile, container);
        this.field_146999_f = 176;
        this.field_147000_g = 178;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 16, 86);
        this.renderButtonTooltips(mouseX, mouseY);
    }

    public void renderButtonTooltips(int mouseX, int mouseY) {
        this.drawTooltip(Lang.localise("gui.nc.container.machine_side_config"), mouseX, mouseY, 27, 75, 18, 18);
        this.drawTooltip(Lang.localise("gui.nc.container.redstone_control"), mouseX, mouseY, 47, 75, 18, 18);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.tile.defaultProcessPower != 0.0) {
            int e = (int)Math.round(86.0 * (double)this.tile.getEnergyStorage().getEnergyStored() / (double)this.tile.getEnergyStorage().getMaxEnergyStored());
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 86 - e, 176, 176 - e, 16, e);
        } else {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 6, this.field_147003_i + 8 + 16, this.field_147009_r + 6 + 86, -3750202, -7631989);
        }
        this.func_73729_b(this.field_147003_i + 84, this.field_147009_r + 31, 176, 3, this.getCookProgressScaled(37), 38);
        this.drawUpgradeRenderers();
        this.drawBackgroundExtras();
    }

    protected void drawBackgroundExtras() {
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        this.field_146292_n.add(new NCButton.MachineConfig(0, this.field_147003_i + 27, this.field_147009_r + 75));
        this.field_146292_n.add(new NCToggleButton.RedstoneControl(1, this.field_147003_i + 47, this.field_147009_r + 75, this.tile));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            if (guiButton.field_146127_k == 0) {
                PacketHandler.instance.sendToServer((IMessage)new OpenSideConfigGuiPacket(this.tile));
            } else if (guiButton.field_146127_k == 1) {
                this.tile.setRedstoneControl(!this.tile.getRedstoneControl());
                PacketHandler.instance.sendToServer((IMessage)new ToggleRedstoneControlPacket(this.tile));
            }
        }
    }

    public static class SideConfig
    extends GuiAssembler {
        public SideConfig(EntityPlayer player, TileItemProcessor tile) {
            super(player, tile, new ContainerMachineConfig<TileItemProcessor>(player, tile));
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            if (this.isEscapeKeyDown(keyCode)) {
                PacketHandler.instance.sendToServer((IMessage)new OpenTileGuiPacket(this.tile));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }

        @Override
        public void renderButtonTooltips(int mouseX, int mouseY) {
            this.drawTooltip(TextFormatting.BLUE + Lang.localise("gui.nc.container.input_item_config"), mouseX, mouseY, 45, 30, 18, 18);
            this.drawTooltip(TextFormatting.BLUE + Lang.localise("gui.nc.container.input_item_config"), mouseX, mouseY, 65, 30, 18, 18);
            this.drawTooltip(TextFormatting.BLUE + Lang.localise("gui.nc.container.input_item_config"), mouseX, mouseY, 45, 50, 18, 18);
            this.drawTooltip(TextFormatting.BLUE + Lang.localise("gui.nc.container.input_item_config"), mouseX, mouseY, 65, 50, 18, 18);
            this.drawTooltip(TextFormatting.GOLD + Lang.localise("gui.nc.container.output_item_config"), mouseX, mouseY, 121, 36, 26, 26);
            this.drawTooltip(TextFormatting.DARK_BLUE + Lang.localise("gui.nc.container.upgrade_config"), mouseX, mouseY, 131, 75, 18, 18);
            this.drawTooltip(TextFormatting.YELLOW + Lang.localise("gui.nc.container.upgrade_config"), mouseX, mouseY, 151, 75, 18, 18);
        }

        @Override
        protected void drawUpgradeRenderers() {
        }

        @Override
        protected void drawBackgroundExtras() {
        }

        @Override
        public void initButtons() {
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(0, this.field_147003_i + 45, this.field_147009_r + 30));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(1, this.field_147003_i + 65, this.field_147009_r + 30));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(2, this.field_147003_i + 45, this.field_147009_r + 50));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(3, this.field_147003_i + 65, this.field_147009_r + 50));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemOutput(4, this.field_147003_i + 121, this.field_147009_r + 36));
            this.field_146292_n.add(new NCButton.SorptionConfig.SpeedUpgrade(5, this.field_147003_i + 131, this.field_147009_r + 75));
            this.field_146292_n.add(new NCButton.SorptionConfig.EnergyUpgrade(6, this.field_147003_i + 151, this.field_147009_r + 75));
        }

        @Override
        protected void func_146284_a(GuiButton guiButton) {
            if (this.tile.func_145831_w().field_72995_K) {
                if (guiButton.field_146127_k == 0) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.Input<TileItemProcessor>(this, this.tile, 0));
                } else if (guiButton.field_146127_k == 1) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.Input<TileItemProcessor>(this, this.tile, 1));
                } else if (guiButton.field_146127_k == 2) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.Input<TileItemProcessor>(this, this.tile, 2));
                } else if (guiButton.field_146127_k == 3) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.Input<TileItemProcessor>(this, this.tile, 3));
                } else if (guiButton.field_146127_k == 4) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.Output<TileItemProcessor>(this, this.tile, 4));
                } else if (guiButton.field_146127_k == 5) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.SpeedUpgrade<TileItemProcessor>(this, this.tile, 5));
                } else if (guiButton.field_146127_k == 6) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.EnergyUpgrade<TileItemProcessor>(this, this.tile, 6));
                }
            }
        }
    }
}

