/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.block.fluid.NCBlockFluid;
import nc.entity.EntityFeralGhoul;
import nc.fluid.FluidFission;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCCoolantFluids;
import nc.init.NCFissionFluids;
import nc.init.NCFluids;
import nc.init.NCItems;
import nc.init.NCTools;
import nc.multiblock.qComputer.tile.TileQuantumComputerQubit;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.render.BlockHighlightHandler;
import nc.render.entity.RenderFeralGhoul;
import nc.render.tile.RenderQuantumComputerQubit;
import nc.render.tile.RenderTurbineRotor;
import nc.util.NCUtil;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RenderHandler {
    public static void init() {
        NCBlocks.registerRenders();
        NCItems.registerRenders();
        NCTools.registerRenders();
        NCArmor.registerRenders();
        ClientRegistry.bindTileEntitySpecialRenderer(TileTurbineController.class, (TileEntitySpecialRenderer)new RenderTurbineRotor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileQuantumComputerQubit.class, (TileEntitySpecialRenderer)new RenderQuantumComputerQubit());
        RenderHandler.registerEntityRender(EntityFeralGhoul.class, RenderFeralGhoul.class);
        MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightHandler());
    }

    protected static <E extends Entity, R extends Render<E>> void registerEntityRender(Class<E> entityClass, Class<R> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, manager -> {
            Render render = null;
            try {
                render = (Render)NCUtil.newInstance(renderClass, manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return render;
        });
    }

    protected static class TextureStichHandler {
        protected TextureStichHandler() {
        }

        @SubscribeEvent
        public void stitchTextures(TextureStitchEvent.Pre event) {
            TextureMap map = event.getMap();
            for (Pair<Fluid, NCBlockFluid> pair : NCFluids.fluidPairList) {
                map.func_174942_a(((Fluid)pair.getLeft()).getStill());
                map.func_174942_a(((Fluid)pair.getLeft()).getFlowing());
            }
            for (FluidFission fluidFission : NCFissionFluids.fluidList) {
                map.func_174942_a(fluidFission.getStill());
                map.func_174942_a(fluidFission.getFlowing());
            }
            for (Pair pair : NCCoolantFluids.fluidPairList) {
                map.func_174942_a(((Fluid)pair.getLeft()).getStill());
                map.func_174942_a(((Fluid)pair.getLeft()).getFlowing());
            }
        }
    }
}

