/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.gtce;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeHelper;
import nc.recipe.RecipeTupleGenerator;
import nc.recipe.ingredient.IChanceFluidIngredient;
import nc.recipe.ingredient.IChanceItemIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.NCUtil;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class GTCERecipeHelper {
    @Optional.Method(modid="gregtech")
    public static void addGTCERecipe(String recipeName, BasicRecipe recipe) {
        boolean bl;
        int maxNumber;
        int i;
        RecipeMap recipeMap = null;
        RecipeBuilder builder = null;
        switch (recipeName) {
            case "manufactory": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 12, 8);
                break;
            }
            case "separator": {
                recipeMap = RecipeMaps.THERMAL_CENTRIFUGE_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 48, 160);
                break;
            }
            case "decay_hastener": {
                return;
            }
            case "fuel_reprocessor": {
                return;
            }
            case "alloy_furnace": {
                recipeMap = RecipeMaps.ALLOY_SMELTER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 10);
                break;
            }
            case "infuser": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 10);
                break;
            }
            case "melter": {
                recipeMap = RecipeMaps.FLUID_EXTRACTION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 32, 16);
                break;
            }
            case "supercooler": {
                recipeMap = RecipeMaps.VACUUM_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 240, 20);
                break;
            }
            case "electrolyzer": {
                recipeMap = RecipeMaps.ELECTROLYZER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 16);
                break;
            }
            case "assembler": {
                recipeMap = RecipeMaps.ASSEMBLER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 4, 100);
                break;
            }
            case "ingot_former": {
                recipeMap = RecipeMaps.FLUID_SOLIDFICATION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 8, 1);
                break;
            }
            case "pressurizer": {
                if (GTCERecipeHelper.isPlateRecipe(recipe)) {
                    recipeMap = RecipeMaps.BENDER_RECIPES;
                    builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 24, 10).notConsumable((Ingredient)new IntCircuitIngredient(new int[]{0}));
                    break;
                }
                recipeMap = RecipeMaps.COMPRESSOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 2, 20);
                break;
            }
            case "chemical_reactor": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 30).notConsumable((Ingredient)new IntCircuitIngredient(new int[]{0}));
                break;
            }
            case "salt_mixer": {
                recipeMap = RecipeMaps.MIXER_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 8, 12);
                break;
            }
            case "crystallizer": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 30, 10).notConsumable((Ingredient)new IntCircuitIngredient(new int[]{1}));
                break;
            }
            case "enricher": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 20, 20).notConsumable((Ingredient)new IntCircuitIngredient(new int[]{2}));
                break;
            }
            case "extractor": {
                recipeMap = RecipeMaps.FLUID_EXTRACTION_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 12);
                break;
            }
            case "centrifuge": {
                recipeMap = RecipeMaps.CENTRIFUGE_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 16, 80);
                break;
            }
            case "rock_crusher": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCERecipeHelper.addStats(recipeMap.recipeBuilder(), recipe, 20, 12);
                return;
            }
        }
        if (recipeMap == null || builder == null) {
            return;
        }
        ArrayList<List<ItemStack>> itemInputLists = new ArrayList<List<ItemStack>>();
        ArrayList<List<FluidStack>> fluidInputLists = new ArrayList<List<FluidStack>>();
        for (IItemIngredient item : recipe.getItemIngredients()) {
            itemInputLists.add(item.getInputStackList());
        }
        for (IFluidIngredient fluid : recipe.getFluidIngredients()) {
            fluidInputLists.add(fluid.getInputStackList());
        }
        int arrSize = recipe.getItemIngredients().size() + recipe.getFluidIngredients().size();
        int[] inputNumbers = new int[arrSize];
        Arrays.fill(inputNumbers, 0);
        int[] maxNumbers = new int[arrSize];
        for (i = 0; i < itemInputLists.size(); ++i) {
            maxNumber = ((List)itemInputLists.get(i)).size() - 1;
            if (maxNumber < 0) {
                return;
            }
            maxNumbers[i] = maxNumber;
        }
        for (i = 0; i < fluidInputLists.size(); ++i) {
            maxNumber = ((List)fluidInputLists.get(i)).size() - 1;
            if (maxNumber < 0) {
                return;
            }
            maxNumbers[i + itemInputLists.size()] = maxNumber;
        }
        ArrayList<Pair<List<ItemStack>, List<FluidStack>>> materialListTuples = new ArrayList<Pair<List<ItemStack>, List<FluidStack>>>();
        RecipeTupleGenerator.INSTANCE.generateMaterialListTuples(materialListTuples, maxNumbers, inputNumbers, itemInputLists, fluidInputLists, true);
        for (Pair pair : materialListTuples) {
            if (!GTCERecipeHelper.isRecipeInvalid(recipeMap, (List)pair.getLeft(), (List)pair.getRight())) continue;
            return;
        }
        ArrayList<RecipeBuilder> builders = new ArrayList<RecipeBuilder>();
        builders.add(builder);
        for (IItemIngredient iItemIngredient : recipe.getItemIngredients()) {
            if (iItemIngredient instanceof OreIngredient) {
                for (RecipeBuilder builderVariant : builders) {
                    builderVariant.input(((OreIngredient)iItemIngredient).oreName, ((OreIngredient)iItemIngredient).stackSize);
                }
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<RecipeBuilder> newBuilders = new ArrayList<RecipeBuilder>();
            for (ItemStack inputVariant : iItemIngredient.getInputStackList()) {
                if (inputVariant.func_190926_b()) continue;
                Set<String> variantOreList = OreDictHelper.getOreNames(inputVariant);
                if (!variantOreList.isEmpty()) {
                    if (arrayList.containsAll(variantOreList)) continue;
                    arrayList.addAll(variantOreList);
                    for (RecipeBuilder recipeBuilder : builders) {
                        newBuilders.add(recipeBuilder.copy().input(variantOreList.iterator().next(), inputVariant.func_190916_E()));
                    }
                    continue;
                }
                for (RecipeBuilder recipeBuilder : builders) {
                    newBuilders.add(recipeBuilder.copy().inputs(new ItemStack[]{inputVariant}));
                }
            }
            builders = newBuilders;
        }
        if (recipeMap == RecipeMaps.FLUID_SOLIDFICATION_RECIPES) {
            MetaItem.MetaValueItem metaValueItem = GTCERecipeHelper.getIngotFormerMold(recipe);
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.notConsumable(metaValueItem);
            }
        }
        for (IFluidIngredient iFluidIngredient : recipe.getFluidIngredients()) {
            if (iFluidIngredient.getInputStackList().isEmpty()) continue;
            for (RecipeBuilder builderVariant : builders) {
                builderVariant.fluidInputs(new FluidStack[]{(FluidStack)iFluidIngredient.getInputStackList().get(0)});
            }
        }
        for (IItemIngredient iItemIngredient : recipe.getItemProducts()) {
            if (iItemIngredient instanceof IChanceItemIngredient) {
                return;
            }
            List list = iItemIngredient.getOutputStackList();
            if (list.isEmpty()) continue;
            for (RecipeBuilder builderVariant : builders) {
                builderVariant = builderVariant.outputs(new ItemStack[]{(ItemStack)list.get(0)});
            }
        }
        for (IFluidIngredient iFluidIngredient : recipe.getFluidProducts()) {
            if (iFluidIngredient instanceof IChanceFluidIngredient) {
                return;
            }
            List list = iFluidIngredient.getOutputStackList();
            if (list.isEmpty()) continue;
            for (RecipeBuilder builderVariant : builders) {
                builderVariant.fluidOutputs(new FluidStack[]{(FluidStack)list.get(0)});
            }
        }
        boolean bl2 = false;
        for (RecipeBuilder recipeBuilder : builders) {
            if (recipeBuilder.getInputs().isEmpty() && recipeBuilder.getFluidInputs().isEmpty()) continue;
            recipeBuilder.buildAndRegister();
            bl = true;
        }
        if (bl && NCConfig.gtce_recipe_logging) {
            NCUtil.getLogger().info("Injected GTCE " + recipeMap.unlocalizedName + " recipe: " + RecipeHelper.getRecipeString(recipe));
        }
    }

    @Optional.Method(modid="gregtech")
    private static RecipeBuilder<?> addStats(RecipeBuilder<?> builder, BasicRecipe recipe, int processPower, int processTime) {
        return builder.EUt(Math.max((int)recipe.getBaseProcessPower(processPower), 1)).duration((int)recipe.getBaseProcessTime(20.0 * (double)processTime));
    }

    @Optional.Method(modid="gregtech")
    private static boolean isRecipeInvalid(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        if (fluidInputs.size() < recipeMap.getMinFluidInputs() || fluidInputs.size() > recipeMap.getMaxFluidInputs()) {
            return true;
        }
        if (inputs.size() < recipeMap.getMinInputs() || inputs.size() > recipeMap.getMaxInputs()) {
            return true;
        }
        if (recipeMap.getMaxInputs() > 0) {
            return GTCERecipeHelper.findConflictByInputs(recipeMap, inputs, fluidInputs);
        }
        return GTCERecipeHelper.findConflictByFluidInputs(recipeMap, inputs, fluidInputs);
    }

    @Optional.Method(modid="gregtech")
    private static boolean findConflictByFluidInputs(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        for (FluidStack fluid : fluidInputs) {
            Collection recipes;
            if (fluid == null || (recipes = recipeMap.getRecipesForFluid(fluid)) == null) continue;
            for (Recipe recipe : recipes) {
                if (!GTCERecipeHelper.isRecipeConflict(recipe, inputs, fluidInputs)) continue;
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="gregtech")
    private static boolean findConflictByInputs(RecipeMap<?> recipeMap, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        for (Recipe recipe : recipeMap.getRecipeList()) {
            if (!GTCERecipeHelper.isRecipeConflict(recipe, inputs, fluidInputs)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="gregtech")
    private static boolean isRecipeConflict(Recipe recipe, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        block0: for (ItemStack itemStack : inputs) {
            for (CountableIngredient ingredient : recipe.getInputs()) {
                if (!ingredient.getIngredient().apply(itemStack)) continue;
                continue block0;
            }
            return false;
        }
        block2: for (FluidStack fluidStack : fluidInputs) {
            for (FluidStack fluid : recipe.getFluidInputs()) {
                if (!fluidStack.isFluidEqual(fluid)) continue;
                continue block2;
            }
            return false;
        }
        return true;
    }

    private static boolean isPlateRecipe(BasicRecipe recipe) {
        ItemStack output = (ItemStack)recipe.getItemProducts().get(0).getStack();
        return output != null && OreDictHelper.hasOrePrefix(output, "plate", "plateDense");
    }

    @Optional.Method(modid="gregtech")
    private static MetaItem.MetaValueItem getIngotFormerMold(BasicRecipe recipe) {
        ItemStack output = (ItemStack)recipe.getItemProducts().get(0).getStack();
        if (output != null) {
            if (OreDictHelper.hasOrePrefix(output, "ingot")) {
                return MetaItems.SHAPE_MOLD_INGOT;
            }
            if (OreDictHelper.hasOrePrefix(output, "block")) {
                return MetaItems.SHAPE_MOLD_BLOCK;
            }
        }
        return MetaItems.SHAPE_MOLD_BALL;
    }
}

