/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.item.IInfoItem;
import nc.util.InfoHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NCItem
extends Item
implements IInfoItem {
    private final TextFormatting fixedColor;
    private final TextFormatting infoColor;
    private final String[] fixedTooltip;
    private final String[] tooltip;
    public String[] fixedInfo;
    public String[] info;

    public NCItem(TextFormatting fixedColor, String[] fixedTooltip, TextFormatting infoColor, String ... tooltip) {
        this.fixedColor = fixedColor;
        this.fixedTooltip = fixedTooltip;
        this.infoColor = infoColor;
        this.tooltip = tooltip;
    }

    public NCItem(TextFormatting infoColor, String ... tooltip) {
        this(TextFormatting.RED, InfoHelper.EMPTY_ARRAY, infoColor, tooltip);
    }

    public NCItem(String ... tooltip) {
        this(TextFormatting.RED, InfoHelper.EMPTY_ARRAY, TextFormatting.AQUA, tooltip);
    }

    @Override
    public void setInfo() {
        this.fixedInfo = InfoHelper.buildFixedInfo(this.func_77658_a(), this.fixedTooltip);
        this.info = InfoHelper.buildInfo(this.func_77658_a(), this.tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> currentTooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, currentTooltip, flag);
        if (this.fixedInfo.length > 0 || this.info.length > 0) {
            InfoHelper.infoFull(currentTooltip, this.fixedColor, this.fixedInfo, this.infoColor, this.info);
        }
    }

    protected ActionResult<ItemStack> actionResult(boolean success, ItemStack stack) {
        return new ActionResult(success ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
    }

    protected boolean isStackOnHotbar(ItemStack itemStack, EntityPlayer player) {
        for (ItemStack hotbarStack : player.field_71071_by.field_70462_a.subList(0, 9)) {
            if (!itemStack.func_77969_a(hotbarStack)) continue;
            return true;
        }
        return false;
    }

    protected boolean isStackInInventory(ItemStack itemStack, EntityPlayer player) {
        for (ItemStack hotbarStack : player.field_71071_by.field_70462_a) {
            if (!itemStack.func_77969_a(hotbarStack)) continue;
            return true;
        }
        return false;
    }
}

