/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.rtg;

import nc.config.NCConfig;
import nc.multiblock.rtg.tile.TileRTG;
import net.minecraft.tileentity.TileEntity;

public enum RTGType {
    URANIUM(0, 2.25E-10),
    PLUTONIUM(1, 0.0115),
    AMERICIUM(2, 0.00235),
    CALIFORNIUM(3, 0.0765);

    private int id;
    private double radiation;

    private RTGType(int id, double radiation) {
        this.id = id;
        this.radiation = radiation;
    }

    public int getPower() {
        return NCConfig.rtg_power[this.id];
    }

    public double getRadiation() {
        return this.radiation / 8.0;
    }

    public TileEntity getTile() {
        switch (this) {
            case URANIUM: {
                return new TileRTG.Uranium();
            }
            case PLUTONIUM: {
                return new TileRTG.Plutonium();
            }
            case AMERICIUM: {
                return new TileRTG.Americium();
            }
            case CALIFORNIUM: {
                return new TileRTG.Californium();
            }
        }
        return null;
    }
}

