/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.tile;

import javax.annotation.Nullable;
import nc.block.tile.IDynamicState;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.tile.ITile;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileBeefAbstract
extends TileEntity
implements ITile {
    private boolean isRedstonePowered = false;
    private boolean alternateComparator = false;
    private boolean redstoneControl = false;
    private final IRadiationSource radiation = new RadiationSource(0.0);

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.refreshIsRedstonePowered(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
            this.updateComparatorOutputLevel();
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public int getTileBlockMeta() {
        return this.func_145832_p();
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145838_q() == null ? null : new TextComponentTranslation(this.func_145838_q().func_149732_F(), new Object[0]);
    }

    public boolean shouldRefresh(World worldIn, BlockPos posIn, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        BlockPos position = this.field_174879_c;
        if (this.field_145850_b.func_175625_s(position) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public final void markTileDirty() {
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.func_145832_p();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    @Override
    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    @Override
    public void setIsRedstonePowered(boolean isRedstonePowered) {
        this.isRedstonePowered = isRedstonePowered;
    }

    @Override
    public boolean getAlternateComparator() {
        return this.alternateComparator;
    }

    @Override
    public void setAlternateComparator(boolean alternate) {
        this.alternateComparator = alternate;
    }

    @Override
    public boolean getRedstoneControl() {
        return this.redstoneControl;
    }

    @Override
    public void setRedstoneControl(boolean redstoneControl) {
        this.redstoneControl = redstoneControl;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)IRadiationSource.CAPABILITY_RADIATION_SOURCE.cast((Object)this.radiation);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean canOpenGui(World worldIn, BlockPos posistion, IBlockState state) {
        return false;
    }

    public boolean openGui(Object mod, EntityPlayer player, int guiId) {
        player.openGui(mod, guiId, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.writeAll(data);
        this.syncDataTo(data, SyncReason.FullSync);
        return data;
    }

    public NBTTagCompound writeAll(NBTTagCompound data) {
        data.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        data.func_74757_a("alternateComparator", this.alternateComparator);
        data.func_74757_a("redstoneControl", this.redstoneControl);
        if (this.shouldSaveRadiation()) {
            this.writeRadiation(data);
        }
        return data;
    }

    public NBTTagCompound writeRadiation(NBTTagCompound data) {
        data.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.readAll(data);
        this.syncDataFrom(data, SyncReason.FullSync);
    }

    public void readAll(NBTTagCompound data) {
        this.isRedstonePowered = data.func_74767_n("isRedstonePowered");
        this.alternateComparator = data.func_74767_n("alternateComparator");
        this.redstoneControl = data.func_74767_n("redstoneControl");
        if (this.shouldSaveRadiation()) {
            this.readRadiation(data);
        }
    }

    public void readRadiation(NBTTagCompound data) {
        if (data.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(data.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189515_b(new NBTTagCompound());
        this.writeAll(data);
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return data;
    }

    public void handleUpdateTag(NBTTagCompound data) {
        super.func_145839_a(data);
        this.readAll(data);
        this.syncDataFrom(data, SyncReason.NetworkUpdate);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = super.func_189515_b(new NBTTagCompound());
        this.writeAll(data);
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), data);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound data = packet.func_148857_g();
        super.func_145839_a(data);
        this.readAll(data);
        this.syncDataFrom(data, SyncReason.NetworkUpdate);
        if (this.func_145838_q() instanceof IDynamicState) {
            this.notifyBlockUpdate();
        }
    }

    protected abstract void syncDataFrom(NBTTagCompound var1, SyncReason var2);

    protected abstract void syncDataTo(NBTTagCompound var1, SyncReason var2);

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return NCMath.sq(16.0 * (double)FMLClientHandler.instance().getClient().field_71474_y.field_151451_c);
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;

    }
}

