/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.multiblock.PlacementRule;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.ITurbinePart;
import nc.multiblock.turbine.tile.TileTurbineCoilConnector;
import nc.multiblock.turbine.tile.TileTurbineDynamoCoil;
import nc.multiblock.turbine.tile.TileTurbineDynamoPart;
import nc.multiblock.turbine.tile.TileTurbinePart;
import nc.multiblock.turbine.tile.TileTurbineRotorBearing;
import nc.util.StringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class TurbinePlacement {
    public static final List<PlacementRule.RuleParser<Turbine, ITurbinePart>> RULE_PARSER_LIST = new LinkedList<PlacementRule.RuleParser<Turbine, ITurbinePart>>();
    public static final Object2ObjectMap<String, String> RULE_MAP_RAW = new Object2ObjectArrayMap();
    public static final Object2ObjectMap<String, PlacementRule<Turbine, ITurbinePart>> RULE_MAP = new PlacementRule.PlacementMap();
    public static final List<PlacementRule.TooltipBuilder<Turbine, ITurbinePart>> TOOLTIP_BUILDER_LIST = new LinkedList<PlacementRule.TooltipBuilder<Turbine, ITurbinePart>>();
    public static PlacementRule.RecipeHandler recipe_handler;
    public static final Object2ObjectMap<String, String> TOOLTIP_MAP;

    public static void preInit() {
        RULE_PARSER_LIST.add(new DefaultRuleParser());
        TOOLTIP_BUILDER_LIST.add(new DefaultTooltipBuilder());
    }

    public static void init() {
        recipe_handler = new RecipeHandler();
        RULE_MAP.put((Object)"", new PlacementRule.Or(new ArrayList()));
        TurbinePlacement.addRule("magnesium_coil", NCConfig.turbine_coil_rule[0], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 0));
        TurbinePlacement.addRule("beryllium_coil", NCConfig.turbine_coil_rule[1], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 1));
        TurbinePlacement.addRule("aluminum_coil", NCConfig.turbine_coil_rule[2], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 2));
        TurbinePlacement.addRule("gold_coil", NCConfig.turbine_coil_rule[3], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 3));
        TurbinePlacement.addRule("copper_coil", NCConfig.turbine_coil_rule[4], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 4));
        TurbinePlacement.addRule("silver_coil", NCConfig.turbine_coil_rule[5], new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 5));
        TurbinePlacement.addRule("connector", NCConfig.turbine_connector_rule[0], new ItemStack(NCBlocks.turbine_coil_connector));
    }

    public static void addRule(String id, String rule, Object ... blocks) {
        RULE_MAP_RAW.put((Object)id, (Object)rule);
        RULE_MAP.put((Object)id, TurbinePlacement.parse(rule));
        for (Object block : blocks) {
            recipe_handler.addRecipe(block, id);
        }
    }

    public static void postInit() {
        for (Object2ObjectMap.Entry entry : RULE_MAP.object2ObjectEntrySet()) {
            for (PlacementRule.TooltipBuilder<Turbine, ITurbinePart> builder : TOOLTIP_BUILDER_LIST) {
                String tooltip = builder.buildTooltip((PlacementRule)entry.getValue());
                if (tooltip == null) continue;
                TOOLTIP_MAP.put(entry.getKey(), (Object)tooltip);
            }
        }
    }

    public static PlacementRule<Turbine, ITurbinePart> parse(String string) {
        return PlacementRule.parse(string, RULE_PARSER_LIST);
    }

    public static boolean isCasing(Turbine turbine, BlockPos pos) {
        TileEntity tile = turbine.WORLD.func_175625_s(pos);
        return tile instanceof TileTurbinePart && ((TileTurbinePart)tile).getPartPositionType().isGoodForWall();
    }

    public static boolean isRotorBearing(Turbine turbine, BlockPos pos) {
        return turbine.getPartMap(TileTurbineRotorBearing.class).get(pos.func_177986_g()) != null;
    }

    public static boolean isCoilConnector(Turbine turbine, BlockPos pos) {
        TileTurbineDynamoPart part = (TileTurbineDynamoPart)turbine.getPartMap(TileTurbineDynamoPart.class).get(pos.func_177986_g());
        return part instanceof TileTurbineCoilConnector && part.isInValidPosition;
    }

    public static boolean isDynamoCoil(Turbine turbine, BlockPos pos, String coilName) {
        TileTurbineDynamoPart part = (TileTurbineDynamoPart)turbine.getPartMap(TileTurbineDynamoPart.class).get(pos.func_177986_g());
        return part instanceof TileTurbineDynamoCoil && part.isInValidPosition && (coilName.equals("any") || part.partName.equals(coilName));
    }

    static {
        TOOLTIP_MAP = new Object2ObjectOpenHashMap();
    }

    public static class RecipeHandler
    extends PlacementRule.RecipeHandler {
        public RecipeHandler() {
            super("turbine");
        }
    }

    public static class DefaultTooltipBuilder
    extends PlacementRule.DefaultTooltipBuilder<Turbine, ITurbinePart> {
    }

    public static class AdjacentCoil
    extends Adjacent {
        protected final String coilType;

        public AdjacentCoil(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String coilType) {
            super(coilType + "_coil", amount, countType, adjType);
            this.coilType = coilType;
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            super.checkIsRuleAllowed(ruleID);
            if (this.countType != PlacementRule.CountType.AT_LEAST && this.coilType.equals("any")) {
                throw new IllegalArgumentException((this.countType == PlacementRule.CountType.EXACTLY ? "Exact 'any coil'" : "'At most n of any coil'") + " placement rule with ID \"" + ruleID + "\" is disallowed due to potential ambiguity during rule checks!");
            }
        }

        @Override
        public boolean satisfied(ITurbinePart part, EnumFacing dir) {
            return TurbinePlacement.isDynamoCoil((Turbine)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.coilType);
        }
    }

    public static class AdjacentConnector
    extends Adjacent {
        public AdjacentConnector(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("connector", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(ITurbinePart part, EnumFacing dir) {
            return TurbinePlacement.isCoilConnector((Turbine)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentBearing
    extends Adjacent {
        public AdjacentBearing(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("bearing", amount, countType, adjType);
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            if (this.amount > 1) {
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can not require more than one rotor bearing!");
            }
            super.checkIsRuleAllowed(ruleID);
        }

        @Override
        public boolean satisfied(ITurbinePart part, EnumFacing dir) {
            return TurbinePlacement.isRotorBearing((Turbine)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentCasing
    extends Adjacent {
        public AdjacentCasing(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("turbine_casing", amount, countType, adjType);
        }

        @Override
        public boolean satisfied(ITurbinePart part, EnumFacing dir) {
            return TurbinePlacement.isCasing((Turbine)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static abstract class Adjacent
    extends PlacementRule.Adjacent<Turbine, ITurbinePart> {
        public Adjacent(String dependency, int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super(dependency, amount, countType, adjType);
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            if (this.amount > 4) {
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can not require more than four adjacencies!");
            }
            if (this.adjType == PlacementRule.AdjacencyType.VERTEX) {
                throw new IllegalArgumentException("Vertex adjacency placement rule with ID \"" + ruleID + "\" is disallowed as turbine dynamos have no depth!");
            }
            super.checkIsRuleAllowed(ruleID);
        }
    }

    public static class DefaultRuleParser
    extends PlacementRule.DefaultRuleParser<Turbine, ITurbinePart> {
        @Override
        @Nullable
        protected PlacementRule<Turbine, ITurbinePart> partialParse(String s) {
            PlacementRule.AdjacencyType adjType;
            PlacementRule.CountType countType;
            s = s.toLowerCase(Locale.ROOT);
            s = s.replaceAll("at exactly one vertex", "vertex");
            boolean exact = s.contains("exact");
            boolean atMost = s.contains("at most");
            boolean axial = s.contains("axial");
            boolean vertex = s.contains("vertex");
            boolean edge = s.contains("edge");
            if (exact && atMost || axial && vertex) {
                return null;
            }
            s = s.replaceAll("at least", "");
            s = s.replaceAll("exactly", "");
            s = s.replaceAll("exact", "");
            s = s.replaceAll("at most", "");
            s = s.replaceAll("axially", "");
            s = s.replaceAll("axial", "");
            s = s.replaceAll("at one vertex", "");
            s = s.replaceAll("at a vertex", "");
            s = s.replaceAll("at vertex", "");
            s = s.replaceAll("vertex", "");
            s = s.replaceAll("at one edge", "");
            s = s.replaceAll("at an edge", "");
            s = s.replaceAll("at edge", "");
            s = s.replaceAll("along one edge", "");
            s = s.replaceAll("along an edge", "");
            s = s.replaceAll("along edge", "");
            s = s.replaceAll("edge", "");
            int amount = -1;
            String rule = null;
            String type = null;
            String[] split = s.split(Pattern.quote(" "));
            for (int i = 0; i < split.length; ++i) {
                if (StringHelper.NUMBER_S2I_MAP.containsKey((Object)split[i])) {
                    amount = StringHelper.NUMBER_S2I_MAP.getInt((Object)split[i]);
                    continue;
                }
                if (rule != null) continue;
                if (split[i].contains("wall") || split[i].contains("casing")) {
                    rule = "casing";
                    continue;
                }
                if (split[i].contains("bearing")) {
                    rule = "bearing";
                    continue;
                }
                if (split[i].contains("connector")) {
                    rule = "connector";
                    continue;
                }
                if (!split[i].contains("coil")) continue;
                rule = "coil";
                if (i > 0) {
                    type = split[i - 1];
                    continue;
                }
                return null;
            }
            if (amount < 0 || rule == null) {
                return null;
            }
            PlacementRule.CountType countType2 = exact ? PlacementRule.CountType.EXACTLY : (countType = atMost ? PlacementRule.CountType.AT_MOST : PlacementRule.CountType.AT_LEAST);
            PlacementRule.AdjacencyType adjacencyType = axial ? PlacementRule.AdjacencyType.AXIAL : (vertex ? PlacementRule.AdjacencyType.VERTEX : (adjType = edge ? PlacementRule.AdjacencyType.EDGE : PlacementRule.AdjacencyType.STANDARD));
            if (rule.equals("casing")) {
                return new AdjacentCasing(amount, countType, adjType);
            }
            if (rule.equals("bearing")) {
                return new AdjacentBearing(amount, countType, adjType);
            }
            if (rule.equals("connector")) {
                return new AdjacentConnector(amount, countType, adjType);
            }
            if (rule.equals("coil")) {
                return new AdjacentCoil(amount, countType, adjType, type);
            }
            return null;
        }
    }
}

