/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine.tile;

import java.util.Iterator;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.block.BlockTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbinePart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TileTurbineRotorBlade
extends TileTurbinePart
implements TurbineRotorBladeUtil.ITurbineRotorBlade<TileTurbineRotorBlade> {
    public TurbineRotorBladeUtil.IRotorBladeType bladeType = null;
    protected TurbineRotorBladeUtil.TurbinePartDir dir = TurbineRotorBladeUtil.TurbinePartDir.Y;

    public TileTurbineRotorBlade() {
        super(CuboidalPartPositionType.INTERIOR);
    }

    public TileTurbineRotorBlade(TurbineRotorBladeUtil.IRotorBladeType bladeType) {
        this();
        this.bladeType = bladeType;
    }

    @Override
    public void onMachineAssembled(Turbine controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public BlockPos bladePos() {
        return this.field_174879_c;
    }

    @Override
    public TurbineRotorBladeUtil.TurbinePartDir getDir() {
        return this.dir;
    }

    @Override
    public void setDir(TurbineRotorBladeUtil.TurbinePartDir newDir) {
        this.dir = newDir;
    }

    @Override
    public IBlockState getRenderState() {
        if (this.func_145838_q() instanceof BlockTurbineRotorBlade) {
            return this.func_145838_q().func_176223_P().func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)this.dir));
        }
        return this.func_145838_q().func_176223_P();
    }

    @Override
    public TurbineRotorBladeUtil.IRotorBladeType getBladeType() {
        return this.bladeType;
    }

    @Override
    public void onBearingFailure(Iterator<TileTurbineRotorBlade> bladeIterator) {
        Turbine turbine = (Turbine)this.getMultiblock();
        if (turbine != null && turbine.rand.nextDouble() < 0.18) {
            bladeIterator.remove();
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + turbine.rand.nextDouble() - 0.5, (double)this.field_174879_c.func_177956_o() + turbine.rand.nextDouble() - 0.5, (double)this.field_174879_c.func_177952_p() + turbine.rand.nextDouble() - 0.5, 4.0f, false);
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.bladeType != null) {
            nbt.func_74778_a("bladeName", this.bladeType.func_176610_l());
            nbt.func_74780_a("bladeEfficiency", this.bladeType.getEfficiency());
            nbt.func_74780_a("bladeExpansionCoefficient", this.bladeType.getExpansionCoefficient());
        }
        nbt.func_74768_a("bladeDir", this.dir.ordinal());
        return nbt;
    }

    @Override
    public void readAll(final NBTTagCompound nbt) {
        super.readAll(nbt);
        if (this.bladeType == null && nbt.func_74764_b("bladeName") && nbt.func_74764_b("bladeEfficiency") && nbt.func_74764_b("bladeExpansionCoefficient")) {
            this.bladeType = new TurbineRotorBladeUtil.IRotorBladeType(){
                final String name;
                final double efficiency;
                final double expansionCoefficient;
                {
                    this.name = nbt.func_74779_i("bladeName");
                    this.efficiency = nbt.func_74769_h("bladeEfficiency");
                    this.expansionCoefficient = nbt.func_74769_h("bladeExpansionCoefficient");
                }

                public String func_176610_l() {
                    return this.name;
                }

                @Override
                public double getEfficiency() {
                    return this.efficiency;
                }

                @Override
                public double getExpansionCoefficient() {
                    return this.expansionCoefficient;
                }
            };
        }
        this.dir = TurbineRotorBladeUtil.TurbinePartDir.values()[nbt.func_74762_e("bladeDir")];
    }

    public static class SicSicCMC
    extends TileTurbineRotorBlade {
        public SicSicCMC() {
            super(TurbineRotorBladeUtil.TurbineRotorBladeType.SIC_SIC_CMC);
        }
    }

    public static class Extreme
    extends TileTurbineRotorBlade {
        public Extreme() {
            super(TurbineRotorBladeUtil.TurbineRotorBladeType.EXTREME);
        }
    }

    public static class Steel
    extends TileTurbineRotorBlade {
        public Steel() {
            super(TurbineRotorBladeUtil.TurbineRotorBladeType.STEEL);
        }
    }
}

