/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.radiation.RadiationHelper;
import nc.tile.radiation.TileGeigerCounter;
import nc.tile.radiation.TileRadiationScrubber;
import nc.util.GuiHelper;
import nc.util.Lang;
import nc.util.TextHelper;
import nc.util.UnitHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RadiationRenders {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final ResourceLocation RADS_BAR = new ResourceLocation("nuclearcraft:textures/hud/rads_bar.png");
    private static final String IMMUNE = Lang.localise("hud.nuclearcraft.rad_immune");
    private static final String IMMUNE_FOR = Lang.localise("hud.nuclearcraft.rad_immune_for");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void addRadiationInfo(RenderGameOverlayEvent.Post event) {
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        EntityPlayerSP player = RadiationRenders.MC.field_71439_g;
        if (!RadiationHelper.shouldShowHUD((EntityPlayer)player)) {
            return;
        }
        IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (playerRads == null) {
            return;
        }
        ScaledResolution res = new ScaledResolution(MC);
        int barWidth = (int)(100.0 * playerRads.getTotalRads() / playerRads.getMaxRads());
        String info = playerRads.isImmune() ? (playerRads.getRadiationImmunityStage() ? IMMUNE : IMMUNE_FOR + " " + UnitHelper.applyTimeUnitShort(playerRads.getRadiationImmunityTime(), 2, 1)) : (playerRads.isRadiationNegligible() ? "0 Rad/t" : RadiationHelper.radsPrefix(playerRads.getRadiationLevel(), true));
        int infoWidth = RadiationRenders.MC.field_71466_p.func_78256_a(info);
        int overlayWidth = (int)Math.round((double)Math.max(104, infoWidth) * NCConfig.radiation_hud_size);
        int overlayHeight = (int)Math.round(19.0 * NCConfig.radiation_hud_size);
        int xPos = (int)Math.round(NCConfig.radiation_hud_position_cartesian.length >= 2 ? NCConfig.radiation_hud_position_cartesian[0] * (double)res.func_78326_a() : (double)GuiHelper.getRenderPositionXFromAngle(res, NCConfig.radiation_hud_position, overlayWidth, 3) / NCConfig.radiation_hud_size);
        int yPos = (int)Math.round(NCConfig.radiation_hud_position_cartesian.length >= 2 ? NCConfig.radiation_hud_position_cartesian[1] * (double)res.func_78328_b() : (double)GuiHelper.getRenderPositionYFromAngle(res, NCConfig.radiation_hud_position, overlayHeight, 3) / NCConfig.radiation_hud_size);
        MC.func_110434_K().func_110577_a(RADS_BAR);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)NCConfig.radiation_hud_size, (double)NCConfig.radiation_hud_size, (double)1.0);
        RadiationRenders.drawTexturedModalRect(xPos, yPos, 0, 0, 104, 10);
        RadiationRenders.drawTexturedModalRect(xPos + 2 + 100 - barWidth, yPos + 2, 100 - barWidth, 10, barWidth, 6);
        yPos += 12;
        if (NCConfig.radiation_hud_text_outline) {
            RadiationRenders.MC.field_71466_p.func_78276_b(info, xPos + 1 + (104 - infoWidth) / 2, yPos, 0);
            RadiationRenders.MC.field_71466_p.func_78276_b(info, xPos - 1 + (104 - infoWidth) / 2, yPos, 0);
            RadiationRenders.MC.field_71466_p.func_78276_b(info, xPos + (104 - infoWidth) / 2, yPos + 1, 0);
            RadiationRenders.MC.field_71466_p.func_78276_b(info, xPos + (104 - infoWidth) / 2, yPos - 1, 0);
        }
        RadiationRenders.MC.field_71466_p.func_78276_b(info, xPos + (104 - infoWidth) / 2, yPos, playerRads.isImmune() ? 0x55FF55 : TextHelper.T2I_MAP.getInt((Object)RadiationHelper.getRadiationTextColor(playerRads)));
        GlStateManager.func_179121_F();
    }

    private static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)(x + 0), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        TileEntity te;
        boolean chunkBorders = false;
        if (!NCConfig.radiation_chunk_boundaries) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack heldStack = RadiationRenders.MC.field_71439_g.func_184586_b(hand);
            Item heldItem = heldStack.func_77973_b();
            if (NCItems.geiger_counter != heldItem && Item.func_150898_a((Block)NCBlocks.geiger_block) != heldItem && Item.func_150898_a((Block)NCBlocks.radiation_scrubber) != heldItem) continue;
            chunkBorders = true;
            break;
        }
        if (!chunkBorders && RadiationRenders.MC.field_71476_x != null && RadiationRenders.MC.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && ((te = RadiationRenders.MC.field_71441_e.func_175625_s(RadiationRenders.MC.field_71476_x.func_178782_a())) instanceof TileGeigerCounter || te instanceof TileRadiationScrubber)) {
            chunkBorders = true;
        }
        if (chunkBorders) {
            EntityPlayerSP player = RadiationRenders.MC.field_71439_g;
            double px = TileEntityRendererDispatcher.field_147554_b;
            double py = TileEntityRendererDispatcher.field_147555_c;
            double pz = TileEntityRendererDispatcher.field_147552_d;
            int chunkX = (int)player.field_70165_t >> 4 << 4;
            int chunkZ = (int)player.field_70161_v >> 4 << 4;
            int y = Math.min((int)player.field_70163_u - 2, player.func_130014_f_().func_72964_e(chunkX, chunkZ).func_177442_v());
            float h = (float)Math.max(32.0, player.field_70163_u - (double)y + 8.0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179103_j((int)7425);
            float r = 255.0f;
            float g = 0.0f;
            float b = 0.0f;
            builder.func_178969_c((double)chunkX - px, (double)(y + 2) - py, (double)chunkZ - pz);
            GlStateManager.func_187441_d((float)5.0f);
            builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            builder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, (double)h, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, (double)h, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 0.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, (double)h, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, 0.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, (double)h, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, 2.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 2.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, 2.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, 2.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(0.0, 2.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 2.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 2.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            builder.func_181662_b(16.0, 2.0, 16.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
            tessellator.func_78381_a();
            builder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
        }
    }
}

