/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidStackHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class FluidIngredient
implements IFluidIngredient {
    public FluidStack stack;
    public String fluidName;

    public FluidIngredient(FluidStack stack) {
        this.stack = stack;
        this.fluidName = FluidStackHelper.getFluidName(stack);
    }

    public FluidIngredient(String fluidName, int amount) {
        this.stack = FluidRegistry.getFluidStack((String)fluidName, (int)amount);
        this.fluidName = fluidName;
    }

    @Override
    public FluidStack getStack() {
        return this.stack == null ? null : this.stack.copy();
    }

    @Override
    public List<FluidStack> getInputStackList() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.stack});
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.stack});
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.stack == null ? 0 : this.stack.amount;
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.stack.amount = stackSize;
    }

    @Override
    public String getIngredientName() {
        return this.fluidName;
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.fluidName;
    }

    @Override
    public IntList getFactors() {
        return new IntArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{this.stack.amount}));
    }

    @Override
    public IFluidIngredient getFactoredIngredient(int factor) {
        FluidStack newStack = this.stack.copy();
        newStack.amount = this.stack.amount / factor;
        return new FluidIngredient(newStack);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption type) {
        if (object instanceof Tank) {
            object = ((Tank)((Object)object)).getFluid();
        }
        if (object instanceof FluidStack) {
            FluidStack fluidstack = (FluidStack)object;
            if (!fluidstack.isFluidEqual(this.stack) || !FluidStack.areFluidStackTagsEqual((FluidStack)fluidstack, (FluidStack)this.stack)) {
                return IngredientMatchResult.FAIL;
            }
            return new IngredientMatchResult(type.checkStackSize(this.stack.amount, fluidstack.amount), 0);
        }
        if (object instanceof FluidIngredient && this.match(((FluidIngredient)object).stack, type).matches()) {
            return new IngredientMatchResult(type.checkStackSize(this.getMaxStackSize(0), ((FluidIngredient)object).getMaxStackSize(0)), 0);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.stack != null;
    }

    @Override
    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        return CraftTweakerMC.getILiquidStack((FluidStack)this.stack);
    }
}

