/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SolidFissionRecipes
extends BasicRecipeHandler {
    public SolidFissionRecipes() {
        super("solid_fission", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addFuelDepleteRecipes(NCConfig.fission_thorium_fuel_time, NCConfig.fission_thorium_heat_generation, NCConfig.fission_thorium_efficiency, NCConfig.fission_thorium_criticality, NCConfig.fission_thorium_decay_factor, NCConfig.fission_thorium_self_priming, NCConfig.fission_thorium_radiation, "TBU");
        this.addFuelDepleteRecipes(NCConfig.fission_uranium_fuel_time, NCConfig.fission_uranium_heat_generation, NCConfig.fission_uranium_efficiency, NCConfig.fission_uranium_criticality, NCConfig.fission_uranium_decay_factor, NCConfig.fission_uranium_self_priming, NCConfig.fission_uranium_radiation, "LEU233", "HEU233", "LEU235", "HEU235");
        this.addFuelDepleteRecipes(NCConfig.fission_neptunium_fuel_time, NCConfig.fission_neptunium_heat_generation, NCConfig.fission_neptunium_efficiency, NCConfig.fission_neptunium_criticality, NCConfig.fission_neptunium_decay_factor, NCConfig.fission_neptunium_self_priming, NCConfig.fission_neptunium_radiation, "LEN236", "HEN236");
        this.addFuelDepleteRecipes(NCConfig.fission_plutonium_fuel_time, NCConfig.fission_plutonium_heat_generation, NCConfig.fission_plutonium_efficiency, NCConfig.fission_plutonium_criticality, NCConfig.fission_plutonium_decay_factor, NCConfig.fission_plutonium_self_priming, NCConfig.fission_plutonium_radiation, "LEP239", "HEP239", "LEP241", "HEP241");
        this.addFuelDepleteRecipes(NCConfig.fission_mixed_fuel_time, NCConfig.fission_mixed_heat_generation, NCConfig.fission_mixed_efficiency, NCConfig.fission_mixed_criticality, NCConfig.fission_mixed_decay_factor, NCConfig.fission_mixed_self_priming, NCConfig.fission_mixed_radiation, "MIX239", "MIX241");
        this.addFuelDepleteRecipes(NCConfig.fission_americium_fuel_time, NCConfig.fission_americium_heat_generation, NCConfig.fission_americium_efficiency, NCConfig.fission_americium_criticality, NCConfig.fission_americium_decay_factor, NCConfig.fission_americium_self_priming, NCConfig.fission_americium_radiation, "LEA242", "HEA242");
        this.addFuelDepleteRecipes(NCConfig.fission_curium_fuel_time, NCConfig.fission_curium_heat_generation, NCConfig.fission_curium_efficiency, NCConfig.fission_curium_criticality, NCConfig.fission_curium_decay_factor, NCConfig.fission_curium_self_priming, NCConfig.fission_curium_radiation, "LECm243", "HECm243", "LECm245", "HECm245", "LECm247", "HECm247");
        this.addFuelDepleteRecipes(NCConfig.fission_berkelium_fuel_time, NCConfig.fission_berkelium_heat_generation, NCConfig.fission_berkelium_efficiency, NCConfig.fission_berkelium_criticality, NCConfig.fission_berkelium_decay_factor, NCConfig.fission_berkelium_self_priming, NCConfig.fission_berkelium_radiation, "LEB248", "HEB248");
        this.addFuelDepleteRecipes(NCConfig.fission_californium_fuel_time, NCConfig.fission_californium_heat_generation, NCConfig.fission_californium_efficiency, NCConfig.fission_californium_criticality, NCConfig.fission_californium_decay_factor, NCConfig.fission_californium_self_priming, NCConfig.fission_californium_radiation, "LECf249", "HECf249", "LECf251", "HECf251");
        this.addRecipe(RegistryHelper.itemStackFromRegistry("ic2:nuclear:0", 1), "depletedFuelIC2U", (int)((double)NCConfig.fission_uranium_fuel_time[11] * 19.0 / 6.0), (int)((double)NCConfig.fission_uranium_heat_generation[11] * 18.0 / 19.0), NCConfig.fission_uranium_efficiency[11], NCConfig.fission_uranium_criticality[11], NCConfig.fission_uranium_decay_factor[11], false, NCConfig.fission_uranium_radiation[11] * 18.0 / 19.0);
        this.addRecipe(RegistryHelper.itemStackFromRegistry("ic2:nuclear:4", 1), "depletedFuelIC2MOX", (int)((double)NCConfig.fission_mixed_fuel_time[1] * 7.0 * 3.0), (int)((double)NCConfig.fission_mixed_heat_generation[1] * 9.0 / 7.0), NCConfig.fission_mixed_efficiency[1], NCConfig.fission_mixed_criticality[1], NCConfig.fission_mixed_decay_factor[1], false, NCConfig.fission_mixed_radiation[1] * 9.0 / 7.0);
        this.addRecipe(SolidFissionRecipes.getYelloriumIngredient(), "ingotCyanite", (int)((double)NCConfig.fission_uranium_fuel_time[11] * 0.5 * 9.0 / 8.0), (int)((double)NCConfig.fission_uranium_heat_generation[11] * 8.0 / 9.0), NCConfig.fission_uranium_efficiency[11], NCConfig.fission_uranium_criticality[11], NCConfig.fission_uranium_decay_factor[11], false, NCConfig.fission_uranium_radiation[11] * 8.0 / 9.0);
    }

    public void addFuelDepleteRecipes(int[] time, int[] heat, double[] efficiency, int[] criticality, double[] decayFactor, boolean[] selfPriming, double[] radiation, String ... fuelTypes) {
        int id = 0;
        for (String fuelType : fuelTypes) {
            this.addRecipe("ingot" + fuelType + "Oxide", "ingotDepleted" + fuelType + "Oxide", time[id + 1], heat[id + 1], efficiency[id + 1], criticality[id + 1], decayFactor[id + 1], selfPriming[id + 1], radiation[id + 1]);
            this.addRecipe("ingot" + fuelType + "Nitride", "ingotDepleted" + fuelType + "Nitride", time[id + 2], heat[id + 2], efficiency[id + 2], criticality[id + 2], decayFactor[id + 2], selfPriming[id + 2], radiation[id + 2]);
            this.addRecipe("ingot" + fuelType + "ZA", "ingotDepleted" + fuelType + "ZA", time[id + 3], heat[id + 3], efficiency[id + 3], criticality[id + 3], decayFactor[id + 3], selfPriming[id + 3], radiation[id + 3]);
            id += 5;
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(7);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Integer ? (Integer)extras.get(0) : 1);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Integer ? (Integer)extras.get(1) : 0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        fixed.add(extras.size() > 3 && extras.get(3) instanceof Integer ? (Integer)extras.get(3) : 1);
        fixed.add(extras.size() > 4 && extras.get(4) instanceof Double ? (Double)extras.get(4) : 0.0);
        fixed.add(extras.size() > 5 && extras.get(5) instanceof Boolean ? (Boolean)extras.get(5) : false);
        fixed.add(extras.size() > 6 && extras.get(6) instanceof Double ? (Double)extras.get(6) : 0.0);
        return fixed;
    }

    private static ItemArrayIngredient getYelloriumIngredient() {
        ObjectOpenHashSet yellorium = new ObjectOpenHashSet((Collection)OreDictionary.getOres((String)"ingotYellorium", (boolean)false));
        yellorium.addAll((Collection)OreDictionary.getOres((String)"ingotBlutonium", (boolean)false));
        ArrayList<IItemIngredient> ingredients = new ArrayList<IItemIngredient>();
        for (ItemStack stack : yellorium) {
            if (OreDictHelper.isOreMember(stack, "ingotUranium") || OreDictHelper.isOreMember(stack, "ingotPlutonium")) continue;
            ingredients.add(new ItemIngredient(stack));
        }
        return new ItemArrayIngredient(ingredients);
    }
}

