/*
 * Decompiled with CFR 0.152.
 */
package nc.render;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import nc.NuclearCraft;
import nc.util.NCMath;
import nc.util.NCRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockHighlightHandler {
    LongList expiredCache = new LongArrayList();

    private static Long2LongMap getHighlightMap() {
        return NuclearCraft.instance.blockOverlayTracker.getHighlightMap();
    }

    @SubscribeEvent
    public void highlightBlocks(RenderWorldLastEvent event) {
        for (Long2LongMap.Entry entry : BlockHighlightHandler.getHighlightMap().long2LongEntrySet()) {
            this.highlightBlock(event, entry);
        }
        ObjectIterator objectIterator = this.expiredCache.iterator();
        while (objectIterator.hasNext()) {
            long expired = (Long)objectIterator.next();
            BlockHighlightHandler.getHighlightMap().remove(expired);
        }
        this.expiredCache.clear();
    }

    public void highlightBlock(RenderWorldLastEvent event, Long2LongMap.Entry entry) {
        BlockPos pos = BlockPos.func_177969_a((long)entry.getLongKey());
        if (pos == null) {
            this.expiredCache.add(entry.getLongKey());
            return;
        }
        long time = System.currentTimeMillis();
        if (time > entry.getLongValue()) {
            this.expiredCache.add(entry.getLongKey());
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double relativeX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double relativeY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double relativeZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        float r = (float)NCMath.trapezoidalWave((double)time * 0.18, 0.0);
        float g = (float)NCMath.trapezoidalWave((double)time * 0.18, 120.0);
        float b = (float)NCMath.trapezoidalWave((double)time * 0.18, 240.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179137_b((double)(-relativeX), (double)(-relativeY), (double)(-relativeZ));
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        NCRenderHelper.renderBlockFrame(pos, r, g, b, 1.0f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }
}

