/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class NCMath {
    public static final double SQRT2 = 1.4142135623730951;
    public static final double INV_SQRT2 = 0.7071067811865476;
    public static final double LN2 = 0.6931471805599453;
    public static final double LN10 = 2.302585092994046;
    private static Random rand = new Random();

    public static long clamp(long num, long min, long max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static int sq(int number) {
        return number * number;
    }

    public static double sq(double number) {
        return number * number;
    }

    public static int cube(int number) {
        return number * number * number;
    }

    public static double cube(double number) {
        return number * number * number;
    }

    public static int getBit(int number, int position) {
        return number >> position & 1;
    }

    public static int onlyBits(int number, int ... positions) {
        int out = 0;
        for (int position : positions) {
            int bit = NCMath.getBit(number, position);
            if (bit == 0) continue;
            out += 1 << position;
        }
        return out;
    }

    public static int swap(int number, int i, int j) {
        int bit2;
        int bit1 = NCMath.getBit(number, i);
        return bit1 == (bit2 = NCMath.getBit(number, j)) ? number : number ^ (1 << i | 1 << j);
    }

    public static byte[] booleansToBytes(boolean[] arr) {
        byte[] out = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = (byte)(arr[i] ? 1 : 0);
        }
        return out;
    }

    public static boolean[] bytesToBooleans(byte[] arr) {
        boolean[] out = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i] != 0;
        }
        return out;
    }

    public static int kroneckerDelta(int ... indices) {
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == indices[(i + 1) % indices.length]) continue;
            return 0;
        }
        return 1;
    }

    public static double sin_d(double deg) {
        return Math.sin(Math.toRadians(deg));
    }

    public static double cos_d(double deg) {
        return Math.cos(Math.toRadians(deg));
    }

    public static double tan_d(double deg) {
        return Math.tan(Math.toRadians(deg));
    }

    public static double[] cartesianFromSpherical(double r, double theta, double phi) {
        return new double[]{r * NCMath.sin_d(theta) * NCMath.cos_d(phi), r * NCMath.sin_d(theta) * NCMath.sin_d(phi), r * NCMath.cos_d(theta)};
    }

    public static long magnitudeMult(long in, int power) {
        double doubleOut = (double)in * Math.pow(10.0, 1.0 * (double)power);
        return Math.round(doubleOut);
    }

    public static double magnitudeMult(double in, int power) {
        return in * Math.pow(10.0, 1.0 * (double)power);
    }

    public static boolean atIntLimit(int number, int multiplier) {
        return Math.abs(number) > Integer.MAX_VALUE / multiplier;
    }

    public static boolean atLongLimit(long number, long multiplier) {
        return Math.abs(number) > Long.MAX_VALUE / multiplier;
    }

    public static boolean atDoubleLimit(double number, double multiplier) {
        return Math.abs(number) > Double.MAX_VALUE / multiplier;
    }

    public static int numberLength(long number) {
        return String.valueOf(number).length();
    }

    public static int minus1Pow(int pow) {
        return (pow & 1) == 0 ? 1 : -1;
    }

    public static int choose(int n, int k) {
        if (n == k) {
            return 1;
        }
        if (n < k) {
            return NCMath.minus1Pow(k) * NCMath.choose(k - n - 1, k);
        }
        if (k > n - k) {
            k = n - k;
        }
        double x = 1.0;
        int i = 1;
        int m = n;
        while (i <= k) {
            x *= (double)m / (double)i;
            ++i;
            --m;
        }
        return (int)Math.round(x);
    }

    public static int simplexNumber(int n, int p) {
        return NCMath.choose(n + p - 1, p);
    }

    public static double floorTo(double x, double mult) {
        return mult == 0.0 ? x : x - x % mult;
    }

    public static double ceilTo(double x, double mult) {
        if (mult == 0.0) {
            return x;
        }
        double mod = x % mult;
        return mod == 0.0 ? x : x + mult - mod;
    }

    public static double roundTo(double x, double mult) {
        if (mult == 0.0) {
            return x;
        }
        double mod = x % mult;
        return mod >= mult / 2.0 ? x + mult - mod : x - mod;
    }

    public static int getBinomial(int n, int p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            if (rand.nextInt(100) >= p) continue;
            ++x;
        }
        return x;
    }

    public static int hcf(int ... arr) {
        int l = arr.length;
        if (l == 0) {
            return 1;
        }
        if (l == 1) {
            return arr[0];
        }
        int hcf = NCMath.hcfInternal(arr[0], arr[1]);
        if (l == 2) {
            return hcf;
        }
        int[] next = new int[l - 1];
        next[0] = hcf;
        for (int i = 1; i < l - 1; ++i) {
            next[i] = arr[i + 1];
        }
        return NCMath.hcf(next);
    }

    private static int hcfInternal(int a, int b) {
        if (b == 0) {
            return a;
        }
        return NCMath.hcfInternal(b, a % b);
    }

    public static int lcm(int ... arr) {
        int l = arr.length;
        if (l == 0) {
            return 1;
        }
        if (l == 1) {
            return arr[0];
        }
        int lcm = NCMath.lcmInternal(arr[0], arr[1]);
        if (l == 2) {
            return lcm;
        }
        int[] next = new int[l - 1];
        next[0] = lcm;
        for (int i = 1; i < l - 1; ++i) {
            next[i] = arr[i + 1];
        }
        return NCMath.lcm(next);
    }

    private static int lcmInternal(int a, int b) {
        return NCMath.toInt(Math.abs((long)a * (long)b)) / NCMath.hcfInternal(a, b);
    }

    public static int hollowCuboid(int x, int y, int z) {
        return x * y * z - (x - 2) * (y - 2) * (z - 2);
    }

    public static int hollowCube(int length) {
        return NCMath.hollowCuboid(length, length, length);
    }

    public static double trapezoidalWave(double degs, double phase) {
        double angle = degs %= 360.0;
        if ((angle = (angle + phase) % 360.0) <= 60.0) {
            return 1.0;
        }
        if (angle <= 120.0) {
            return (120.0 - angle) / 60.0;
        }
        if (angle <= 240.0) {
            return 0.0;
        }
        if (angle <= 300.0) {
            return (angle - 240.0) / 60.0;
        }
        return 1.0;
    }

    public static String sigFigs(double number, int sigFigs) {
        if (number == (double)((long)number)) {
            return Long.toString((long)number);
        }
        BigDecimal bd = new BigDecimal(number);
        bd = bd.round(new MathContext(Math.max(1, sigFigs)));
        return Double.toString(bd.doubleValue());
    }

    public static String decimalPlaces(double number, int places) {
        if (number == (double)((long)number)) {
            return Long.toString((long)number);
        }
        char[] arr = new char[Math.max(1, places)];
        Arrays.fill(arr, '#');
        DecimalFormat df = new DecimalFormat("0." + new String(arr));
        return df.format(number);
    }

    public static String pcSigFigs(double number, int sigFigs) {
        return NCMath.sigFigs(100.0 * number, sigFigs) + "%";
    }

    public static String pcDecimalPlaces(double number, int places) {
        return NCMath.decimalPlaces(100.0 * number, places) + "%";
    }

    public static int toInt(long value) {
        return (int)NCMath.clamp(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int toInt(double value) {
        return (int)MathHelper.func_151237_a((double)value, (double)-2.147483648E9, (double)2.147483647E9);
    }

    public static int getComparatorSignal(double var, double max, double leeway) {
        return var <= leeway ? 0 : (var >= max - leeway ? 15 : (int)(1.0 + 14.0 * var / max));
    }
}

