/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.mtrm.network;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.doubledoordev.mtrm.network.MessageResponse;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.io.FileUtils;

public class MessageSend
implements IMessage {
    public boolean remove;
    public boolean shapeless;
    public boolean mirrored;
    public String[] data = new String[10];

    public void fromBytes(ByteBuf buf) {
        this.remove = buf.readBoolean();
        this.shapeless = buf.readBoolean();
        this.mirrored = buf.readBoolean();
        this.data = new String[buf.readInt()];
        for (int i = 0; i < this.data.length; ++i) {
            if (!buf.readBoolean()) continue;
            this.data[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.remove);
        buf.writeBoolean(this.shapeless);
        buf.writeBoolean(this.mirrored);
        buf.writeInt(this.data.length);
        for (String item : this.data) {
            boolean tag = item != null && !item.equals("null");
            buf.writeBoolean(tag);
            if (!tag) continue;
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)item);
        }
    }

    private String getMarker(boolean noIngredients) {
        StringBuilder marker = new StringBuilder(25);
        marker.append("//#MARKER ");
        marker.append(this.remove ? "REMOVE" : "ADD");
        if (!noIngredients) {
            marker.append(this.shapeless ? " SHAPELESS" : " SHAPED");
        }
        return marker.toString();
    }

    private String getScript(boolean noIngredients, ArrayList<ArrayList<String>> ingredients) {
        StringBuilder script = new StringBuilder(100);
        script.append("recipes.").append(this.remove ? "remove" : "add");
        if (!noIngredients) {
            script.append(this.shapeless ? "Shapeless" : "Shaped");
        }
        script.append('(').append(this.data[0]);
        if (!noIngredients) {
            script.append(", ");
            if (this.shapeless) {
                script.append(ingredients.get(0).toString());
            } else {
                script.append(ingredients.toString());
            }
        }
        return script.append(");").toString();
    }

    private MessageResponse makeScript() {
        ArrayList<ArrayList<String>> ingredients = new ArrayList<ArrayList<String>>();
        boolean noIngredients = true;
        if (this.shapeless) {
            ArrayList<String> lst = new ArrayList<String>();
            for (int i = 1; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                lst.add(this.data[i]);
            }
            noIngredients = lst.isEmpty();
            ingredients.add(lst);
        } else {
            int i;
            String[][] rawIngredients = new String[][]{new String[3], new String[3], new String[3]};
            boolean[] rowsNull = new boolean[]{true, true, true};
            boolean[] colsNull = new boolean[]{true, true, true};
            for (i = 1; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                int row = (i - 1) / 3;
                int col = (i - 1) % 3;
                noIngredients = false;
                rowsNull[row] = false;
                colsNull[col] = false;
                rawIngredients[row][col] = this.data[i];
            }
            for (i = 0; i < rowsNull.length; ++i) {
                if (rowsNull[i]) continue;
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < colsNull.length; ++j) {
                    if (colsNull[j]) continue;
                    row.add(rawIngredients[i][j]);
                }
                ingredients.add(row);
            }
        }
        if (this.data[0] == null) {
            return new MessageResponse(MessageResponse.Status.NO_OUT, new Object[0]);
        }
        if (!this.remove && noIngredients) {
            return new MessageResponse(MessageResponse.Status.NO_IN, new Object[0]);
        }
        File oldFile = new File("scripts/MineTweakerRecipeMaker/scripts/", "Crafting.zs");
        File file = new File("scripts", "MineTweakerRecipeMaker.zs");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            if (oldFile.exists()) {
                FileUtils.moveFile((File)oldFile, (File)file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println("// File generated by MineTweakerRecipeMaker");
                printWriter.println("//                     READ THIS HEADER BEFORE EDITING ANYTHING");
                printWriter.println("// ================================================================================");
                printWriter.println("//     This file is read and changed by the mod.");
                printWriter.println("//     If you remove/edit any of the markers, IT WILL STOP WORKING!");
                printWriter.println("//     If you want to make manual edits, make a backup of this file!");
                printWriter.println("//     Markers look like this: \"//#MARKER something\"");
                printWriter.println("//     They indicate where calls should be placed, so that MineTweaker does them in the correct order.");
                printWriter.println("//     Removes come first, then stuff is added.");
                printWriter.println("// ================================================================================");
                printWriter.println("//");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER REMOVE");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER REMOVE SHAPELESS");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER REMOVE SHAPED");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER ADD");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER ADD SHAPELESS");
                printWriter.println();
                printWriter.println("// ================================================================================");
                printWriter.println("//#MARKER ADD SHAPED");
                printWriter.println();
                printWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            String marker = this.getMarker(noIngredients);
            List lines = FileUtils.readLines((File)file);
            ListIterator<String> i = lines.listIterator();
            while (i.hasNext()) {
                String line = (String)i.next();
                if (!line.equals(marker)) continue;
                i.add(this.getScript(noIngredients, ingredients));
                break;
            }
            if (!i.hasNext()) {
                return new MessageResponse(MessageResponse.Status.WRITE_ERROR, "Cannot find " + marker + " . Did you edit the file manually?");
            }
            FileUtils.writeLines((File)file, (Collection)lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new MessageResponse(MessageResponse.Status.WRITE_ERROR, e.toString());
        }
        return new MessageResponse(MessageResponse.Status.OK, new Object[0]);
    }

    public static class Handler
    implements IMessageHandler<MessageSend, IMessage> {
        public IMessage onMessage(MessageSend message, MessageContext ctx) {
            return message.makeScript();
        }
    }
}

